/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedMaxItems
implements Changed {
    private final Integer oldValue;
    private final Integer newValue;
    private final DiffContext context;

    public ChangedMaxItems(Integer oldValue, Integer newValue, DiffContext context) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.context = context;
    }

    @Override
    public DiffResult isChanged() {
        if (this.oldValue == null && this.newValue == null) {
            return DiffResult.NO_CHANGES;
        }
        if (this.oldValue == null || this.newValue == null) {
            return DiffResult.COMPATIBLE;
        }
        if (this.newValue < this.oldValue) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public Integer getOldValue() {
        return this.oldValue;
    }

    public Integer getNewValue() {
        return this.newValue;
    }

    public DiffContext getContext() {
        return this.context;
    }
}

