/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExampleProcessor;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.SchemaProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParameterProcessor {
    private final ResolverCache cache;
    private final SchemaProcessor schemaProcessor;
    private final ExampleProcessor exampleProcessor;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;

    public ParameterProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, false);
    }

    public ParameterProcessor(ResolverCache cache, OpenAPI openAPI, boolean openapi31) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.schemaProcessor = new SchemaProcessor(cache, openAPI, openapi31);
        this.exampleProcessor = new ExampleProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processParameter(Parameter parameter) {
        Object newRef;
        RefFormat refFormat;
        String $ref = parameter.get$ref();
        if ($ref != null && RefUtils.isAnExternalRefFormat(refFormat = RefUtils.computeRefFormat(parameter.get$ref())) && (newRef = this.externalRefProcessor.processRefToExternalParameter($ref, refFormat)) != null) {
            parameter.set$ref((String)newRef);
        }
        if (parameter.getSchema() != null) {
            this.schemaProcessor.processSchema(parameter.getSchema());
        }
        if (parameter.getExamples() != null) {
            Map<String, Example> examples = parameter.getExamples();
            for (String exampleName : examples.keySet()) {
                Example example = examples.get(exampleName);
                this.exampleProcessor.processExample(example);
            }
        }
        Schema schema = null;
        if (parameter.getContent() != null) {
            Content content = parameter.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                this.schemaProcessor.processSchema(schema);
            }
        }
    }

    public List<Parameter> processParameters(List<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Parameter> processedPathLevelParameters = new ArrayList<Parameter>();
        ArrayList<Object> refParameters = new ArrayList<Object>();
        for (Parameter parameter : parameters) {
            if (parameter.get$ref() != null) {
                RefFormat refFormat = RefUtils.computeRefFormat(parameter.get$ref());
                Parameter resolvedParameter = this.cache.loadRef(parameter.get$ref(), refFormat, Parameter.class);
                if (parameter.get$ref().startsWith("#") && parameter.get$ref().indexOf("#/components/parameters") <= -1) continue;
                if (resolvedParameter == null) {
                    processedPathLevelParameters.add(parameter);
                    continue;
                }
                boolean matched = false;
                for (Parameter param : processedPathLevelParameters) {
                    if (param == null || param.getName() == null || !param.getName().equals(resolvedParameter.getName())) continue;
                    matched = true;
                    break;
                }
                for (Parameter param : parameters) {
                    if (param.getName() == null || !param.getName().equals(resolvedParameter.getName())) continue;
                    matched = true;
                    break;
                }
                if (matched) {
                    refParameters.add(resolvedParameter);
                    continue;
                }
                processedPathLevelParameters.add(resolvedParameter);
                continue;
            }
            processedPathLevelParameters.add(parameter);
        }
        block3: for (Parameter parameter : refParameters) {
            int pos = 0;
            for (Parameter param : processedPathLevelParameters) {
                if (param.getName().equals(parameter.getName())) {
                    processedPathLevelParameters.set(pos, parameter);
                    continue block3;
                }
                ++pos;
            }
        }
        for (Parameter parameter : processedPathLevelParameters) {
            Schema schema = parameter.getSchema();
            if (schema != null) {
                this.schemaProcessor.processSchema(schema);
                continue;
            }
            if (parameter.getContent() == null) continue;
            Content content = parameter.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() != null && (schema = mediaType.getSchema()) != null) {
                    this.schemaProcessor.processSchema(schema);
                }
                if (mediaType.getExamples() == null) continue;
                for (Example ex : mediaType.getExamples().values()) {
                    this.exampleProcessor.processExample(ex);
                }
            }
        }
        return processedPathLevelParameters;
    }
}

