/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.PolicyBase;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;

class PolicyImpl
extends PolicyBase
implements Diagnosable {
    static final String CLASS_NAME = PolicyImpl.class.getName();
    public static final int NUMBER_OF_HITS_PER_INSTANCE = 1000;
    private final Map<String, SpecificStats> mapSpecificStats = new HashMap<String, SpecificStats>();
    private float advisoryPercentTotal = 100.0f;
    private final Random m_rand = new Random(0L);

    PolicyImpl() {
    }

    private long getAttemptedConnRequestCount(String instanceName) {
        SpecificStats stats = this.mapSpecificStats.get(instanceName);
        return null == stats ? 0L : stats.attemptedConnRequestsCount;
    }

    private void incrementAttemptedConnRequestCount(String instanceName) {
        SpecificStats stats = this.mapSpecificStats.get(instanceName);
        if (null == stats) {
            stats = new SpecificStats();
            this.mapSpecificStats.put(instanceName, stats);
        }
        ++stats.attemptedConnRequestsCount;
    }

    @Override
    public Map<OracleDatabaseInstanceInfo, Integer> getCurrentRebalancePolicy() {
        String instanceName;
        StringBuilder sb = new StringBuilder();
        sb.append("Connection rebalancing policy requested: ");
        HashMap<OracleDatabaseInstanceInfo, Integer> currentRebalancePolicy = new HashMap<OracleDatabaseInstanceInfo, Integer>();
        RLBInfo.Frame frame = this.getRLBInfo().getPreviousFrame();
        if (null == frame) {
            sb.append("empty");
            this.trace(Level.FINEST, CLASS_NAME, "getCurrentRebalancePolicy", "{0}", null, null, sb.toString());
            return currentRebalancePolicy;
        }
        float goodGroupSum = 0.0f;
        int totalAttemptedConnRequestsCount = 0;
        int totalConnectionsCount = 0;
        ArrayList<OracleDatabaseInstanceInfo> instancesAlive = new ArrayList<OracleDatabaseInstanceInfo>();
        for (OracleDatabaseInstanceInfo dbInstance : this.getRLBInfo().getInstances()) {
            String instanceName2 = dbInstance.getInstanceName();
            if (1 != dbInstance.status || 4 == dbInstance.flag || 5 == dbInstance.flag) continue;
            instancesAlive.add(dbInstance);
            goodGroupSum += dbInstance.getAdvisoryPercent();
            totalAttemptedConnRequestsCount = (int)((long)totalAttemptedConnRequestsCount + this.getAttemptedConnRequestCount(instanceName2));
            totalConnectionsCount += dbInstance.getNumberOfConnectionsCount();
        }
        this.advisoryPercentTotal = goodGroupSum;
        boolean resetAttempts = false;
        boolean wideBandwidth = true;
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : instancesAlive) {
            int connsPlanned;
            instanceName = oracleDatabaseInstanceInfo.getInstanceName();
            RLBInfo.InstanceStats instanceStats = frame.getStats(instanceName);
            float actualPercent = 100.0f * (float)instanceStats.getConnsBorrowed() / (float)frame.getTotalBorrowed();
            float targetPercent = oracleDatabaseInstanceInfo.getAdvisoryPercent();
            float deltaPercent = targetPercent - actualPercent;
            int connectionsToRebalance = Math.round((float)totalConnectionsCount * deltaPercent / 100.0f);
            long connsNecessary = instanceStats.getConnsBorrowedPeak();
            if (connsNecessary > (long)(connsPlanned = Math.round((float)totalConnectionsCount * targetPercent / 100.0f))) {
                wideBandwidth = false;
                this.trace(Level.FINEST, CLASS_NAME, "getCurrentRebalancePolicy", "{0}: bandwidth is too narrow, rebalance", null, null, instanceName);
            }
            if (connectionsToRebalance > 0) {
                currentRebalancePolicy.put(oracleDatabaseInstanceInfo, connectionsToRebalance);
                continue;
            }
            if (totalAttemptedConnRequestsCount > instancesAlive.size() * 1000) {
                float ACRRatio = (float)this.getAttemptedConnRequestCount(instanceName) / (float)totalAttemptedConnRequestsCount;
                int instConnCount = oracleDatabaseInstanceInfo.getNumberOfConnectionsCount();
                float connRatio = (float)instConnCount / (float)totalConnectionsCount;
                if (connRatio > ACRRatio * 0.75f) {
                    if (connectionsToRebalance < 0) {
                        currentRebalancePolicy.put(oracleDatabaseInstanceInfo, connectionsToRebalance);
                    }
                    resetAttempts = true;
                    continue;
                }
                this.trace(Level.FINEST, CLASS_NAME, "getCurrentRebalancePolicy", "connRatio={0} is less than ACRRatio={1}, condition is under gravitation threshold", null, null, Float.valueOf(connRatio), Float.valueOf(ACRRatio));
                continue;
            }
            this.trace(Level.FINEST, CLASS_NAME, "getCurrentRebalancePolicy", "totalAttemptedConnRequestsCount={0} is lower than a designated gravitation threshold", null, null, totalAttemptedConnRequestsCount);
        }
        if (resetAttempts) {
            this.mapSpecificStats.clear();
            resetAttempts = false;
        }
        if (0 == currentRebalancePolicy.keySet().size()) {
            sb.append("empty");
        } else {
            for (Map.Entry entry : currentRebalancePolicy.entrySet()) {
                instanceName = ((OracleDatabaseInstanceInfo)entry.getKey()).getInstanceName();
                int nconns = (Integer)entry.getValue();
                sb.append("(").append(instanceName).append(", ").append(nconns).append(")");
            }
        }
        this.trace(Level.FINEST, CLASS_NAME, "getCurrentRebalancePolicy", "{0}", null, null, sb.toString());
        if (wideBandwidth) {
            this.trace(Level.FINEST, CLASS_NAME, "getCurrentRebalancePolicy", "wide bandwidth - no rebalance necessary", null, null, new Object[0]);
            return Collections.emptyMap();
        }
        return currentRebalancePolicy;
    }

    @Override
    public FailoverablePooledConnection borrowConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        int violatingFactor;
        RLBInfo.Frame frame = this.getRLBInfo().getCurrentFrame();
        if (null == frame) {
            return null;
        }
        Collection<OracleDatabaseInstanceInfo> instances = this.getRLBInfo().getInstances();
        int numInstances = instances.size();
        boolean[] tried = new boolean[numInstances];
        int violatingInstCount = this.getViolatingInstancesCount();
        int n = violatingFactor = violatingInstCount != 0 ? this.getUpInstancesCount() / violatingInstCount : Integer.MAX_VALUE;
        if (this.advisoryPercentTotal > 0.0f && numInstances > 0) {
            float total = this.advisoryPercentTotal;
            block0: for (int j = 0; j < numInstances; ++j) {
                float percentSum = 0.0f;
                int i = 0;
                float randomPercent = this.m_rand.nextFloat() * total;
                for (OracleDatabaseInstanceInfo dbInstance : this.getRLBInfo().getInstances()) {
                    String instanceName = dbInstance.getInstanceName();
                    int flag = dbInstance.flag;
                    if (!(tried[i] || 1 != flag && 2 != flag && 3 != flag)) {
                        if (3 == flag && violatingFactor > 2) {
                            tried[i] = true;
                            ++i;
                            continue;
                        }
                        if (randomPercent < (percentSum += dbInstance.getAdvisoryPercent())) {
                            FailoverablePooledConnection fpc;
                            if (j == 0) {
                                this.incrementAttemptedConnRequestCount(instanceName);
                            }
                            if (null != (fpc = this.getConnectionsDispatcher().borrowConnection(dbInstance, cri))) {
                                return fpc;
                            }
                            total -= dbInstance.getAdvisoryPercent();
                            tried[i] = true;
                            continue block0;
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private int getViolatingInstancesCount() {
        int violatingCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.getRLBInfo().getInstances()) {
            if (dbInstance.status != 1 || 3 != dbInstance.flag) continue;
            ++violatingCount;
        }
        return violatingCount;
    }

    private int getUpInstancesCount() {
        int upCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.getRLBInfo().getInstances()) {
            if (dbInstance.status != 1) continue;
            ++upCount;
        }
        return upCount;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }

    private static final class SpecificStats {
        long attemptedConnRequestsCount = 0L;

        private SpecificStats() {
        }
    }
}

