/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yrl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "arim\u1ebdniu";
        final String metaValue_bax = "bam\u0169";
        final String metaValue_bn = "b\u1ebdgari";
        final String metaValue_bug = "buginei";
        final String metaValue_chr = "xerok\u00ed";
        final String metaValue_ka = "geurgianu";
        final String metaValue_got = "g\u00fatiku";
        final String metaValue_el = "geregu";
        final String metaValue_he = "heburaiku";
        final String metaValue_jv = "yawanei";
        final String metaValue_ja = "yapunei";
        final String metaValue_km = "kim\u00e9";
        final String metaValue_la = "rat\u0129";
        final String metaValue_ml = "marayara";
        final String metaValue_mn = "m\u0169g\u00fa";
        final String metaValue_my = "birimanei";
        final String metaValue_or = "uri\u00e1";
        final String metaValue_phn = "fin\u00edsiu";
        final String metaValue_si = "s\u0129garei";
        final String metaValue_te = "t\u00e9rugu";
        final String metaValue_tl = "tagaru";
        final String metaValue_th = "tair\u00e3dei";
        final String metaValue_bo = "tibetanu";
        final String metaValue_uga = "ugar\u00edtiku";
        final String metaValue_vai = "wai";
        final String metaValue_type_hc_h12 = "Sist\u1ebdma 24 h\u00fara-ita (1-24)";
        final Object[][] data = new Object[][] {
            { "001", "Iwi" },
            { "002", "Afirika" },
            { "003", "Amerika Nuti su\u00ed" },
            { "005", "Amerika Su su\u00ed" },
            { "009", "Use\u00e3niya" },
            { "011", "Afirika Usid\u1ebdtawara" },
            { "013", "Amerika Piterapura" },
            { "014", "Afirika Uri\u1ebdtawara" },
            { "015", "Afirika Nuti su\u00ed" },
            { "017", "Afirika Piterapura" },
            { "018", "Afirika Meridiyunau" },
            { "019", "America-ita" },
            { "021", "Amerika Set\u1ebdtiriunau" },
            { "029", "Kar\u00edbi" },
            { "030", "\u00c1siya Uri\u1ebdtawara" },
            { "034", "\u00c1siya Meridiyunau" },
            { "035", "Sudeti \u00c1siyatiku" },
            { "039", "Eurupa Meridiyunau" },
            { "053", "Ausitarasia" },
            { "054", "Meran\u00e9siya" },
            { "057", "Micuronesiya Tet\u00e3ma" },
            { "061", "Pulinesiya" },
            { "142", "\u00c1siya" },
            { "143", "\u00c1siya Piterapura" },
            { "145", "\u00c1siya Usid\u1ebdtawara" },
            { "150", "Eurupa" },
            { "151", "Eurupa Uri\u1ebdtawara" },
            { "154", "Eurupa Set\u1ebdtiriunau" },
            { "155", "Eurupa Usid\u1ebdtawara" },
            { "202", "Afirika Subisariana" },
            { "419", "Amerika Latina" },
            { "AC", "Ases\u00e3u Kapu\u00e3ma" },
            { "AD", "\u00c3dura" },
            { "AE", "Emiradu \u00c1rabi Yepewasuwait\u00e1" },
            { "AF", "Afeg\u00e3niret\u00e3ma" },
            { "AG", "\u00c3tigua asu\u00ed Babuda" },
            { "AI", "\u00c3gira" },
            { "AL", "Aub\u00e3niya" },
            { "AM", "Arim\u1ebdniya" },
            { "AO", "\u00c3gura" },
            { "AQ", "\u00c3tartida" },
            { "AR", "Arg\u1ebdtina" },
            { "AS", "Samua Amerikiwara" },
            { "AT", "Ausitiriya" },
            { "AU", "Ausitaraliya" },
            { "AW", "Aruba" },
            { "AX", "Kapu\u00e3ma-ita Ar\u00e3di" },
            { "AZ", "Aseriret\u00e3ma" },
            { "BA", "Businiya asu\u00ed Eseguwina" },
            { "BB", "Babadu" },
            { "BD", "B\u00e3garadexi" },
            { "BE", "Beujika" },
            { "BF", "Bukina Fasu" },
            { "BG", "Bug\u00e1riya" },
            { "BH", "Bar\u1ebdi" },
            { "BI", "Bur\u0169di" },
            { "BJ", "Ben\u0129" },
            { "BL", "S\u00e3 Batulumeu" },
            { "BM", "Bemuda" },
            { "BN", "Burunei" },
            { "BO", "Bur\u00edwia" },
            { "BQ", "Tet\u00e3ma Iwibo\u00ed-ita Kar\u00edbi su\u00ed" },
            { "BR", "Brasiu" },
            { "BS", "Bayama" },
            { "BT", "But\u00e3u" },
            { "BV", "Kapu\u00e3ma Buweti" },
            { "BW", "Butisuwana" },
            { "BY", "Bieru-r\u00fasiya" },
            { "BZ", "Belisi" },
            { "CA", "Kanad\u00e1" },
            { "CC", "Kapu\u00e3ma-ita Kuku (Keering)" },
            { "CD", "K\u0169gu - K\u0129xasa" },
            { "CF", "Repubirika Afirika-Piterapura" },
            { "CG", "Repubirika K\u0169guyara" },
            { "CH", "Suwisa" },
            { "CI", "Mafim Kup\u00e9" },
            { "CK", "Kapu\u00e3ma-ita Kooki" },
            { "CL", "Xiri" },
            { "CM", "Puty-ita" },
            { "CN", "Xina" },
            { "CO", "Kur\u0169biya" },
            { "CP", "Kiripet\u0169 Kapu\u00e3ma" },
            { "CR", "Kup\u00e9 Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabu Suikiri" },
            { "CW", "Kurasau" },
            { "CX", "Kapu\u00e3ma Kiritima" },
            { "CY", "Xipiri" },
            { "CZ", "Xekiya" },
            { "DE", "Arem\u00e3ya" },
            { "DG", "Diyegu Garasiya" },
            { "DJ", "Dijibuti" },
            { "DK", "Dinamaka" },
            { "DM", "Dominika" },
            { "DO", "Repubirika Duminikana" },
            { "DZ", "Argeriya" },
            { "EA", "Seuta asu\u00ed Merira" },
            { "EC", "Ekuad\u00fa" },
            { "EE", "Isituniya" },
            { "EG", "Egitu" },
            { "EH", "Saara Usid\u1ebdtawara" },
            { "ER", "Eritireya" },
            { "ES", "Isip\u00e3ya" },
            { "ET", "Etiupiya" },
            { "EU", "Eurupa Yepewasusawa" },
            { "EZ", "euru suna" },
            { "FI", "Fir\u00e3diya" },
            { "FJ", "Fiyi" },
            { "FK", "Kapu\u00e3ma-ita Mawina" },
            { "FM", "Mikuruneziya" },
            { "FO", "Kapu\u00e3ma-ita Faruwe" },
            { "FR", "Fr\u00e3sa" },
            { "GA", "Gab\u00e3u" },
            { "GB", "Reyinu Yepewas\u00fa" },
            { "GD", "Garanada" },
            { "GE", "Geugiya" },
            { "GF", "Giyana Fr\u00e3sa yara" },
            { "GG", "Guw\u1ebdnisei" },
            { "GH", "Gana" },
            { "GI", "Gibaraut\u00e1" },
            { "GL", "Guru\u1ebdr\u00e3diya" },
            { "GM", "G\u00e3biya" },
            { "GN", "Gin\u00e9" },
            { "GP", "Guadarupi" },
            { "GQ", "Gin\u00e9 Ekuaturiyau" },
            { "GR", "Geresiya" },
            { "GS", "Kapu\u00e3ma-ita Geugiya Su asu\u00ed S\u00e3duwixi Su" },
            { "GT", "Guatemara" },
            { "GU", "Guw\u00e3" },
            { "GW", "Gin\u00e9 Bisau" },
            { "GY", "Giyana" },
            { "HK", "H\u0169gi K\u0169gi, RAE Xina yara" },
            { "HM", "Kapu\u00e3ma-ita Heard asu\u00ed McDonald" },
            { "HN", "\u0168dura" },
            { "HR", "Kuruwasiya" },
            { "HT", "Ait\u00ed" },
            { "HU", "\u0168giriya" },
            { "IC", "Kapu\u00e3ma-ita Kanariya" },
            { "ID", "\u0128dunesiya" },
            { "IE", "Ir\u00e3da" },
            { "IL", "Isirayeu" },
            { "IM", "M\u00e3 Kapu\u00e3ma" },
            { "IN", "\u0128diya" },
            { "IQ", "Iraki" },
            { "IR", "Ir\u00e3" },
            { "IS", "Isir\u00e3diya" },
            { "IT", "Itariya" },
            { "JE", "Yesei" },
            { "JM", "Yamaika" },
            { "JO", "Yud\u00e3niya" },
            { "JP", "Nip\u00f5" },
            { "KE", "K\u1ebdniya" },
            { "KG", "Kirigiret\u00e3ma" },
            { "KH", "K\u00e3buya" },
            { "KI", "Kiribati" },
            { "KM", "Kumure-ita" },
            { "KN", "S\u00e3 Kirituw\u00e3u su\u00ed Newi" },
            { "KP", "Kureya Nuti su\u00ed" },
            { "KR", "Kureya Su su\u00ed" },
            { "KW", "Kuwaiti" },
            { "KY", "Kapu\u00e3ma-ita Kaim\u00e3" },
            { "KZ", "Kasakiret\u00e3ma" },
            { "LA", "Rawo" },
            { "LB", "Ribanu" },
            { "LC", "S\u00e3ta Lusiya" },
            { "LI", "Rixit\u1ebdxita\u0129" },
            { "LK", "Siri R\u00e3ka" },
            { "LR", "Rib\u00e9riya" },
            { "LS", "Resutu" },
            { "LT", "Rituw\u00e3niya" },
            { "LU", "Rux\u1ebdbugu" },
            { "LV", "Retuniya" },
            { "LY", "Ribiya" },
            { "MA", "Maruku" },
            { "MC", "M\u0169naku" },
            { "MD", "M\u0169duwa" },
            { "ME", "M\u0169teneguru" },
            { "MF", "S\u00e3 Matiy\u0169" },
            { "MG", "Madagasik\u00e1" },
            { "MH", "Kapu\u00e3ma-ita Marshall" },
            { "MK", "Mased\u0169niya" },
            { "ML", "Mari" },
            { "MM", "Miyam\u00e1 (Bim\u00e3niya)" },
            { "MN", "M\u0169guriya" },
            { "MO", "Makau, RAE Xina yara" },
            { "MP", "Kapu\u00e3ma-ita Mariy\u00e3na Nuti su\u00ed" },
            { "MQ", "Matinika" },
            { "MR", "Mauritaniya" },
            { "MS", "M\u0169tiserati" },
            { "MT", "Mauta" },
            { "MU", "Maurisiyu" },
            { "MV", "Maudiwa-ita" },
            { "MW", "Marawi" },
            { "MX", "M\u1ebdsiku" },
            { "MY", "Malasiya" },
            { "MZ", "Mus\u00e3biki" },
            { "NA", "Nam\u00edbiya" },
            { "NC", "Kared\u0169niya Pisas\u00fa" },
            { "NE", "Nige" },
            { "NF", "Kapu\u00e3ma Norfolk" },
            { "NG", "Nigeriya" },
            { "NI", "Nicaraguwa" },
            { "NL", "Tet\u00e3ma Iwibo\u00ed-ita" },
            { "NO", "Nuruwega" },
            { "NP", "Nepau" },
            { "NR", "Nauru" },
            { "NU", "Niwe" },
            { "NZ", "Ser\u00e3diya Pisas\u00fa" },
            { "OM", "Um\u00e3" },
            { "PA", "Panam\u00e3" },
            { "PE", "Peru" },
            { "PF", "Pulinesiya Fr\u00e3sa yara" },
            { "PG", "Papuwa-Gin\u00e9 Pisas\u00fa" },
            { "PH", "Firipina" },
            { "PK", "Pakiret\u00e3ma" },
            { "PL", "Puluniya" },
            { "PM", "S\u00e3 Peduru asu\u00ed Mikel\u00e3u" },
            { "PN", "Kapu\u00e3ma-ita Pitcairn" },
            { "PR", "Igarapawa Riku" },
            { "PS", "Tet\u00e3ma Paretinu-ita yara" },
            { "PT", "Putugau" },
            { "PW", "Parau" },
            { "PY", "Paraguwai" },
            { "QA", "Katara" },
            { "QO", "Use\u00e3niya (R)" },
            { "RE", "Yumuatirisawa" },
            { "RO", "Rom\u1ebdniya" },
            { "RS", "Sewiya" },
            { "RU", "Rusiya" },
            { "RW", "Hu\u00e3da" },
            { "SA", "Arawia Saudita" },
            { "SB", "Kapu\u00e3ma-ita Sarum\u0169" },
            { "SC", "Seixeri" },
            { "SD", "Ausud\u00e3" },
            { "SE", "Suwesiya" },
            { "SG", "S\u0129gapura" },
            { "SH", "S\u00e3ta Erena" },
            { "SI", "Esiruw\u1ebdniya" },
            { "SJ", "Siwaubati asu\u00ed Y\u00e3 Mayeni" },
            { "SK", "Esiruwakiya" },
            { "SL", "Iwitera Leowa" },
            { "SM", "S\u00e3 Marino" },
            { "SN", "Senegau" },
            { "SO", "Somariya" },
            { "SR", "Suriname" },
            { "SS", "Ausud\u00e3 Su su\u00ed" },
            { "ST", "S\u00e3 Tum\u00e9 asu\u00ed Pir\u0129sipe" },
            { "SV", "Eru Sawadu" },
            { "SX", "S\u0129ti Maat\u1ebd" },
            { "SY", "Siriya" },
            { "SZ", "Esuat\u00edni" },
            { "TA", "Tirit\u00e3u K\u0169ya" },
            { "TC", "Kapu\u00e3ma-ita Tuka-ita asu\u00ed Kaiko-ita" },
            { "TD", "Xade" },
            { "TF", "Tet\u00e3ma Su-ita Fr\u00e3sa su\u00ed" },
            { "TG", "Togu" },
            { "TH", "Tairet\u00e3ma" },
            { "TJ", "Tayikiret\u00e3ma" },
            { "TK", "Tukerau" },
            { "TL", "Timu-Semusawa" },
            { "TM", "Turkuranaret\u00e3ma" },
            { "TN", "Tunisiya" },
            { "TO", "T\u00f5ga" },
            { "TR", "Tuk\u00edya" },
            { "TT", "Tirinidadi asu\u00ed Tobagu" },
            { "TV", "Tuwaru" },
            { "TW", "Taiw\u00e3" },
            { "TZ", "T\u00e3saniya" },
            { "UA", "Ukar\u00e3niya" },
            { "UG", "Ug\u00e3da" },
            { "UM", "Kapu\u00e3ma Kuiriwaita Apekatu EUA su\u00ed" },
            { "UN", "Nas\u00e3u Yepewasuwait\u00e1" },
            { "US", "Tet\u00e3ma-ita Yepewas\u00fa" },
            { "UY", "Uruguwai" },
            { "UZ", "Y\u0169buesara-ret\u00e3ma" },
            { "VA", "Watikanu Tawa-wasu" },
            { "VC", "S\u00e3 Wis\u1ebdti asu\u00ed Garanad\u0129na-ita" },
            { "VE", "Wenesuera" },
            { "VG", "Kapu\u00e3-ita Viy\u1ebd-ita Birit\u00e3nika-ita" },
            { "VI", "Kapu\u00e3-ira Viy\u1ebd-ita Amerikana-ita" },
            { "VN", "Wiyetin\u00e3" },
            { "VU", "Wanuatu" },
            { "WF", "Wari asu\u00ed Futuna" },
            { "WS", "Samowa" },
            { "XA", "Sutakirana-ita" },
            { "XB", "Bidiresiunaurana" },
            { "XK", "Kusuwu" },
            { "YE", "Yem\u1ebd" },
            { "YT", "Mayuti" },
            { "ZA", "Afirika Su su\u00ed" },
            { "ZM", "S\u00e3biya" },
            { "ZW", "S\u0129babuwe" },
            { "ZZ", "Tet\u00e3ma \u0168bawaukuamam\u1ebd" },
            { "aa", "afari" },
            { "ab", "abikasiyu" },
            { "ae", "awesitiku" },
            { "af", "afiri\u0137\u00e3ner" },
            { "ak", "ak\u00e3" },
            { "am", "am\u00e1riku" },
            { "an", "aragun\u1ebdi" },
            { "ar", "arabi" },
            { "as", "asamei" },
            { "av", "awariku" },
            { "ay", "aimar\u00e1" },
            { "az", "aserbayanu" },
            { "ba", "baxikiri" },
            { "be", "bierurusu" },
            { "bg", "b\u00fagaru" },
            { "bi", "bisiram\u00e1" },
            { "bm", "b\u00e3bara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "beret\u00e3u" },
            { "bs", "businiu" },
            { "ca", "katar\u00e1" },
            { "ce", "xexenu" },
            { "ch", "xamuru" },
            { "co", "curisu" },
            { "cr", "kiri" },
            { "cs", "tieku" },
            { "cu", "isirawu ekeresiatiku" },
            { "cv", "tiuwaxi" },
            { "cy", "garei" },
            { "da", "dinamarikei" },
            { "de", "arem\u00e3u" },
            { "dv", "diwe\u00ed" },
            { "dz", "dis\u0169ga" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "\u1ebdgirixi" },
            { "eo", "esiper\u00e3tu" },
            { "es", "isip\u00e3yu" },
            { "et", "eituniyanu" },
            { "eu", "basiku" },
            { "fa", "perisa" },
            { "ff", "fura" },
            { "fi", "fir\u00e3des" },
            { "fj", "fiyianu" },
            { "fo", "faruwesi" },
            { "fr", "fr\u00e3sei" },
            { "fy", "fr\u00edsiu usid\u1ebdtawara" },
            { "ga", "ir\u00e3deixi m\u00e9diu" },
            { "gd", "ga\u00e9riku ekusei" },
            { "gl", "garegu" },
            { "gn", "guwarani" },
            { "gu", "guserate" },
            { "gv", "m\u00e3kisi" },
            { "ha", "haus\u00e1" },
            { "he", metaValue_he },
            { "hi", "h\u0129di" },
            { "ho", "hiri mutu" },
            { "hr", "kuruata" },
            { "ht", "haitianu" },
            { "hu", "\u0169garu" },
            { "hy", metaValue_hy },
            { "hz", "hereru" },
            { "ia", "ne\u1ebdgasu\u00ed" },
            { "id", "\u0129dun\u00e9siu" },
            { "ie", "ne\u1ebdgapitera" },
            { "ig", "igibu" },
            { "ii", "sixu\u00e3 yi" },
            { "ik", "inupiaki" },
            { "io", "idu" },
            { "is", "isir\u00e3dei" },
            { "it", "itarianu" },
            { "iu", "inukitituti" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "k\u0169gurei" },
            { "ki", "kikuyu" },
            { "kj", "ku\u00e3yama" },
            { "kk", "kasaki" },
            { "kl", "guru\u1ebdr\u00e3dei" },
            { "km", metaValue_km },
            { "kn", "kanar\u0129" },
            { "ko", "kurianu" },
            { "kr", "kan\u00fari" },
            { "ks", "kaxemira" },
            { "ku", "kurdu" },
            { "kv", "kumi" },
            { "kw", "k\u00fariniku" },
            { "ky", "kirigixi" },
            { "la", metaValue_la },
            { "lb", "rux\u1ebdbugei" },
            { "lg", "rug\u00e3da" },
            { "li", "r\u0129burgei" },
            { "ln", "r\u0129gana" },
            { "lo", "rausianu" },
            { "lt", "rituanu" },
            { "lu", "ruba-kat\u00e3ga" },
            { "lv", "ret\u00e3u" },
            { "mg", "maugaxe" },
            { "mh", "marixarei" },
            { "mi", "mauri" },
            { "mk", "mased\u0169niu" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "marayu" },
            { "mt", "mautei" },
            { "my", metaValue_my },
            { "na", "nauruanu" },
            { "nb", "bukimau nuruegei" },
            { "nd", "\u0129debere nutiwara" },
            { "ne", "neparei" },
            { "ng", "d\u0169gu" },
            { "nl", "hur\u00e3dei" },
            { "nn", "ninorisiki nuruegei" },
            { "no", "nuruegei" },
            { "nr", "\u0129debere suwara" },
            { "nv", "nawayu" },
            { "ny", "ni\u00e3ya" },
            { "oc", "usit\u00e3niku" },
            { "oj", "uyibua" },
            { "om", "urumu" },
            { "or", metaValue_or },
            { "os", "usetu" },
            { "pa", "p\u00e3yabi" },
            { "pi", "p\u00e1ri" },
            { "pl", "purunei" },
            { "ps", "paxitu" },
            { "pt", "putugei" },
            { "qu", "k\u00edxua" },
            { "rm", "rum\u00e3xi" },
            { "rn", "r\u0169di" },
            { "ro", "rumenu" },
            { "ru", "rusu" },
            { "rw", "kiniaru\u00e3da" },
            { "sa", "s\u00e3sikiritu" },
            { "sc", "sarid\u00fa" },
            { "sd", "s\u0129di" },
            { "se", "sami set\u1ebdtiriunau" },
            { "sg", "s\u00e3g\u00fa" },
            { "sh", "seriwu-kruata" },
            { "si", metaValue_si },
            { "sk", "esiruwaku" },
            { "sl", "esiruwenu" },
            { "sm", "samuanu" },
            { "sn", "xuna" },
            { "so", "sumari" },
            { "sq", "aubanei" },
            { "sr", "s\u00e9riwiu" },
            { "ss", "su\u00e1si" },
            { "st", "sutu suwara" },
            { "su", "s\u0169danei" },
            { "sv", "sueku" },
            { "sw", "sua\u00edri" },
            { "ta", "tamiu" },
            { "te", metaValue_te },
            { "tg", "tadiyike" },
            { "th", metaValue_th },
            { "ti", "tigir\u00ednia" },
            { "tk", "turikumenu" },
            { "tl", metaValue_tl },
            { "tn", "tisuana" },
            { "to", "t\u0169ganei" },
            { "tr", "turku" },
            { "ts", "tes\u0169ga" },
            { "tt", "t\u00e1ritaru" },
            { "tw", "tui" },
            { "ty", "taitianu" },
            { "ug", "wiguri" },
            { "uk", "ukaranianu" },
            { "ur", "urdu" },
            { "uz", "usibeki" },
            { "ve", "w\u1ebdda" },
            { "vi", "wietinamita" },
            { "vo", "wurapuke" },
            { "wa", "war\u00e3u" },
            { "wo", "worofi" },
            { "xh", "xosa" },
            { "yi", "y\u00eddixi" },
            { "yo", "yurub\u00e1" },
            { "za", "su\u00e3gi" },
            { "zh", "xinanhe\u1ebdga" },
            { "zu", "suru" },
            { "ace", "axemi" },
            { "ach", "akuri" },
            { "ada", "ad\u00e3gime" },
            { "ady", "adige" },
            { "afh", "afirihiri" },
            { "agq", "ag\u1ebd" },
            { "ain", "ain\u00fa" },
            { "akk", "akadi\u00e3nu" },
            { "ale", "are\u00fati" },
            { "alt", "autai meridiunau" },
            { "ang", "\u1ebdgirixi arkaiku" },
            { "anp", "\u00e3yika" },
            { "arc", "aramaiku" },
            { "arn", "mapud\u0169g\u0169" },
            { "arp", "araparu" },
            { "ars", "arabi negede" },
            { "arw", "arawaki" },
            { "asa", "asu" },
            { "ast", "asiturianu" },
            { "awa", "awadi" },
            { "bal", "bar\u00faxi" },
            { "ban", "barinei" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "bbj", "gumara" },
            { "bej", "beya" },
            { "bem", "b\u1ebdba" },
            { "bez", "bena" },
            { "bfd", "bafuti" },
            { "bgn", "baruxi usid\u1ebdtawara" },
            { "bho", "buyipuri" },
            { "bik", "bik\u00fa" },
            { "bin", "bin\u00ed" },
            { "bkm", "k\u0169" },
            { "bla", "sikisika" },
            { "bra", "barayi" },
            { "brx", "budu" },
            { "bss", "akusi" },
            { "bua", "buriatu" },
            { "bug", metaValue_bug },
            { "bum", "buru" },
            { "byn", "bir\u0129" },
            { "byv", "med\u0169ba" },
            { "cad", "cadu" },
            { "car", "karibi" },
            { "cay", "kayuga" },
            { "cch", "atis\u00e3" },
            { "ccp", "xakima" },
            { "ceb", "sebuanu" },
            { "cgg", "xiga" },
            { "chb", "xibixa" },
            { "chg", "xagatai" },
            { "chk", "xukisi" },
            { "chm", "mari" },
            { "chn", "yarig\u00e3u xinoki" },
            { "cho", "xokitau" },
            { "chp", "xipewiy\u00e3" },
            { "chr", metaValue_chr },
            { "chy", "xeyeni" },
            { "ckb", "kurdu piterapura" },
            { "cop", "kupita" },
            { "crh", "Kirimeya turiku" },
            { "crs", "kiriuru fr\u00e3sei seixeriwara" },
            { "csb", "kaxubi\u00e3" },
            { "dak", "dakuta" },
            { "dar", "darigiwa" },
            { "dav", "taita" },
            { "del", "deraware" },
            { "den", "isireivei" },
            { "dgr", "dogiri" },
            { "din", "d\u0129ka" },
            { "dje", "sarima" },
            { "doi", "dogiribi" },
            { "dsb", "sur\u00e1biu yatuka" },
            { "dua", "duara" },
            { "dum", "hur\u00e3dei m\u00e9diu" },
            { "dyo", "yora-funiyi" },
            { "dyu", "diura" },
            { "dzg", "dasaga" },
            { "ebu", "\u1ebdbu" },
            { "efi", "efiki" },
            { "egy", "egipisiu arkaiku" },
            { "eka", "ekayuki" },
            { "elx", "eramite" },
            { "enm", "\u1ebdgirixi m\u00e9diu" },
            { "ewo", "ew\u0169du" },
            { "fan", "f\u00e3ge" },
            { "fat", "f\u00e3ti" },
            { "fil", "firipinu" },
            { "fon", "f\u0169mu" },
            { "frc", "fr\u00e3sei kay\u0169" },
            { "frm", "fr\u00e3sei m\u00e9diu" },
            { "fro", "fr\u00e3sei arkaiku" },
            { "frr", "fir\u00edsiu set\u1ebdtiriunau" },
            { "frs", "fir\u00edsiu usid\u1ebdtawara" },
            { "fur", "friuranu" },
            { "gaa", "ga" },
            { "gag", "gagausi" },
            { "gan", "g\u00e3" },
            { "gay", "gayu" },
            { "gba", "gibaya" },
            { "gez", "giixi" },
            { "gil", "giubetei" },
            { "gmh", "arem\u00e3u iwat\u00e9 m\u00e9diu" },
            { "goh", "arem\u00e3u arkaiku iwat\u00e9" },
            { "gon", "g\u0169di" },
            { "gor", "gur\u0169taru" },
            { "got", metaValue_got },
            { "grb", "gerebu" },
            { "grc", "geregu arkaiku" },
            { "gsw", "arem\u00e3u (Suisa)" },
            { "guz", "gusiyi" },
            { "gwi", "guwixi-\u0129" },
            { "hai", "haida" },
            { "hak", "hak\u00e1" },
            { "haw", "hawayanu" },
            { "hil", "irigain\u0169" },
            { "hit", "hitita" },
            { "hmn", "him\u0169gi" },
            { "hsb", "sur\u00e1biu iwat\u00e9" },
            { "hsn", "xi\u00e3gi" },
            { "hup", "hupa" },
            { "iba", "ib\u00e3" },
            { "ibb", "ibibiu" },
            { "ilo", "irukanu" },
            { "inh", "\u0129guxi" },
            { "jbo", "ruyib\u00e3" },
            { "jgo", "\u0129g\u1ebdba" },
            { "jmc", "maxami" },
            { "jpr", "yudaiku-perisa" },
            { "jrb", "yudaiku-arabiku" },
            { "kaa", "kara-kaupaki" },
            { "kab", "kabire" },
            { "kac", "kax\u0129" },
            { "kaj", "iyu" },
            { "kam", "k\u00e3ba" },
            { "kaw", "kawi" },
            { "kbd", "kabaridianu" },
            { "kbl", "kan\u1ebdbu" },
            { "kcg", "tiyapi" },
            { "kde", "mak\u0169di" },
            { "kea", "kiriuru kabu-suikiriwara" },
            { "kfo", "kuru" },
            { "kgp", "ka\u0129g\u00e3gi" },
            { "kha", "kasi" },
            { "kho", "kutanei" },
            { "khq", "kuyira xini" },
            { "kkj", "kaku" },
            { "kln", "kar\u1ebdy\u0129" },
            { "kmb", "k\u0129b\u0169du" },
            { "koi", "kumi-perimiaki" },
            { "kok", "k\u0169kani" },
            { "kos", "kusiray\u00e3" },
            { "kpe", "kipere" },
            { "krc", "karaxai-bauk\u00e1" },
            { "krl", "kar\u00e9riu" },
            { "kru", "kuruki" },
            { "ksb", "x\u00e3bara" },
            { "ksf", "bafia" },
            { "ksh", "kurixi" },
            { "kum", "kumiki" },
            { "kut", "kutenai" },
            { "lad", "radinu" },
            { "lag", "r\u00e3gi" },
            { "lah", "r\u00e3da" },
            { "lam", "r\u00e3ba" },
            { "lez", "resigi" },
            { "lkt", "rakuta" },
            { "lol", "m\u0169gu" },
            { "lou", "kiriuru ruisianawara" },
            { "loz", "rusi" },
            { "lrc", "ruri set\u1ebdtiriunau" },
            { "lua", "ruba-rurua" },
            { "lui", "ruisenu" },
            { "lun", "r\u0169da" },
            { "luo", "ruwu" },
            { "lus", "ruxai" },
            { "luy", "ruiya" },
            { "mad", "madurei" },
            { "maf", "mafa" },
            { "mag", "magar\u00ed" },
            { "mai", "maitiri" },
            { "mak", "makas\u00e1" },
            { "man", "m\u00e3d\u0129ga" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "mukisa" },
            { "mdr", "m\u00e3dari" },
            { "men", "m\u1ebdde" },
            { "mer", "meru" },
            { "mfe", "murisi\u1ebd" },
            { "mga", "ir\u00e3dei m\u00e9diu" },
            { "mgh", "makua" },
            { "mgo", "met\u00e1" },
            { "mic", "mikemake" },
            { "min", "min\u00e3gikabau" },
            { "mnc", "m\u00e3xu" },
            { "mni", "manipuri" },
            { "moh", "muikanu" },
            { "mos", "musi" },
            { "mua", "m\u0169d\u00e3gi" },
            { "mul", "si\u00eda nhe\u1ebdga" },
            { "mus", "kirik" },
            { "mwl", "mir\u00e3dei" },
            { "mwr", "mariwari" },
            { "mye", "miyene" },
            { "myv", "erisia" },
            { "mzn", "mas\u00e3darani" },
            { "nan", "m\u0129 n\u00e3" },
            { "nap", "napuritanu" },
            { "naq", "nama" },
            { "nds", "arema\u0169 yatuka" },
            { "new", "newari" },
            { "nia", "niyasi" },
            { "niu", "niweanu" },
            { "nmg", "kuwasiu" },
            { "nnh", "\u0129gi\u1ebdb\u0169" },
            { "nog", "nugai" },
            { "non", "n\u00faridiku arkaiku" },
            { "nqo", "nik\u00fa" },
            { "nso", "sutu set\u1ebdtiriunau" },
            { "nus", "nuiri" },
            { "nwc", "newari katuwa" },
            { "nym", "ni\u00e3muwesi" },
            { "nyn", "ni\u00e3kuri" },
            { "nyo", "niyuru" },
            { "nzi", "\u0129sima" },
            { "osa", "usayi" },
            { "ota", "turiku utumanu" },
            { "pag", "p\u00e3gasin\u00e3" },
            { "pal", "parawi" },
            { "pam", "p\u00e3p\u00e3ga" },
            { "pap", "papiam\u1ebdtu" },
            { "pau", "parauanu" },
            { "pcm", "pidig\u0129 niyerianu" },
            { "peo", "persa arkaiku" },
            { "phn", metaValue_phn },
            { "pon", "p\u0169peianu" },
            { "prg", "purusianu" },
            { "pro", "puruw\u1ebdsau arkaiku" },
            { "quc", "kix\u00e9" },
            { "raj", "rayasitani" },
            { "rap", "rapanui" },
            { "rar", "rurut\u0169ganu" },
            { "rof", "r\u0169bu" },
            { "rom", "rumani" },
            { "rup", "arumenu" },
            { "rwk", "ruwa" },
            { "sad", "s\u00e3dawe" },
            { "sah", "saka" },
            { "sam", "aramaiku samaritanu" },
            { "saq", "s\u00e3buru" },
            { "sas", "sasak" },
            { "sat", "s\u00e3tari" },
            { "sba", "\u0129g\u00e3bai" },
            { "sbp", "s\u00e3gu" },
            { "scn", "sisirianu" },
            { "sco", "isiutis" },
            { "sdh", "kuridu meridiunau" },
            { "see", "seneka" },
            { "seh", "sena" },
            { "sel", "seukupi" },
            { "ses", "kuiraburu seni" },
            { "sga", "ir\u00e3desiarkaiku" },
            { "shi", "taxeriti" },
            { "shn", "x\u00e3ni" },
            { "shu", "arabi xadianu" },
            { "sid", "sidamu" },
            { "sma", "sami meridiunau" },
            { "smj", "sami Lulewara" },
            { "smn", "sami Inariwara" },
            { "sms", "sami Skoltwara" },
            { "snk", "sun\u0129k\u00ea" },
            { "sog", "sugidianu" },
            { "srn", "surinamei" },
            { "srr", "serere" },
            { "ssy", "saru" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeriu" },
            { "swb", "kumurianu" },
            { "syc", "siriaku katuwa" },
            { "syr", "siriaku" },
            { "tem", "timine" },
            { "teo", "teso" },
            { "ter", "terenu" },
            { "tet", "tet\u0169" },
            { "tig", "tigir\u00e9" },
            { "tiv", "tivi" },
            { "tkl", "tukerauanu" },
            { "tlh", "kir\u0129g\u0169" },
            { "tli", "tir\u0129giti" },
            { "tmh", "tamaxeki" },
            { "tog", "t\u0169ganei Niasawara" },
            { "tpi", "tuki pis\u0129" },
            { "trv", "taruku" },
            { "tsi", "tes\u0129m\u0129xianu" },
            { "tum", "t\u0169buka" },
            { "tvl", "tuwaruanu" },
            { "twq", "tasawake" },
            { "tyv", "tuwinianu" },
            { "tzm", "tamasiriti \u00c1tras katuwa" },
            { "udm", "udimurite" },
            { "uga", metaValue_uga },
            { "umb", "\u0169b\u0169du" },
            { "und", "\u0169ba uyukuau nhe\u1ebdga" },
            { "vai", metaValue_vai },
            { "vot", "w\u00fatiku" },
            { "vun", "w\u0169yu" },
            { "wae", "wauseri" },
            { "wal", "woraita" },
            { "war", "warai" },
            { "was", "waxu" },
            { "wbp", "waripiri" },
            { "wuu", "wurapuki" },
            { "xal", "kaumiki" },
            { "xog", "rusoga" },
            { "yao", "yau" },
            { "yap", "yapese" },
            { "yav", "y\u00e3gib\u1ebd" },
            { "ybb", "y\u1ebdba" },
            { "yrl", "nhe\u1ebdgatu" },
            { "yue", "k\u00e3tunei" },
            { "zap", "saputeku" },
            { "zbl", "r\u00e3gasait\u00e1 brisi" },
            { "zen", "senaga" },
            { "zgh", "tamasiriti marukinu padr\u00e3u" },
            { "zun", "s\u0169yi" },
            { "zxx", "\u0169ba ayku\u00e9 nhe\u1ebdga sesewarait\u00e1" },
            { "zza", "sasaki" },
            { "Arab", "arabika" },
            { "Armi", "arimi" },
            { "Armn", metaValue_hy },
            { "Avst", "aw\u00e9tiku" },
            { "Bali", "barineisi" },
            { "Bamu", metaValue_bax },
            { "Batk", "bataki" },
            { "Beng", metaValue_bn },
            { "Blis", "r\u00e3gasait\u00e1 bliss" },
            { "Bopo", "bupumufu" },
            { "Brah", "brami" },
            { "Brai", "braire" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buwidi" },
            { "Cakm", "kakimi" },
            { "Cans", "y\u0169pinimas\u00e1 s\u00edraba ir\u0169 abur\u00edjini kanad\u00e1wara su\u00ed" },
            { "Cari", "karianu" },
            { "Cham", "x\u00e3mi" },
            { "Cher", metaValue_chr },
            { "Cirt", "runikarana" },
            { "Copt", "kupitiku" },
            { "Cprt", "sipiriuta" },
            { "Cyrl", "sir\u00edriku" },
            { "Cyrs", "sir\u00edriku isirawu ekeresiatiku" },
            { "Deva", "dewanagari" },
            { "Dsrt", "desereti" },
            { "Egyd", "dem\u00fatiku egipisiu" },
            { "Egyh", "ier\u00e1tiku egipisiu" },
            { "Egyp", "egipsiu-ita kuatiara kuxi\u00edmawara" },
            { "Ethi", "eti\u00fapiku" },
            { "Geok", "kutisuri geurgianu" },
            { "Geor", metaValue_ka },
            { "Glag", "garagur\u00edtiku" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "guserati" },
            { "Guru", "gumuki" },
            { "Hanb", "h\u00e3bi" },
            { "Hang", "h\u00e3gu" },
            { "Hani", "h\u00e3" },
            { "Hano", "hanunu" },
            { "Hans", "iwasu\u0129ma" },
            { "Hant", "katuwa" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "parau him\u0169gi" },
            { "Hrkt", "yapunei s\u00edraba ir\u0169" },
            { "Hung", "\u0169garu kuxi\u00edmawara" },
            { "Inds", "\u0129du" },
            { "Ital", "it\u00e1riku kuxi\u00edmawara" },
            { "Jamo", "yamu" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kaya ri" },
            { "Kana", "katakan\u00e1" },
            { "Khar", "karuxiti" },
            { "Khmr", metaValue_km },
            { "Knda", "k\u00e3nar\u00e1" },
            { "Kore", "kureanu" },
            { "Kthi", "kiti" },
            { "Lana", "rana" },
            { "Laoo", "rau" },
            { "Latf", "rat\u0129 farakit\u00fa" },
            { "Latg", "rat\u0129 ga\u00e9riku" },
            { "Latn", metaValue_la },
            { "Lepc", "repixa" },
            { "Limb", "r\u0129bu" },
            { "Lina", "sat\u00e3bika A" },
            { "Linb", "sat\u00e3bika B" },
            { "Lisu", "risu" },
            { "Lyci", "r\u00edsiu" },
            { "Lydi", "r\u00eddiu" },
            { "Mand", "m\u00e3daiku" },
            { "Mani", "manikeanu" },
            { "Maya", "maya-ita kuatiara kuxi\u00edmawara" },
            { "Merc", "meru\u00edtiku kusiwu" },
            { "Mero", "meru\u00edtiku" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "Moon kuatiara" },
            { "Mtei", "manipuri kuatiara" },
            { "Mymr", metaValue_my },
            { "Nkoo", "\u0129ku" },
            { "Ogam", "ug\u00e3miku" },
            { "Olck", "uxiki" },
            { "Orkh", "urik\u0169" },
            { "Orya", metaValue_or },
            { "Osma", "usmania" },
            { "Perm", "p\u00e9rimiku kuxi\u00edmawara" },
            { "Phag", "phagipa" },
            { "Phli", "phli" },
            { "Phlp", "phlp" },
            { "Phlv", "paravi kuxi\u00edmawara" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fun\u00e9tiku miau" },
            { "Prti", "prti" },
            { "Rjng", "rey\u00e3gi" },
            { "Roro", "r\u0169gur\u0169gu" },
            { "Runr", "r\u00faniku" },
            { "Samr", "samaritanu" },
            { "Sara", "sarati" },
            { "Saur", "sauraxitara" },
            { "Sgnw", "s\u00e3gawa kuatiara" },
            { "Shaw", "xawianu" },
            { "Sinh", metaValue_si },
            { "Sund", "sud\u00e3nei" },
            { "Sylo", "siruti nagiri" },
            { "Syrc", "sir\u00edaku" },
            { "Syre", "sir\u00edaku esitar\u00e3geru" },
            { "Syrj", "siriaku usid\u1ebdtawara" },
            { "Syrn", "siriaku uri\u1ebdtawara" },
            { "Tagb", "tagibanua" },
            { "Tale", "tai re" },
            { "Talu", "tai rue pisas\u00fa" },
            { "Taml", "t\u00e3miu" },
            { "Tavt", "tawiti" },
            { "Telu", metaValue_te },
            { "Teng", "t\u1ebdguwari" },
            { "Tfng", "tifinagi" },
            { "Tglg", metaValue_tl },
            { "Thaa", "ta-ana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "nhe\u1ebdga xipiawera" },
            { "Xpeo", "perisa kuxi\u00edmawara" },
            { "Xsux", "sum\u00e9riu-akadianu kune-s\u00e3gawa" },
            { "Yiii", "yi" },
            { "Zinh", "tauxariwa" },
            { "Zmth", "matem\u00e1tika kuatiara" },
            { "Zsye", "Emuyi" },
            { "Zsym", "zsym" },
            { "Zxxx", "y\u0169pinimas\u00e1\u0129ma" },
            { "Zyyy", "mayewera" },
            { "Zzzz", "y\u0169pinimas\u00e1 \u0169bawa uyukuau" },
            { "root", "raisi" },
            { "de_CH", "arem\u00e3u iwat\u00e9 (Suisa)" },
            { "nl_BE", "faram\u1ebdgu" },
            { "ro_MD", "mud\u00e1wiu" },
            { "sw_CD", "suairi k\u0169guwara" },
            { "%%1901", "kuatiasawasup\u00ed arim\u00e3 rikusawarup\u00ed" },
            { "%%1994", "kuatiasawasup\u00ed resiawara muretewa" },
            { "%%1996", "kuatiasawasup\u00ed arim\u00e3 1996 up\u00e9" },
            { "ar_001", "arabi mudernu" },
            { "key.ca", "Akayupawa" },
            { "key.cf", "Rupisawa rikuyara" },
            { "key.co", "Isir\u00e3sawa" },
            { "key.cu", "Rikuyara" },
            { "key.hc", "Ara urariupura (12\u00a0vs 24)" },
            { "key.lb", "Nim\u0169 mupukasawa rupisawa" },
            { "key.ms", "Mus\u0169gasawa tek\u00f4" },
            { "key.nu", "Papasawa-it\u00e1" },
            { "key.tz", "Kutu hurariyu" },
            { "key.va", "Tedawasawa muyereusawa" },
            { "nds_NL", "sakis\u00e3u yatuka" },
            { "%%BISKE", "diyaretu s\u00e3 giorgiu/bira" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "kuatiasawasup\u00ed panh\u00e9-yara" },
            { "%%LIPAW", "diyaretu ripovai Resian yara" },
            { "%%NEDIS", "diyaretu natisuni" },
            { "%%NJIVA", "diyaretu giniwa/niyiwa" },
            { "%%OSOJS", "diyaretu usiaku/usuyani" },
            { "%%POSIX", "k\u0169putarawa" },
            { "%%ROZAJ", "resiawara" },
            { "%%SAAHO", "saho" },
            { "%%SOLBA", "diyaretu situwisa/subika" },
            { "%%UCCOR", "kuatiasawasup\u00ed yepewas\u00fa" },
            { "az_Arab", "aseri s\u00fa" },
            { "zh_Hans", "xinanhe\u1ebdga iwasu\u0129ma" },
            { "zh_Hant", "xinanhe\u1ebdga katuwa" },
            { "%%AO1990", "Kuatiasawasup\u00ed Ewakisawa Nhe\u1ebdga Putugewara 1990" },
            { "%%FONIPA", "fun\u00e9tika Aufabetu Fun\u00e9tiku \u0128tertet\u00e3ma-ita" },
            { "%%FONUPA", "fun\u00e9tika Aufabetu Fun\u00e9tiku Urariku" },
            { "%%NDYUKA", "diyaretu \u0129diyuka" },
            { "%%PAMAKA", "diyaretu pamaka" },
            { "%%PINYIN", "romanisasawa Piniy\u0129" },
            { "%%SCOUSE", "isikuse" },
            { "%%TARASK", "kuatiasawasup\u00ed tarasikiewika" },
            { "%%UCRCOR", "kuatiasawasup\u00ed musat\u00e3bikawa su\u00ed yespewas\u00fa" },
            { "%%ABL1943", "Papira purakari-res\u00e9 kuatiasawasup\u00ed 1943 su\u00ed" },
            { "%%AREVELA", "arim\u1ebdniyu uri\u1ebdtawara" },
            { "%%AREVMDA", "arim\u1ebdniyu usid\u1ebdtawara" },
            { "%%HEPBURN", "romanisasawa hepburn" },
            { "%%MONOTON", "yepet\u0169niku" },
            { "%%POLYTON", "t\u0169niku-ita" },
            { "%%REVISED", "kuatiasawasup\u00ed musat\u00e3bikawa" },
            { "%%1606NICT", "fr\u00e3sanhe\u1ebdga kaxi\u00edmawara 1606 up\u00e9" },
            { "%%1694ACAD", "fr\u00e3sanhe\u1ebdga kuiriwara" },
            { "%%1959ACAD", "akademiku" },
            { "%%BAKU1926", "aufabetu ratinu turku yepewas\u00fa" },
            { "%%BISCAYAN", "bisikayawara" },
            { "%%COLB1945", "K\u00f5v\u1ebds\u00e3u kuatiasawasup\u00ed Brasiu-Putugau 1945" },
            { "%%HOGNORSK", "nuruwegu iwat\u00e9" },
            { "%%SCOTLAND", "\u1ebdgirixi retewa esikusiyei" },
            { "%%VALENCIA", "war\u1ebdsiwara" },
            { "%%WADEGILE", "romanisasawa Wade-Giles" },
            { "type.ca.roc", "Akayupawa Xina Rep\u00fabirikawara" },
            { "type.co.eor", "Tek\u00f4 eurupawara muakar\u00e9sawa sup\u00e9" },
            { "type.hc.h11", "Sist\u1ebdma 12 h\u00fara-ita (0-11)" },
            { "type.hc.h12", metaValue_type_hc_h12 },
            { "type.hc.h23", "Sist\u1ebdma 24 h\u00fara-ita (0-23)" },
            { "type.hc.h24", metaValue_type_hc_h12 },
            { "type.m0.bgn", "Sinimukasawa BGN EUA" },
            { "type.nu.arab", "Augarismu-ita \u0129du-arabiku" },
            { "type.nu.armn", "Augarismu-ita arim\u1ebdniyu" },
            { "type.nu.beng", "Augarismu-ita b\u1ebdgari" },
            { "type.nu.deva", "Augarismu-ita dewanag\u00e1ri" },
            { "type.nu.ethi", "Augarismu-ita etiopiwara" },
            { "type.nu.geor", "Augarismu-ita geurgianu" },
            { "type.nu.grek", "Augarismu-ita geregu" },
            { "type.nu.gujr", "Augarismu-ita guserate" },
            { "type.nu.guru", "Augarismu-ita gurmuki" },
            { "type.nu.hans", "Augarismu-ita xinawara iwasu\u00edma" },
            { "type.nu.hant", "Augarismu-ita xinawara rikusawarup\u00ed" },
            { "type.nu.hebr", "Augarismu-ita yudeu" },
            { "type.nu.jpan", "Augarismu-ita nip\u00f5wara" },
            { "type.nu.khmr", "Augarismu-ita kim\u00e9" },
            { "type.nu.knda", "Augarismu-ita kanarawara" },
            { "type.nu.laoo", "Augarismu-ita raosiwara" },
            { "type.nu.latn", "Augarismu-ita usid\u1ebdtawa" },
            { "type.nu.mlym", "Augarismu-ita marayaro" },
            { "type.nu.mong", "Augarismu-ita m\u0169g\u00fai" },
            { "type.nu.mymr", "Augarismu-ita Miyamawara" },
            { "type.nu.orya", "Augarismu-ita uri\u00e1" },
            { "type.nu.taml", "Augarismu-ita tamir rikusawarup\u00ed" },
            { "type.nu.telu", "Augarismu-ita terugu" },
            { "type.nu.thai", "Augarismu-ita tair\u00e3diyawara" },
            { "type.nu.tibt", "Augarismu-ita tibetewara" },
            { "type.nu.vaii", "Diyitu-ita vai" },
            { "type.ca.dangi", "Akayupawa D\u00e3gi" },
            { "type.co.ducet", "Unicode muakaresawa retewa" },
            { "type.lb.loose", "Mupenasawa ixama up\u00e9 ikusawa yurawa ir\u0169" },
            { "type.nu.roman", "Augarismu-ita romawara" },
            { "type.ca.coptic", "Akayupawa Kupitiku" },
            { "type.ca.hebrew", "Akayupawa Yudeu" },
            { "type.ca.indian", "Akayupawa Tet\u00e3mapawa \u0128diawara" },
            { "type.co.compat", "Muakaresawa rin\u0169dewa n\u0169gar\u00e1sawa" },
            { "type.co.pinyin", "Pin-yin mukaresawa" },
            { "type.co.search", "Sikais\u00e1 purusawa panh\u00e9rup\u00ed" },
            { "type.co.stroke", "Sikis\u00e1-ita mukaresawa" },
            { "type.co.unihan", "Mukaresawa radikawa - sikis\u00e1-ita" },
            { "type.d0.fwidth", "Turususawa teipausape" },
            { "type.d0.hwidth", "Turususawa pisawera" },
            { "type.lb.normal", "Mupenasawa ixama up\u00e9 ikusawa nurmawa ir\u0169" },
            { "type.lb.strict", "Mupenasawa ixama up\u00e9 ikusawa estiritu ir\u0169" },
            { "type.m0.ungegn", "Sinimukasawa UN GEGN" },
            { "type.ms.metric", "Sist\u1ebdma m\u00e9tiriku" },
            { "type.nu.native", "Diyitu-wara-ita" },
            { "type.ca.chinese", "Akayupawa Xinawara" },
            { "type.ca.iso8601", "Akayupawa ISSO-8601" },
            { "type.ca.persian", "Akayupawa Persiyawara" },
            { "type.cf.account", "Rikuyara rupisawa papasawa sup\u00e9" },
            { "type.co.big5han", "Xinanh\u1ebd\u1ebdga rikusawarup\u00ed muakaresawa - Big5" },
            { "type.d0.npinyin", "Papasawera" },
            { "type.nu.arabext", "Augarismu-ita \u0129du-arabiku musapira" },
            { "type.nu.armnlow", "Augarismu-ita arim\u1ebdniyu mir\u0129wa" },
            { "type.nu.finance", "Papasawa-ita kariwa-rekuyara" },
            { "type.nu.greklow", "Augarismu-ita geregu mir\u0129wa" },
            { "type.nu.hanidec", "Augarismu-ita muk\u0169i-pusawa xinawara" },
            { "type.nu.hansfin", "Augarismu-ita kariwa-rekuyara xinawara iwasu\u00edma" },
            { "type.nu.hantfin", "Augarismu-ita kariwa-rekuyara xinawara rikusawarup\u00ed" },
            { "type.nu.jpanfin", "Augarismu-ita kariwa-rekuyara nip\u00f5wara" },
            { "type.nu.tamldec", "Augarismu-ita ramir" },
            { "type.ca.buddhist", "Akayupawa Budasuera" },
            { "type.ca.ethiopic", "Akayupawa Et\u00edupi" },
            { "type.ca.japanese", "Akayupawa Nip\u00f5wara" },
            { "type.cf.standard", "Rikuyara rupisawa retewa" },
            { "type.co.phonetic", "Yupurawakasawa terefuniara mukaresawa" },
            { "type.co.searchjl", "Resikai k\u0169su\u00e3ti uyupiruwa hangul rup\u00ed" },
            { "type.co.standard", "Mukaresawa retewa" },
            { "type.ms.uksystem", "Sist\u1ebdma mus\u00e3gasawa \u0129periawa" },
            { "type.ms.ussystem", "Sist\u1ebdma mus\u00e3gasawa amerikapura" },
            { "type.nu.fullwide", "Augarismu-ita teipausape" },
            { "type.nu.romanlow", "Augarismu-ita romawara mir\u0129wa" },
            { "type.ca.gregorian", "Akayupawa Greguriuwara" },
            { "type.co.gb2312han", "Xinanhe\u1ebdga iwasu\u0129ma muakarewa - GB2312" },
            { "type.co.phonebook", "Terefuni sesewara muakaresawa" },
            { "type.co.dictionary", "Disiunariu muakaresawa" },
            { "type.co.traditional", "Mukaresawa rikusawarup\u00ed" },
            { "type.nu.traditional", "Papasawa-ita rikusawarup\u00ed" },
            { "type.ca.ethiopic-amete-alem", "Akayupawa Amete Alem Etiupiwara" },
        };
        return data;
    }
}
