/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.bulk;

import java.util.Arrays;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.bulk.BulkShardResponse;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.action.support.replication.TransportWriteAction;
import org.opensearch.core.index.AppendOnlyIndexOperationRetryException;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.translog.Translog;

class BulkPrimaryExecutionContext {
    private final BulkShardRequest request;
    private final IndexShard primary;
    private Translog.Location locationToSync = null;
    private int currentIndex = -1;
    private ItemProcessingState currentItemState;
    private DocWriteRequest requestToExecute;
    private BulkItemResponse executionResult;
    private int retryCounter;

    BulkPrimaryExecutionContext(BulkShardRequest request, IndexShard primary) {
        this.request = request;
        this.primary = primary;
        this.advance();
    }

    private int findNextNonAborted(int startIndex) {
        int length = this.request.items().length;
        while (startIndex < length && BulkPrimaryExecutionContext.isAborted(this.request.items()[startIndex].getPrimaryResponse())) {
            ++startIndex;
        }
        return startIndex;
    }

    private static boolean isAborted(BulkItemResponse response) {
        return response != null && response.isFailed() && response.getFailure().isAborted();
    }

    private void advance() {
        assert (this.currentItemState == ItemProcessingState.COMPLETED || this.currentIndex == -1) : "moving to next but current item wasn't completed (state: " + String.valueOf((Object)this.currentItemState) + ")";
        this.currentItemState = ItemProcessingState.INITIAL;
        this.currentIndex = this.findNextNonAborted(this.currentIndex + 1);
        this.retryCounter = 0;
        this.requestToExecute = null;
        this.executionResult = null;
        assert (this.assertInvariants(ItemProcessingState.INITIAL));
    }

    public DocWriteRequest<?> getCurrent() {
        return this.getCurrentItem().request();
    }

    public BulkShardRequest getBulkShardRequest() {
        return this.request;
    }

    public BulkItemResponse getExecutionResult() {
        assert (this.assertInvariants(ItemProcessingState.EXECUTED));
        return this.executionResult;
    }

    public int getRetryCounter() {
        return this.retryCounter;
    }

    public boolean isOperationExecuted() {
        return this.currentItemState == ItemProcessingState.EXECUTED;
    }

    public boolean requiresWaitingForMappingUpdate() {
        return this.currentItemState == ItemProcessingState.WAIT_FOR_MAPPING_UPDATE;
    }

    public boolean requiresImmediateRetry() {
        return this.currentItemState == ItemProcessingState.IMMEDIATE_RETRY;
    }

    public boolean isCompleted() {
        return this.currentItemState == ItemProcessingState.COMPLETED;
    }

    public boolean isInitial() {
        return this.currentItemState == ItemProcessingState.INITIAL;
    }

    public boolean hasMoreOperationsToExecute() {
        return this.currentIndex < this.request.items().length;
    }

    public String getConcreteIndex() {
        return this.getCurrentItem().index();
    }

    public Translog.Location getLocationToSync() {
        assert (!this.hasMoreOperationsToExecute());
        assert (this.assertInvariants(ItemProcessingState.INITIAL));
        return this.locationToSync;
    }

    private BulkItemRequest getCurrentItem() {
        return this.request.items()[this.currentIndex];
    }

    public IndexShard getPrimary() {
        return this.primary;
    }

    public void setRequestToExecute(DocWriteRequest writeRequest) {
        assert (this.assertInvariants(ItemProcessingState.INITIAL));
        this.requestToExecute = writeRequest;
        this.currentItemState = ItemProcessingState.TRANSLATED;
        assert (this.assertInvariants(ItemProcessingState.TRANSLATED));
    }

    public <T extends DocWriteRequest<T>> T getRequestToExecute() {
        assert (this.assertInvariants(ItemProcessingState.TRANSLATED));
        return (T)this.requestToExecute;
    }

    public void markAsRequiringMappingUpdate() {
        assert (this.assertInvariants(ItemProcessingState.TRANSLATED));
        this.currentItemState = ItemProcessingState.WAIT_FOR_MAPPING_UPDATE;
        this.requestToExecute = null;
        assert (this.assertInvariants(ItemProcessingState.WAIT_FOR_MAPPING_UPDATE));
    }

    public void resetForExecutionForRetry() {
        this.assertInvariants(ItemProcessingState.WAIT_FOR_MAPPING_UPDATE, ItemProcessingState.EXECUTED);
        this.currentItemState = ItemProcessingState.INITIAL;
        this.requestToExecute = null;
        this.executionResult = null;
        ++this.retryCounter;
        this.assertInvariants(ItemProcessingState.INITIAL);
    }

    public void markOperationAsNoOp(DocWriteResponse response) {
        this.assertInvariants(ItemProcessingState.INITIAL);
        this.executionResult = new BulkItemResponse(this.getCurrentItem().id(), this.getCurrentItem().request().opType(), response);
        this.currentItemState = ItemProcessingState.EXECUTED;
        this.assertInvariants(ItemProcessingState.EXECUTED);
    }

    public void failOnMappingUpdate(Exception cause) {
        assert (this.assertInvariants(ItemProcessingState.WAIT_FOR_MAPPING_UPDATE));
        this.currentItemState = ItemProcessingState.EXECUTED;
        DocWriteRequest<?> docWriteRequest = this.getCurrentItem().request();
        this.executionResult = new BulkItemResponse(this.getCurrentItem().id(), docWriteRequest.opType(), new BulkItemResponse.Failure(this.getCurrentItem().index(), docWriteRequest.id(), cause));
        this.markAsCompleted(this.executionResult);
    }

    public void markOperationAsExecuted(Engine.Result result) {
        this.assertInvariants(ItemProcessingState.TRANSLATED);
        BulkItemRequest current = this.getCurrentItem();
        Object docWriteRequest = this.getRequestToExecute();
        switch (result.getResultType()) {
            case SUCCESS: {
                DocWriteResponse response;
                if (result.getOperationType() == Engine.Operation.TYPE.INDEX) {
                    Engine.IndexResult indexResult = (Engine.IndexResult)result;
                    response = new IndexResponse(this.primary.shardId(), this.requestToExecute.id(), result.getSeqNo(), result.getTerm(), indexResult.getVersion(), indexResult.isCreated());
                } else if (result.getOperationType() == Engine.Operation.TYPE.DELETE) {
                    Engine.DeleteResult deleteResult = (Engine.DeleteResult)result;
                    response = new DeleteResponse(this.primary.shardId(), this.requestToExecute.id(), deleteResult.getSeqNo(), result.getTerm(), deleteResult.getVersion(), deleteResult.isFound());
                } else {
                    throw new AssertionError((Object)("unknown result type :" + String.valueOf((Object)result.getResultType())));
                }
                this.executionResult = new BulkItemResponse(current.id(), current.request().opType(), response);
                ((ReplicationResponse)((Object)this.executionResult.getResponse())).setShardInfo(new ReplicationResponse.ShardInfo());
                this.locationToSync = TransportWriteAction.locationToSync(this.locationToSync, result.getTranslogLocation());
                break;
            }
            case FAILURE: {
                if (result.getFailure() instanceof AppendOnlyIndexOperationRetryException) {
                    Engine.IndexResult indexResult = (Engine.IndexResult)result;
                    IndexResponse indexResponse = new IndexResponse(this.primary.shardId(), this.requestToExecute.id(), result.getSeqNo(), result.getTerm(), indexResult.getVersion(), indexResult.isCreated());
                    this.executionResult = new BulkItemResponse(current.id(), current.request().opType(), indexResponse);
                    ((ReplicationResponse)((Object)this.executionResult.getResponse())).setShardInfo(new ReplicationResponse.ShardInfo());
                    break;
                }
                this.executionResult = new BulkItemResponse(current.id(), docWriteRequest.opType(), new BulkItemResponse.Failure(this.request.index(), docWriteRequest.id(), result.getFailure(), result.getSeqNo(), result.getTerm()));
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown result type for " + String.valueOf(this.getCurrentItem()) + ": " + String.valueOf((Object)result.getResultType())));
            }
        }
        this.currentItemState = ItemProcessingState.EXECUTED;
    }

    public void markAsCompleted(BulkItemResponse translatedResponse) {
        this.assertInvariants(ItemProcessingState.EXECUTED);
        assert (this.executionResult != null && translatedResponse.getItemId() == this.executionResult.getItemId());
        assert (translatedResponse.getItemId() == this.getCurrentItem().id());
        if (!translatedResponse.isFailed() && this.requestToExecute != null && this.requestToExecute != this.getCurrent()) {
            this.request.items()[this.currentIndex] = new BulkItemRequest(this.request.items()[this.currentIndex].id(), this.requestToExecute);
        }
        this.getCurrentItem().setPrimaryResponse(translatedResponse);
        this.currentItemState = ItemProcessingState.COMPLETED;
        this.advance();
    }

    public BulkShardResponse buildShardResponse() {
        assert (!this.hasMoreOperationsToExecute());
        return new BulkShardResponse(this.request.shardId(), (BulkItemResponse[])Arrays.stream(this.request.items()).map(BulkItemRequest::getPrimaryResponse).toArray(BulkItemResponse[]::new));
    }

    private boolean assertInvariants(ItemProcessingState ... expectedCurrentState) {
        assert (Arrays.asList(expectedCurrentState).contains((Object)this.currentItemState)) : "expected current state [" + String.valueOf((Object)this.currentItemState) + "] to be one of " + Arrays.toString((Object[])expectedCurrentState);
        assert (this.currentIndex >= 0) : this.currentIndex;
        assert (this.retryCounter >= 0) : this.retryCounter;
        switch (this.currentItemState) {
            case INITIAL: {
                assert (this.requestToExecute == null) : this.requestToExecute;
                assert (this.executionResult == null) : this.executionResult;
                break;
            }
            case TRANSLATED: {
                assert (this.requestToExecute != null);
                assert (this.executionResult == null) : this.executionResult;
                break;
            }
            case WAIT_FOR_MAPPING_UPDATE: {
                assert (this.requestToExecute == null);
                assert (this.executionResult == null) : this.executionResult;
                break;
            }
            case IMMEDIATE_RETRY: {
                assert (this.requestToExecute != null);
                assert (this.executionResult == null) : this.executionResult;
                break;
            }
            case EXECUTED: {
                assert (this.executionResult != null);
                break;
            }
            case COMPLETED: {
                assert (this.requestToExecute != null);
                assert (this.executionResult != null);
                assert (this.getCurrentItem().getPrimaryResponse() != null);
                break;
            }
        }
        return true;
    }

    static enum ItemProcessingState {
        INITIAL,
        TRANSLATED,
        WAIT_FOR_MAPPING_UPDATE,
        IMMEDIATE_RETRY,
        EXECUTED,
        COMPLETED;

    }
}

