/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.PlainShardsIterator;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RotationShardShuffler;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.ShardShuffler;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.common.Randomness;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.translog.BufferedChecksumStreamOutput;

@PublicApi(since="1.0.0")
public class IndexRoutingTable
extends AbstractDiffable<IndexRoutingTable>
implements Iterable<IndexShardRoutingTable> {
    private final Index index;
    private final ShardShuffler shuffler;
    private final Map<Integer, IndexShardRoutingTable> shards;
    private final List<ShardRouting> allActiveShards;

    IndexRoutingTable(Index index, Map<Integer, IndexShardRoutingTable> shards) {
        this.index = index;
        this.shuffler = new RotationShardShuffler(Randomness.get().nextInt());
        this.shards = Collections.unmodifiableMap(shards);
        ArrayList<ShardRouting> allActiveShards = new ArrayList<ShardRouting>();
        for (IndexShardRoutingTable cursor : shards.values()) {
            for (ShardRouting shardRouting : cursor) {
                if (!shardRouting.active()) continue;
                allActiveShards.add(shardRouting);
            }
        }
        this.allActiveShards = Collections.unmodifiableList(allActiveShards);
    }

    public Index getIndex() {
        return this.index;
    }

    boolean validate(Metadata metadata) {
        if (!metadata.hasIndex(this.index.getName())) {
            throw new IllegalStateException(String.valueOf(this.index) + " exists in routing does not exists in metadata");
        }
        IndexMetadata indexMetadata = metadata.index(this.index.getName());
        if (!indexMetadata.getIndexUUID().equals(this.index.getUUID())) {
            throw new IllegalStateException(this.index.getName() + " exists in routing does not exists in metadata with the same uuid");
        }
        if (indexMetadata.getNumberOfShards() != this.shards().size()) {
            HashSet<Integer> expected = new HashSet<Integer>();
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                expected.add(i);
            }
            for (IndexShardRoutingTable indexShardRoutingTable : this) {
                expected.remove(indexShardRoutingTable.shardId().id());
            }
            throw new IllegalStateException("Wrong number of shards in routing table, missing: " + String.valueOf(expected));
        }
        for (IndexShardRoutingTable indexShardRoutingTable : this) {
            int routingNumberOfReplicas = indexShardRoutingTable.size() - 1;
            if (routingNumberOfReplicas != indexMetadata.getNumberOfReplicas() + indexMetadata.getNumberOfSearchOnlyReplicas()) {
                throw new IllegalStateException("Shard [" + indexShardRoutingTable.shardId().id() + "] routing table has wrong number of replicas, expected [Replicas:  " + indexMetadata.getNumberOfReplicas() + "Search Replicas: " + indexMetadata.getNumberOfSearchOnlyReplicas() + "], got [" + routingNumberOfReplicas + "]");
            }
            for (ShardRouting shardRouting : indexShardRoutingTable) {
                if (!shardRouting.index().equals((Object)this.index)) {
                    throw new IllegalStateException("shard routing has an index [" + String.valueOf(shardRouting.index()) + "] that is different from the routing table");
                }
                Set<String> inSyncAllocationIds = indexMetadata.inSyncAllocationIds(shardRouting.id());
                if (shardRouting.active() && !inSyncAllocationIds.contains(shardRouting.allocationId().getId()) && !shardRouting.isSearchOnly()) {
                    throw new IllegalStateException("active shard routing " + String.valueOf(shardRouting) + " has no corresponding entry in the in-sync allocation set " + String.valueOf(inSyncAllocationIds));
                }
                if (!shardRouting.primary() || !shardRouting.initializing() || shardRouting.recoverySource().getType() != RecoverySource.Type.EXISTING_STORE) continue;
                if (inSyncAllocationIds.contains("_forced_allocation_")) {
                    if (inSyncAllocationIds.size() == 1) continue;
                    throw new IllegalStateException("a primary shard routing " + String.valueOf(shardRouting) + " is a primary that is recovering from a stale primary has unexpected allocation ids in in-sync allocation set " + String.valueOf(inSyncAllocationIds));
                }
                if (inSyncAllocationIds.contains(shardRouting.allocationId().getId())) continue;
                throw new IllegalStateException("a primary shard routing " + String.valueOf(shardRouting) + " is a primary that is recovering from a known allocation id but has no corresponding entry in the in-sync allocation set " + String.valueOf(inSyncAllocationIds));
            }
        }
        return true;
    }

    @Override
    public Iterator<IndexShardRoutingTable> iterator() {
        return this.shards.values().iterator();
    }

    public int numberOfNodesShardsAreAllocatedOn(String ... excludedNodes) {
        HashSet<String> nodes = new HashSet<String>();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            for (ShardRouting shardRouting : shardRoutingTable) {
                if (!shardRouting.assignedToNode()) continue;
                String currentNodeId = shardRouting.currentNodeId();
                boolean excluded = false;
                if (excludedNodes != null) {
                    for (String excludedNode : excludedNodes) {
                        if (!currentNodeId.equals(excludedNode)) continue;
                        excluded = true;
                        break;
                    }
                }
                if (excluded) continue;
                nodes.add(currentNodeId);
            }
        }
        return nodes.size();
    }

    public Map<Integer, IndexShardRoutingTable> shards() {
        return this.shards;
    }

    public Map<Integer, IndexShardRoutingTable> getShards() {
        return this.shards();
    }

    public IndexShardRoutingTable shard(int shardId) {
        return this.shards.get(shardId);
    }

    public boolean allPrimaryShardsActive() {
        return this.primaryShardsActive() == this.shards().size();
    }

    public int primaryShardsActive() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            if (!shardRoutingTable.primaryShard().active()) continue;
            ++counter;
        }
        return counter;
    }

    public boolean allPrimaryShardsUnassigned() {
        return this.primaryShardsUnassigned() == this.shards.size();
    }

    public int primaryShardsUnassigned() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            if (!shardRoutingTable.primaryShard().unassigned()) continue;
            ++counter;
        }
        return counter;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            shards.addAll(shardRoutingTable.shardsWithState(state));
        }
        return shards;
    }

    public List<ShardRouting> shardsMatchingPredicate(Predicate<ShardRouting> predicate) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            shards.addAll(shardRoutingTable.shardsMatchingPredicate(predicate));
        }
        return shards;
    }

    public int shardsMatchingPredicateCount(Predicate<ShardRouting> predicate) {
        int count = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            count += shardRoutingTable.shardsMatchingPredicateCount(predicate);
        }
        return count;
    }

    public ShardsIterator randomAllActiveShardsIt() {
        return new PlainShardsIterator(this.shuffler.shuffle(this.allActiveShards));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRoutingTable that = (IndexRoutingTable)o;
        if (!this.index.equals((Object)that.index)) {
            return false;
        }
        return this.shards.equals(that.shards);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public String toString() {
        return "IndexRoutingTable{shards=" + String.valueOf(this.shards) + ", index=" + String.valueOf(this.index) + "}";
    }

    public static IndexRoutingTable readFrom(StreamInput in) throws IOException {
        Index index = new Index(in);
        Builder builder = new Builder(index);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            builder.addIndexShard(IndexShardRoutingTable.Builder.readFromThin(in, index));
        }
        return builder.build();
    }

    public static Diff<IndexRoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return IndexRoutingTable.readDiffFrom(IndexRoutingTable::readFrom, in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shards.size());
        for (IndexShardRoutingTable indexShard : this) {
            IndexShardRoutingTable.Builder.writeToThin(indexShard, out);
        }
    }

    public void writeVerifiableTo(BufferedChecksumStreamOutput out) throws IOException {
        this.index.writeTo((StreamOutput)out);
        out.writeMapValues(this.shards, (stream, value) -> IndexShardRoutingTable.Builder.writeVerifiableTo(value, (BufferedChecksumStreamOutput)stream));
    }

    public static Builder builder(Index index) {
        return new Builder(index);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("-- index [" + String.valueOf(this.index) + "]\n");
        ArrayList<IndexShardRoutingTable> ordered = new ArrayList<IndexShardRoutingTable>();
        for (IndexShardRoutingTable indexShard : this) {
            ordered.add(indexShard);
        }
        CollectionUtil.timSort(ordered, (o1, o2) -> {
            int v = o1.shardId().getIndex().getName().compareTo(o2.shardId().getIndex().getName());
            if (v == 0) {
                v = Integer.compare(o1.shardId().id(), o2.shardId().id());
            }
            return v;
        });
        for (IndexShardRoutingTable indexShard : ordered) {
            sb.append("----shard_id [").append(indexShard.shardId().getIndex().getName()).append("][").append(indexShard.shardId().id()).append("]\n");
            for (ShardRouting shard : indexShard) {
                sb.append("--------").append(shard.shortSummary()).append("\n");
            }
        }
        return sb.toString();
    }

    @PublicApi(since="1.0.0")
    public static class Builder {
        private final Index index;
        private final Map<Integer, IndexShardRoutingTable> shards = new HashMap<Integer, IndexShardRoutingTable>();

        public Builder(Index index) {
            this.index = index;
        }

        public Builder initializeAsNew(IndexMetadata indexMetadata) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null));
        }

        public Builder initializeAsRecovery(IndexMetadata indexMetadata) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.CLUSTER_RECOVERED, null));
        }

        public Builder initializeAsFromDangling(IndexMetadata indexMetadata) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.DANGLING_INDEX_IMPORTED, null));
        }

        public Builder initializeAsFromCloseToOpen(IndexMetadata indexMetadata) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.INDEX_REOPENED, null));
        }

        public Builder initializeAsFromOpenToClose(IndexMetadata indexMetadata) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.INDEX_CLOSED, null));
        }

        public Builder initializeAsNewRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource, Set<Integer> ignoreShards) {
            UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.NEW_INDEX_RESTORED, "restore_source[" + recoverySource.snapshot().getRepository() + "/" + recoverySource.snapshot().getSnapshotId().getName() + "]");
            return this.initializeAsRestore(indexMetadata, recoverySource, ignoreShards, true, unassignedInfo);
        }

        public Builder initializeAsRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource) {
            UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.EXISTING_INDEX_RESTORED, "restore_source[" + recoverySource.snapshot().getRepository() + "/" + recoverySource.snapshot().getSnapshotId().getName() + "]");
            return this.initializeAsRestore(indexMetadata, recoverySource, null, false, unassignedInfo);
        }

        public Builder initializeAsRemoteStoreRestore(IndexMetadata indexMetadata, RecoverySource.RemoteStoreRecoverySource recoverySource, Map<ShardId, IndexShardRoutingTable> indexShardRoutingTableMap, boolean forceRecoverAllPrimaries) {
            UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.EXISTING_INDEX_RESTORED, "restore_source[remote_store]");
            assert (indexMetadata.getIndex().equals((Object)this.index));
            if (!this.shards.isEmpty()) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            for (int shardNumber = 0; shardNumber < indexMetadata.getNumberOfShards(); ++shardNumber) {
                ShardId shardId = new ShardId(this.index, shardNumber);
                if (!indexShardRoutingTableMap.containsKey(shardId)) {
                    throw new IllegalStateException("IndexShardRoutingTable is not present for shardId: " + String.valueOf(shardId));
                }
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
                IndexShardRoutingTable indexShardRoutingTable = indexShardRoutingTableMap.get(shardId);
                if (forceRecoverAllPrimaries || indexShardRoutingTable.primaryShard().unassigned()) {
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, true, recoverySource, unassignedInfo));
                    for (int replicaNumber = 0; replicaNumber < indexMetadata.getNumberOfReplicas(); ++replicaNumber) {
                        indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, false, RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo));
                    }
                    for (ShardRouting shardRouting : indexShardRoutingTable.searchOnlyReplicas()) {
                        if (shardRouting.unassigned()) {
                            indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, false, true, RecoverySource.EmptyStoreRecoverySource.INSTANCE, unassignedInfo));
                            continue;
                        }
                        indexShardRoutingBuilder.addShard(shardRouting);
                    }
                } else {
                    indexShardRoutingBuilder.addShard(indexShardRoutingTable.primaryShard());
                    for (ShardRouting shardRouting : indexShardRoutingTable.replicaShards()) {
                        if (shardRouting.unassigned()) {
                            if (shardRouting.isSearchOnly()) {
                                indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, false, true, RecoverySource.EmptyStoreRecoverySource.INSTANCE, unassignedInfo));
                                continue;
                            }
                            indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, false, RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo));
                            continue;
                        }
                        indexShardRoutingBuilder.addShard(shardRouting);
                    }
                }
                this.shards.put(shardNumber, indexShardRoutingBuilder.build());
            }
            return this;
        }

        private Builder initializeAsRestore(IndexMetadata indexMetadata, RecoverySource recoverySource, Set<Integer> ignoreShards, boolean asNew, UnassignedInfo unassignedInfo) {
            assert (indexMetadata.getIndex().equals((Object)this.index));
            if (!this.shards.isEmpty()) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            for (int shardNumber = 0; shardNumber < indexMetadata.getNumberOfShards(); ++shardNumber) {
                int i;
                ShardId shardId = new ShardId(this.index, shardNumber);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
                for (i = 0; i <= indexMetadata.getNumberOfReplicas(); ++i) {
                    boolean primary;
                    boolean bl = primary = i == 0;
                    if (asNew && ignoreShards.contains(shardNumber)) {
                        indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo));
                        continue;
                    }
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? recoverySource : RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo));
                }
                for (i = 0; i < indexMetadata.getNumberOfSearchOnlyReplicas(); ++i) {
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, false, true, RecoverySource.EmptyStoreRecoverySource.INSTANCE, unassignedInfo));
                }
                this.shards.put(shardNumber, indexShardRoutingBuilder.build());
            }
            return this;
        }

        private Builder initializeEmpty(IndexMetadata indexMetadata, UnassignedInfo unassignedInfo) {
            assert (indexMetadata.getIndex().equals((Object)this.index));
            if (!this.shards.isEmpty()) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            for (int shardNumber = 0; shardNumber < indexMetadata.getNumberOfShards(); ++shardNumber) {
                int i;
                ShardId shardId = new ShardId(this.index, shardNumber);
                RecoverySource primaryRecoverySource = !indexMetadata.inSyncAllocationIds(shardNumber).isEmpty() ? RecoverySource.ExistingStoreRecoverySource.INSTANCE : (indexMetadata.getResizeSourceIndex() != null ? RecoverySource.LocalShardsRecoverySource.INSTANCE : RecoverySource.EmptyStoreRecoverySource.INSTANCE);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
                for (i = 0; i <= indexMetadata.getNumberOfReplicas(); ++i) {
                    boolean primary = i == 0;
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? primaryRecoverySource : RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo));
                }
                for (i = 0; i < indexMetadata.getNumberOfSearchOnlyReplicas(); ++i) {
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, false, true, RecoverySource.EmptyStoreRecoverySource.INSTANCE, unassignedInfo));
                }
                this.shards.put(shardNumber, indexShardRoutingBuilder.build());
            }
            return this;
        }

        public Builder addReplica() {
            for (int shardNumber : this.shards.keySet()) {
                ShardId shardId = new ShardId(this.index, shardNumber);
                ShardRouting shard = ShardRouting.newUnassigned(shardId, false, RecoverySource.PeerRecoverySource.INSTANCE, new UnassignedInfo(UnassignedInfo.Reason.REPLICA_ADDED, null));
                this.shards.put(shardNumber, new IndexShardRoutingTable.Builder(this.shards.get(shard.id())).addShard(shard).build());
            }
            return this;
        }

        public Builder addSearchReplica() {
            for (int shardNumber : this.shards.keySet()) {
                ShardId shardId = new ShardId(this.index, shardNumber);
                ShardRouting shard = ShardRouting.newUnassigned(shardId, false, true, RecoverySource.EmptyStoreRecoverySource.INSTANCE, new UnassignedInfo(UnassignedInfo.Reason.REPLICA_ADDED, null));
                this.shards.put(shardNumber, new IndexShardRoutingTable.Builder(this.shards.get(shard.id())).addShard(shard).build());
            }
            return this;
        }

        public Builder removeReplica() {
            for (int shardId : this.shards.keySet()) {
                IndexShardRoutingTable indexShard = this.shards.get(shardId);
                if (indexShard.replicaShards().isEmpty()) {
                    return this;
                }
                IndexShardRoutingTable.Builder builder = new IndexShardRoutingTable.Builder(indexShard.shardId());
                for (ShardRouting shardRouting : indexShard) {
                    builder.addShard(shardRouting);
                }
                boolean removed = false;
                for (ShardRouting shardRouting : indexShard) {
                    if (shardRouting.primary() || shardRouting.assignedToNode() || shardRouting.isSearchOnly()) continue;
                    builder.removeShard(shardRouting);
                    removed = true;
                    break;
                }
                if (!removed) {
                    for (ShardRouting shardRouting : indexShard) {
                        if (shardRouting.primary() || shardRouting.isSearchOnly()) continue;
                        builder.removeShard(shardRouting);
                        break;
                    }
                }
                this.shards.put(shardId, builder.build());
            }
            return this;
        }

        public Builder removeSearchReplica() {
            for (int shardId : this.shards.keySet()) {
                IndexShardRoutingTable indexShardRoutingTable = this.shards.get(shardId);
                if (indexShardRoutingTable.searchOnlyReplicas().isEmpty()) {
                    return this;
                }
                IndexShardRoutingTable.Builder builder = new IndexShardRoutingTable.Builder(indexShardRoutingTable.shardId());
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    builder.addShard(shardRouting);
                }
                boolean removed = false;
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (!shardRouting.isSearchOnly() || shardRouting.assignedToNode()) continue;
                    builder.removeShard(shardRouting);
                    removed = true;
                    break;
                }
                if (!removed) {
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        if (!shardRouting.isSearchOnly()) continue;
                        builder.removeShard(shardRouting);
                        break;
                    }
                }
                this.shards.put(shardId, builder.build());
            }
            return this;
        }

        public Builder addIndexShard(IndexShardRoutingTable indexShard) {
            this.shards.put(indexShard.shardId().id(), indexShard);
            return this;
        }

        public Builder addShard(ShardRouting shard) {
            IndexShardRoutingTable indexShard = this.shards.get(shard.id());
            indexShard = indexShard == null ? new IndexShardRoutingTable.Builder(shard.shardId()).addShard(shard).build() : new IndexShardRoutingTable.Builder(indexShard).addShard(shard).build();
            this.shards.put(indexShard.shardId().id(), indexShard);
            return this;
        }

        public IndexRoutingTable build() {
            return new IndexRoutingTable(this.index, this.shards);
        }
    }
}

