"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = require("lodash");
var _helpers = require("./utils/helpers");
var _adHelpers = require("./utils/adHelpers");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const MAX_DETECTOR_COUNT = 1000;
class DestinationsService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getDetector", async (context, req, res) => {
      const {
        detectorId
      } = req.params;
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alertingAD.getDetector', {
          detectorId
        });
        const {
          anomaly_detector,
          _seq_no: seqNo,
          _primary_term: primaryTerm,
          _version: version
        } = resp;
        return res.ok({
          body: {
            ok: true,
            detector: anomaly_detector,
            version,
            seqNo,
            primaryTerm
          }
        });
      } catch (err) {
        console.error('Alerting - AnomalyDetectorService - getDetector:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getDetectors", async (context, req, res) => {
      const searchRequest = {
        query: {
          bool: {}
        },
        size: MAX_DETECTOR_COUNT
      };
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alertingAD.searchDetectors', {
          body: searchRequest
        });
        const totalDetectors = resp.hits.total.value;
        const detectors = resp.hits.hits.map(hit => {
          const {
            _source: detector,
            _id: id,
            _version: version,
            _seq_no: seqNo,
            _primary_term: primaryTerm
          } = hit;
          return {
            id,
            ...detector,
            version,
            seqNo,
            primaryTerm
          };
        });
        return res.ok({
          body: {
            ok: true,
            detectors: (0, _helpers.mapKeysDeep)(detectors, _helpers.toCamel),
            totalDetectors
          }
        });
      } catch (err) {
        console.error('Alerting - AnomalyDetectorService - searchDetectors:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getDetectorResults", async (context, req, res) => {
      try {
        const {
          startTime = 0,
          endTime = 20,
          preview = 'false'
        } = req.query;
        const {
          detectorId
        } = req.params;
        const client = this.getClientBasedOnDataSource(context, req);
        if (preview == 'true') {
          const requestBody = {
            period_start: startTime,
            period_end: endTime
          };
          const previewResponse = await client('alertingAD.previewDetector', {
            detectorId,
            body: requestBody
          });
          const transformedKeys = (0, _helpers.mapKeysDeep)(previewResponse, _helpers.toCamel);
          return res.ok({
            body: {
              ok: true,
              response: {
                anomalyResult: (0, _adHelpers.anomalyResultMapper)(transformedKeys.anomalyResult),
                detector: transformedKeys.anomalyDetector
              }
            }
          });
        } else {
          //Get results
          const requestBody = {
            size: 10000,
            sort: {
              data_start_time: 'asc'
            },
            query: {
              bool: {
                filter: [{
                  term: {
                    detector_id: detectorId
                  }
                }, {
                  range: {
                    data_start_time: {
                      gte: startTime,
                      lte: endTime
                    }
                  }
                }]
              }
            }
          };
          const detectorResponse = await client('alertingAD.getDetector', {
            detectorId
          });
          const anomaliesResponse = await client('alertingAD.searchResults', {
            body: requestBody
          });
          const transformedKeys = (0, _lodash.get)(anomaliesResponse, 'hits.hits', []).map(result => (0, _helpers.mapKeysDeep)(result._source, _helpers.toCamel));
          return res.ok({
            body: {
              ok: true,
              response: {
                detector: (0, _helpers.mapKeysDeep)((0, _lodash.get)(detectorResponse, 'anomaly_detector', {}), _helpers.toCamel),
                anomalyResult: (0, _adHelpers.anomalyResultMapper)(transformedKeys)
              }
            }
          });
        }
      } catch (err) {
        console.log('Alerting - AnomalyDetectorService - getDetectorResults', err);
        return res.ok({
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = DestinationsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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