"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerMLRoutes = registerMLRoutes;
var _helpers = require("../utils/helpers");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */
function registerMLRoutes(apiRouter, mlService) {
  apiRouter.post('/agents/{agentId}/execute', mlService.executeAgent);
  apiRouter.post('/agents/{agentId}/execute/{dataSourceId}', mlService.executeAgent);
}
class MLService {
  constructor(client, dataSourceEnabled) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "executeAgent", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          agentId,
          dataSourceId = ''
        } = request.params;
        const {
          indices
        } = request.body;
        const callWithRequest = (0, _helpers.getClientBasedOnDataSource)(context, this.dataSourceEnabled, request, dataSourceId, this.client);
        const requestBody = {
          parameters: {
            input: indices
          }
        };
        const response = await callWithRequest('ml.executeAgent', {
          agentId: agentId,
          async: true,
          body: requestBody
        });
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response: response
          }
        });
      } catch (err) {
        var _err$body, _err$body2;
        console.log('ML - execute agent failed', err);
        const errorDetails = (err === null || err === void 0 || (_err$body = err.body) === null || _err$body === void 0 || (_err$body = _err$body.error) === null || _err$body === void 0 ? void 0 : _err$body.details) || (err === null || err === void 0 || (_err$body2 = err.body) === null || _err$body2 === void 0 || (_err$body2 = _err$body2.error) === null || _err$body2 === void 0 ? void 0 : _err$body2.reason);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: errorDetails
          }
        });
      }
    });
    this.client = client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.default = MLService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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