"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomImportMapPlugin = void 0;
var _operators = require("rxjs/operators");
var _flights_saved_objects = require("./services/sample_data/flights_saved_objects");
var _clusters = require("./clusters");
var _services = require("./services");
var _routes = require("../server/routes");
var _saved_objects = require("./saved_objects");
var _capabilities_provider = require("./saved_objects/capabilities_provider");
var _geospatial_plugin = _interopRequireDefault(require("./clusters/geospatial_plugin"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class CustomImportMapPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    _defineProperty(this, "config$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
    this.config$ = initializerContext.config.create();
  }

  // Adds dashboards-maps saved objects to existing sample datasets using home plugin
  addMapsSavedObjects(home, config) {
    home.sampleData.addSavedObjectsToSampleDataset('flights', (0, _flights_saved_objects.getFlightsSavedObjects)(config));
  }
  async setup(core, plugins) {
    this.logger.debug('customImportMap: Setup');
    // @ts-ignore
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    // @ts-ignore
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const geospatialClient = (0, _clusters.createGeospatialCluster)(core, globalConfig);
    // Initialize services
    const geospatialService = new _services.GeospatialService(geospatialClient);
    const opensearchService = new _services.OpensearchService(geospatialClient);
    const router = core.http.createRouter();
    const {
      home,
      dataSource
    } = plugins;
    if (dataSource) {
      dataSource.registerCustomApiSchema(_geospatial_plugin.default);
    }

    // Register server side APIs
    (0, _routes.geospatial)(geospatialService, router);
    (0, _routes.opensearch)(opensearchService, router);
    (0, _routes.statsRoute)(router, this.logger);

    // Register saved object types
    core.savedObjects.registerType(_saved_objects.mapSavedObjectsType);

    // Register capabilities
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    if (home) this.addMapsSavedObjects(home, config);
    return {};
  }
  start(core) {
    this.logger.debug('customImportMap: Started');
    return {};
  }
  stop() {}
}
exports.CustomImportMapPlugin = CustomImportMapPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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