"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _sample_savedObjects = require("../../common/helpers/events_explorer/sample_savedObjects");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// eslint-disable-next-line import/no-default-export
class SavedObjectFacet {
  constructor(client) {
    this.client = client;
    _defineProperty(this, "fetch", async (request, params, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics fetch error: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "create", async (request, format, objectType) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          body: {
            [objectType]: {
              ...request.body.object
            }
          }
        };
        const savedRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedRes;
      } catch (err) {
        console.error('Event analytics create error: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "createTimestamp", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          body: {
            objectId: request.body.index,
            timestamp: {
              ...request.body
            }
          }
        };
        const savedRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedRes;
      } catch (err) {
        console.error('Event analytics create timestamp error: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "updateTimestamp", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          objectId: request.body.objectId,
          body: {
            ...request.body
          }
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics update error: ', err);
        res.data = err.message;
      }
      return res;
    });
    _defineProperty(this, "update", async (request, format, objectType) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          objectId: request.body.object_id,
          body: {
            [objectType]: {
              ...request.body.object
            }
          }
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics update error: ', err);
        res.data = err.message;
      }
      return res;
    });
    _defineProperty(this, "delete", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          objectIdList: request.params.objectIdList
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics delete error: ', err);
        res.data = err.message;
      }
      return res;
    });
    _defineProperty(this, "createSamples", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const savedVizIds = [];
        const savedQueryIds = [];
        if (['panels', 'event_analytics'].includes(request.params.sampleRequestor)) {
          for (let i = 0; i < _sample_savedObjects.sampleVisualizations.length; i++) {
            const params = {
              body: {
                savedVisualization: {
                  ..._sample_savedObjects.sampleVisualizations[i]
                }
              }
            };
            const savedVizRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
            savedVizIds.push(savedVizRes.objectId);
          }
          for (let i = 0; i < _sample_savedObjects.sampleQueries.length; i++) {
            const params = {
              body: {
                savedQuery: {
                  ..._sample_savedObjects.sampleQueries[i]
                }
              }
            };
            const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
            savedQueryIds.push(savedQueryRes.objectId);
          }
        }
        res.success = true;
        res.data = {
          savedVizIds,
          savedQueryIds
        };
      } catch (err) {
        console.error('Event analytics create error: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "getSavedObject", async request => {
      const params = {};
      for (const [param, value] of request.url.searchParams.entries()) {
        params[param] = value;
      }
      return this.fetch(request, {
        ...params
      }, 'observability.getObject');
    });
    _defineProperty(this, "createSavedQuery", async request => {
      return this.create(request, 'observability.createObject', 'savedQuery');
    });
    _defineProperty(this, "createSavedVisualization", request => {
      return this.create(request, 'observability.createObject', 'savedVisualization');
    });
    _defineProperty(this, "createSavedTimestamp", request => {
      return this.createTimestamp(request, 'observability.createObject');
    });
    _defineProperty(this, "updateSavedTimestamp", request => {
      return this.updateTimestamp(request, 'observability.updateObjectById');
    });
    _defineProperty(this, "updateSavedQuery", request => {
      return this.update(request, 'observability.updateObjectById', 'savedQuery');
    });
    _defineProperty(this, "updateSavedVisualization", request => {
      return this.update(request, 'observability.updateObjectById', 'savedVisualization');
    });
    _defineProperty(this, "deleteSavedObject", async request => {
      return this.delete(request, 'observability.deleteObjectByIdList');
    });
    _defineProperty(this, "createSampleSavedObjects", async request => {
      return this.createSamples(request, 'observability.createObject');
    });
    this.client = client;
  }
}
exports.default = SavedObjectFacet;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc2FtcGxlX3NhdmVkT2JqZWN0cyIsInJlcXVpcmUiLCJfZGVmaW5lUHJvcGVydHkiLCJlIiwiciIsInQiLCJfdG9Qcm9wZXJ0eUtleSIsIk9iamVjdCIsImRlZmluZVByb3BlcnR5IiwidmFsdWUiLCJlbnVtZXJhYmxlIiwiY29uZmlndXJhYmxlIiwid3JpdGFibGUiLCJpIiwiX3RvUHJpbWl0aXZlIiwiU3ltYm9sIiwidG9QcmltaXRpdmUiLCJjYWxsIiwiVHlwZUVycm9yIiwiU3RyaW5nIiwiTnVtYmVyIiwiU2F2ZWRPYmplY3RGYWNldCIsImNvbnN0cnVjdG9yIiwiY2xpZW50IiwicmVxdWVzdCIsInBhcmFtcyIsImZvcm1hdCIsInJlcyIsInN1Y2Nlc3MiLCJkYXRhIiwic2F2ZWRRdWVyeVJlcyIsImFzU2NvcGVkIiwiY2FsbEFzQ3VycmVudFVzZXIiLCJlcnIiLCJjb25zb2xlIiwiZXJyb3IiLCJvYmplY3RUeXBlIiwiYm9keSIsIm9iamVjdCIsInNhdmVkUmVzIiwib2JqZWN0SWQiLCJpbmRleCIsInRpbWVzdGFtcCIsIm1lc3NhZ2UiLCJvYmplY3RfaWQiLCJvYmplY3RJZExpc3QiLCJzYXZlZFZpeklkcyIsInNhdmVkUXVlcnlJZHMiLCJpbmNsdWRlcyIsInNhbXBsZVJlcXVlc3RvciIsInNhbXBsZVZpc3VhbGl6YXRpb25zIiwibGVuZ3RoIiwic2F2ZWRWaXN1YWxpemF0aW9uIiwic2F2ZWRWaXpSZXMiLCJwdXNoIiwic2FtcGxlUXVlcmllcyIsInNhdmVkUXVlcnkiLCJwYXJhbSIsInVybCIsInNlYXJjaFBhcmFtcyIsImVudHJpZXMiLCJmZXRjaCIsImNyZWF0ZSIsImNyZWF0ZVRpbWVzdGFtcCIsInVwZGF0ZVRpbWVzdGFtcCIsInVwZGF0ZSIsImRlbGV0ZSIsImNyZWF0ZVNhbXBsZXMiLCJleHBvcnRzIiwiZGVmYXVsdCIsIm1vZHVsZSJdLCJzb3VyY2VzIjpbInNhdmVkX29iamVjdHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBJTGVnYWN5Q2x1c3RlckNsaWVudCwgU2NvcGVhYmxlUmVxdWVzdCB9IGZyb20gJy4uLy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XG5pbXBvcnQge1xuICBzYW1wbGVRdWVyaWVzLFxuICBzYW1wbGVWaXN1YWxpemF0aW9ucyxcbn0gZnJvbSAnLi4vLi4vY29tbW9uL2hlbHBlcnMvZXZlbnRzX2V4cGxvcmVyL3NhbXBsZV9zYXZlZE9iamVjdHMnO1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgaW1wb3J0L25vLWRlZmF1bHQtZXhwb3J0XG5leHBvcnQgZGVmYXVsdCBjbGFzcyBTYXZlZE9iamVjdEZhY2V0IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBjbGllbnQ6IElMZWdhY3lDbHVzdGVyQ2xpZW50KSB7XG4gICAgdGhpcy5jbGllbnQgPSBjbGllbnQ7XG4gIH1cblxuICBmZXRjaCA9IGFzeW5jIChyZXF1ZXN0OiBTY29wZWFibGVSZXF1ZXN0LCBwYXJhbXM6IFJlY29yZDxzdHJpbmcsIGFueT4sIGZvcm1hdDogc3RyaW5nKSA9PiB7XG4gICAgY29uc3QgcmVzID0ge1xuICAgICAgc3VjY2VzczogZmFsc2UsXG4gICAgICBkYXRhOiB7fSxcbiAgICB9O1xuICAgIHRyeSB7XG4gICAgICBjb25zdCBzYXZlZFF1ZXJ5UmVzID0gYXdhaXQgdGhpcy5jbGllbnQuYXNTY29wZWQocmVxdWVzdCkuY2FsbEFzQ3VycmVudFVzZXIoZm9ybWF0LCBwYXJhbXMpO1xuICAgICAgcmVzLnN1Y2Nlc3MgPSB0cnVlO1xuICAgICAgcmVzLmRhdGEgPSBzYXZlZFF1ZXJ5UmVzO1xuICAgIH0gY2F0Y2ggKGVycjogYW55KSB7XG4gICAgICBjb25zb2xlLmVycm9yKCdFdmVudCBhbmFseXRpY3MgZmV0Y2ggZXJyb3I6ICcsIGVycik7XG4gICAgICByZXMuZGF0YSA9IGVycjtcbiAgICB9XG4gICAgcmV0dXJuIHJlcztcbiAgfTtcblxuICBjcmVhdGUgPSBhc3luYyAocmVxdWVzdDogYW55LCBmb3JtYXQ6IHN0cmluZywgb2JqZWN0VHlwZTogc3RyaW5nKSA9PiB7XG4gICAgY29uc3QgcmVzID0ge1xuICAgICAgc3VjY2VzczogZmFsc2UsXG4gICAgICBkYXRhOiB7fSxcbiAgICB9O1xuICAgIHRyeSB7XG4gICAgICBjb25zdCBwYXJhbXMgPSB7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBbb2JqZWN0VHlwZV06IHtcbiAgICAgICAgICAgIC4uLnJlcXVlc3QuYm9keS5vYmplY3QsXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH07XG4gICAgICBjb25zdCBzYXZlZFJlcyA9IGF3YWl0IHRoaXMuY2xpZW50LmFzU2NvcGVkKHJlcXVlc3QpLmNhbGxBc0N1cnJlbnRVc2VyKGZvcm1hdCwgcGFyYW1zKTtcbiAgICAgIHJlcy5zdWNjZXNzID0gdHJ1ZTtcbiAgICAgIHJlcy5kYXRhID0gc2F2ZWRSZXM7XG4gICAgfSBjYXRjaCAoZXJyOiBhbnkpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ0V2ZW50IGFuYWx5dGljcyBjcmVhdGUgZXJyb3I6ICcsIGVycik7XG4gICAgICByZXMuZGF0YSA9IGVycjtcbiAgICB9XG4gICAgcmV0dXJuIHJlcztcbiAgfTtcblxuICBjcmVhdGVUaW1lc3RhbXAgPSBhc3luYyAocmVxdWVzdDogYW55LCBmb3JtYXQ6IHN0cmluZykgPT4ge1xuICAgIGNvbnN0IHJlcyA9IHtcbiAgICAgIHN1Y2Nlc3M6IGZhbHNlLFxuICAgICAgZGF0YToge30sXG4gICAgfTtcbiAgICB0cnkge1xuICAgICAgY29uc3QgcGFyYW1zID0ge1xuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2JqZWN0SWQ6IHJlcXVlc3QuYm9keS5pbmRleCxcbiAgICAgICAgICB0aW1lc3RhbXA6IHtcbiAgICAgICAgICAgIC4uLnJlcXVlc3QuYm9keSxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgfTtcbiAgICAgIGNvbnN0IHNhdmVkUmVzID0gYXdhaXQgdGhpcy5jbGllbnQuYXNTY29wZWQocmVxdWVzdCkuY2FsbEFzQ3VycmVudFVzZXIoZm9ybWF0LCBwYXJhbXMpO1xuICAgICAgcmVzLnN1Y2Nlc3MgPSB0cnVlO1xuICAgICAgcmVzLmRhdGEgPSBzYXZlZFJlcztcbiAgICB9IGNhdGNoIChlcnI6IGFueSkge1xuICAgICAgY29uc29sZS5lcnJvcignRXZlbnQgYW5hbHl0aWNzIGNyZWF0ZSB0aW1lc3RhbXAgZXJyb3I6ICcsIGVycik7XG4gICAgICByZXMuZGF0YSA9IGVycjtcbiAgICB9XG4gICAgcmV0dXJuIHJlcztcbiAgfTtcblxuICB1cGRhdGVUaW1lc3RhbXAgPSBhc3luYyAocmVxdWVzdDogYW55LCBmb3JtYXQ6IHN0cmluZykgPT4ge1xuICAgIGNvbnN0IHJlcyA9IHtcbiAgICAgIHN1Y2Nlc3M6IGZhbHNlLFxuICAgICAgZGF0YToge30sXG4gICAgfTtcbiAgICB0cnkge1xuICAgICAgY29uc3QgcGFyYW1zID0ge1xuICAgICAgICBvYmplY3RJZDogcmVxdWVzdC5ib2R5Lm9iamVjdElkLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgLi4ucmVxdWVzdC5ib2R5LFxuICAgICAgICB9LFxuICAgICAgfTtcbiAgICAgIGNvbnN0IHNhdmVkUXVlcnlSZXMgPSBhd2FpdCB0aGlzLmNsaWVudC5hc1Njb3BlZChyZXF1ZXN0KS5jYWxsQXNDdXJyZW50VXNlcihmb3JtYXQsIHBhcmFtcyk7XG4gICAgICByZXMuc3VjY2VzcyA9IHRydWU7XG4gICAgICByZXMuZGF0YSA9IHNhdmVkUXVlcnlSZXM7XG4gICAgfSBjYXRjaCAoZXJyOiBhbnkpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ0V2ZW50IGFuYWx5dGljcyB1cGRhdGUgZXJyb3I6ICcsIGVycik7XG4gICAgICByZXMuZGF0YSA9IGVyci5tZXNzYWdlO1xuICAgIH1cbiAgICByZXR1cm4gcmVzO1xuICB9O1xuXG4gIHVwZGF0ZSA9IGFzeW5jIChyZXF1ZXN0OiBhbnksIGZvcm1hdDogc3RyaW5nLCBvYmplY3RUeXBlOiBzdHJpbmcpID0+IHtcbiAgICBjb25zdCByZXMgPSB7XG4gICAgICBzdWNjZXNzOiBmYWxzZSxcbiAgICAgIGRhdGE6IHt9LFxuICAgIH07XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHBhcmFtcyA9IHtcbiAgICAgICAgb2JqZWN0SWQ6IHJlcXVlc3QuYm9keS5vYmplY3RfaWQsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBbb2JqZWN0VHlwZV06IHtcbiAgICAgICAgICAgIC4uLnJlcXVlc3QuYm9keS5vYmplY3QsXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH07XG4gICAgICBjb25zdCBzYXZlZFF1ZXJ5UmVzID0gYXdhaXQgdGhpcy5jbGllbnQuYXNTY29wZWQocmVxdWVzdCkuY2FsbEFzQ3VycmVudFVzZXIoZm9ybWF0LCBwYXJhbXMpO1xuICAgICAgcmVzLnN1Y2Nlc3MgPSB0cnVlO1xuICAgICAgcmVzLmRhdGEgPSBzYXZlZFF1ZXJ5UmVzO1xuICAgIH0gY2F0Y2ggKGVycjogYW55KSB7XG4gICAgICBjb25zb2xlLmVycm9yKCdFdmVudCBhbmFseXRpY3MgdXBkYXRlIGVycm9yOiAnLCBlcnIpO1xuICAgICAgcmVzLmRhdGEgPSBlcnIubWVzc2FnZTtcbiAgICB9XG4gICAgcmV0dXJuIHJlcztcbiAgfTtcblxuICBkZWxldGUgPSBhc3luYyAocmVxdWVzdDogYW55LCBmb3JtYXQ6IHN0cmluZykgPT4ge1xuICAgIGNvbnN0IHJlcyA9IHtcbiAgICAgIHN1Y2Nlc3M6IGZhbHNlLFxuICAgICAgZGF0YToge30sXG4gICAgfTtcbiAgICB0cnkge1xuICAgICAgY29uc3QgcGFyYW1zID0ge1xuICAgICAgICBvYmplY3RJZExpc3Q6IHJlcXVlc3QucGFyYW1zLm9iamVjdElkTGlzdCxcbiAgICAgIH07XG4gICAgICBjb25zdCBzYXZlZFF1ZXJ5UmVzID0gYXdhaXQgdGhpcy5jbGllbnQuYXNTY29wZWQocmVxdWVzdCkuY2FsbEFzQ3VycmVudFVzZXIoZm9ybWF0LCBwYXJhbXMpO1xuICAgICAgcmVzLnN1Y2Nlc3MgPSB0cnVlO1xuICAgICAgcmVzLmRhdGEgPSBzYXZlZFF1ZXJ5UmVzO1xuICAgIH0gY2F0Y2ggKGVycjogYW55KSB7XG4gICAgICBjb25zb2xlLmVycm9yKCdFdmVudCBhbmFseXRpY3MgZGVsZXRlIGVycm9yOiAnLCBlcnIpO1xuICAgICAgcmVzLmRhdGEgPSBlcnIubWVzc2FnZTtcbiAgICB9XG4gICAgcmV0dXJuIHJlcztcbiAgfTtcblxuICBjcmVhdGVTYW1wbGVzID0gYXN5bmMgKHJlcXVlc3Q6IGFueSwgZm9ybWF0OiBzdHJpbmcpID0+IHtcbiAgICBjb25zdCByZXMgPSB7XG4gICAgICBzdWNjZXNzOiBmYWxzZSxcbiAgICAgIGRhdGE6IHt9LFxuICAgIH07XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHNhdmVkVml6SWRzOiBhbnlbXSA9IFtdO1xuICAgICAgY29uc3Qgc2F2ZWRRdWVyeUlkczogYW55W10gPSBbXTtcblxuICAgICAgaWYgKFsncGFuZWxzJywgJ2V2ZW50X2FuYWx5dGljcyddLmluY2x1ZGVzKHJlcXVlc3QucGFyYW1zLnNhbXBsZVJlcXVlc3RvcikpIHtcbiAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCBzYW1wbGVWaXN1YWxpemF0aW9ucy5sZW5ndGg7IGkrKykge1xuICAgICAgICAgIGNvbnN0IHBhcmFtcyA9IHtcbiAgICAgICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAgICAgc2F2ZWRWaXN1YWxpemF0aW9uOiB7XG4gICAgICAgICAgICAgICAgLi4uc2FtcGxlVmlzdWFsaXphdGlvbnNbaV0sXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH07XG4gICAgICAgICAgY29uc3Qgc2F2ZWRWaXpSZXMgPSBhd2FpdCB0aGlzLmNsaWVudC5hc1Njb3BlZChyZXF1ZXN0KS5jYWxsQXNDdXJyZW50VXNlcihmb3JtYXQsIHBhcmFtcyk7XG4gICAgICAgICAgc2F2ZWRWaXpJZHMucHVzaChzYXZlZFZpelJlcy5vYmplY3RJZCk7XG4gICAgICAgIH1cblxuICAgICAgICBmb3IgKGxldCBpID0gMDsgaSA8IHNhbXBsZVF1ZXJpZXMubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgICBjb25zdCBwYXJhbXMgPSB7XG4gICAgICAgICAgICBib2R5OiB7XG4gICAgICAgICAgICAgIHNhdmVkUXVlcnk6IHtcbiAgICAgICAgICAgICAgICAuLi5zYW1wbGVRdWVyaWVzW2ldLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9O1xuICAgICAgICAgIGNvbnN0IHNhdmVkUXVlcnlSZXMgPSBhd2FpdCB0aGlzLmNsaWVudFxuICAgICAgICAgICAgLmFzU2NvcGVkKHJlcXVlc3QpXG4gICAgICAgICAgICAuY2FsbEFzQ3VycmVudFVzZXIoZm9ybWF0LCBwYXJhbXMpO1xuICAgICAgICAgIHNhdmVkUXVlcnlJZHMucHVzaChzYXZlZFF1ZXJ5UmVzLm9iamVjdElkKTtcbiAgICAgICAgfVxuICAgICAgfVxuXG4gICAgICByZXMuc3VjY2VzcyA9IHRydWU7XG4gICAgICByZXMuZGF0YSA9IHsgc2F2ZWRWaXpJZHMsIHNhdmVkUXVlcnlJZHMgfTtcbiAgICB9IGNhdGNoIChlcnI6IGFueSkge1xuICAgICAgY29uc29sZS5lcnJvcignRXZlbnQgYW5hbHl0aWNzIGNyZWF0ZSBlcnJvcjogJywgZXJyKTtcbiAgICAgIHJlcy5kYXRhID0gZXJyO1xuICAgIH1cbiAgICByZXR1cm4gcmVzO1xuICB9O1xuXG4gIGdldFNhdmVkT2JqZWN0ID0gYXN5bmMgKHJlcXVlc3Q6IGFueSkgPT4ge1xuICAgIGNvbnN0IHBhcmFtcyA9IHt9O1xuICAgIGZvciAoY29uc3QgW3BhcmFtLCB2YWx1ZV0gb2YgcmVxdWVzdC51cmwuc2VhcmNoUGFyYW1zLmVudHJpZXMoKSkge1xuICAgICAgcGFyYW1zW3BhcmFtXSA9IHZhbHVlO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy5mZXRjaChcbiAgICAgIHJlcXVlc3QsXG4gICAgICB7XG4gICAgICAgIC4uLnBhcmFtcyxcbiAgICAgIH0sXG4gICAgICAnb2JzZXJ2YWJpbGl0eS5nZXRPYmplY3QnXG4gICAgKTtcbiAgfTtcblxuICBjcmVhdGVTYXZlZFF1ZXJ5ID0gYXN5bmMgKHJlcXVlc3Q6IGFueSkgPT4ge1xuICAgIHJldHVybiB0aGlzLmNyZWF0ZShyZXF1ZXN0LCAnb2JzZXJ2YWJpbGl0eS5jcmVhdGVPYmplY3QnLCAnc2F2ZWRRdWVyeScpO1xuICB9O1xuXG4gIGNyZWF0ZVNhdmVkVmlzdWFsaXphdGlvbiA9IChyZXF1ZXN0OiBhbnkpID0+IHtcbiAgICByZXR1cm4gdGhpcy5jcmVhdGUocmVxdWVzdCwgJ29ic2VydmFiaWxpdHkuY3JlYXRlT2JqZWN0JywgJ3NhdmVkVmlzdWFsaXphdGlvbicpO1xuICB9O1xuXG4gIGNyZWF0ZVNhdmVkVGltZXN0YW1wID0gKHJlcXVlc3Q6IGFueSkgPT4ge1xuICAgIHJldHVybiB0aGlzLmNyZWF0ZVRpbWVzdGFtcChyZXF1ZXN0LCAnb2JzZXJ2YWJpbGl0eS5jcmVhdGVPYmplY3QnKTtcbiAgfTtcblxuICB1cGRhdGVTYXZlZFRpbWVzdGFtcCA9IChyZXF1ZXN0OiBhbnkpID0+IHtcbiAgICByZXR1cm4gdGhpcy51cGRhdGVUaW1lc3RhbXAocmVxdWVzdCwgJ29ic2VydmFiaWxpdHkudXBkYXRlT2JqZWN0QnlJZCcpO1xuICB9O1xuXG4gIHVwZGF0ZVNhdmVkUXVlcnkgPSAocmVxdWVzdDogYW55KSA9PiB7XG4gICAgcmV0dXJuIHRoaXMudXBkYXRlKHJlcXVlc3QsICdvYnNlcnZhYmlsaXR5LnVwZGF0ZU9iamVjdEJ5SWQnLCAnc2F2ZWRRdWVyeScpO1xuICB9O1xuXG4gIHVwZGF0ZVNhdmVkVmlzdWFsaXphdGlvbiA9IChyZXF1ZXN0OiBhbnkpID0+IHtcbiAgICByZXR1cm4gdGhpcy51cGRhdGUocmVxdWVzdCwgJ29ic2VydmFiaWxpdHkudXBkYXRlT2JqZWN0QnlJZCcsICdzYXZlZFZpc3VhbGl6YXRpb24nKTtcbiAgfTtcblxuICBkZWxldGVTYXZlZE9iamVjdCA9IGFzeW5jIChyZXF1ZXN0OiBhbnkpID0+IHtcbiAgICByZXR1cm4gdGhpcy5kZWxldGUocmVxdWVzdCwgJ29ic2VydmFiaWxpdHkuZGVsZXRlT2JqZWN0QnlJZExpc3QnKTtcbiAgfTtcblxuICBjcmVhdGVTYW1wbGVTYXZlZE9iamVjdHMgPSBhc3luYyAocmVxdWVzdDogYW55KSA9PiB7XG4gICAgcmV0dXJuIHRoaXMuY3JlYXRlU2FtcGxlcyhyZXF1ZXN0LCAnb2JzZXJ2YWJpbGl0eS5jcmVhdGVPYmplY3QnKTtcbiAgfTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBTUEsSUFBQUEsb0JBQUEsR0FBQUMsT0FBQTtBQUdrRSxTQUFBQyxnQkFBQUMsQ0FBQSxFQUFBQyxDQUFBLEVBQUFDLENBQUEsWUFBQUQsQ0FBQSxHQUFBRSxjQUFBLENBQUFGLENBQUEsTUFBQUQsQ0FBQSxHQUFBSSxNQUFBLENBQUFDLGNBQUEsQ0FBQUwsQ0FBQSxFQUFBQyxDQUFBLElBQUFLLEtBQUEsRUFBQUosQ0FBQSxFQUFBSyxVQUFBLE1BQUFDLFlBQUEsTUFBQUMsUUFBQSxVQUFBVCxDQUFBLENBQUFDLENBQUEsSUFBQUMsQ0FBQSxFQUFBRixDQUFBO0FBQUEsU0FBQUcsZUFBQUQsQ0FBQSxRQUFBUSxDQUFBLEdBQUFDLFlBQUEsQ0FBQVQsQ0FBQSx1Q0FBQVEsQ0FBQSxHQUFBQSxDQUFBLEdBQUFBLENBQUE7QUFBQSxTQUFBQyxhQUFBVCxDQUFBLEVBQUFELENBQUEsMkJBQUFDLENBQUEsS0FBQUEsQ0FBQSxTQUFBQSxDQUFBLE1BQUFGLENBQUEsR0FBQUUsQ0FBQSxDQUFBVSxNQUFBLENBQUFDLFdBQUEsa0JBQUFiLENBQUEsUUFBQVUsQ0FBQSxHQUFBVixDQUFBLENBQUFjLElBQUEsQ0FBQVosQ0FBQSxFQUFBRCxDQUFBLHVDQUFBUyxDQUFBLFNBQUFBLENBQUEsWUFBQUssU0FBQSx5RUFBQWQsQ0FBQSxHQUFBZSxNQUFBLEdBQUFDLE1BQUEsRUFBQWYsQ0FBQSxLQVRsRTtBQUNBO0FBQ0E7QUFDQTtBQVFBO0FBQ2UsTUFBTWdCLGdCQUFnQixDQUFDO0VBQ3BDQyxXQUFXQSxDQUFTQyxNQUE0QixFQUFFO0lBQUEsS0FBOUJBLE1BQTRCLEdBQTVCQSxNQUE0QjtJQUFBckIsZUFBQSxnQkFJeEMsT0FBT3NCLE9BQXlCLEVBQUVDLE1BQTJCLEVBQUVDLE1BQWMsS0FBSztNQUN4RixNQUFNQyxHQUFHLEdBQUc7UUFDVkMsT0FBTyxFQUFFLEtBQUs7UUFDZEMsSUFBSSxFQUFFLENBQUM7TUFDVCxDQUFDO01BQ0QsSUFBSTtRQUNGLE1BQU1DLGFBQWEsR0FBRyxNQUFNLElBQUksQ0FBQ1AsTUFBTSxDQUFDUSxRQUFRLENBQUNQLE9BQU8sQ0FBQyxDQUFDUSxpQkFBaUIsQ0FBQ04sTUFBTSxFQUFFRCxNQUFNLENBQUM7UUFDM0ZFLEdBQUcsQ0FBQ0MsT0FBTyxHQUFHLElBQUk7UUFDbEJELEdBQUcsQ0FBQ0UsSUFBSSxHQUFHQyxhQUFhO01BQzFCLENBQUMsQ0FBQyxPQUFPRyxHQUFRLEVBQUU7UUFDakJDLE9BQU8sQ0FBQ0MsS0FBSyxDQUFDLCtCQUErQixFQUFFRixHQUFHLENBQUM7UUFDbkROLEdBQUcsQ0FBQ0UsSUFBSSxHQUFHSSxHQUFHO01BQ2hCO01BQ0EsT0FBT04sR0FBRztJQUNaLENBQUM7SUFBQXpCLGVBQUEsaUJBRVEsT0FBT3NCLE9BQVksRUFBRUUsTUFBYyxFQUFFVSxVQUFrQixLQUFLO01BQ25FLE1BQU1ULEdBQUcsR0FBRztRQUNWQyxPQUFPLEVBQUUsS0FBSztRQUNkQyxJQUFJLEVBQUUsQ0FBQztNQUNULENBQUM7TUFDRCxJQUFJO1FBQ0YsTUFBTUosTUFBTSxHQUFHO1VBQ2JZLElBQUksRUFBRTtZQUNKLENBQUNELFVBQVUsR0FBRztjQUNaLEdBQUdaLE9BQU8sQ0FBQ2EsSUFBSSxDQUFDQztZQUNsQjtVQUNGO1FBQ0YsQ0FBQztRQUNELE1BQU1DLFFBQVEsR0FBRyxNQUFNLElBQUksQ0FBQ2hCLE1BQU0sQ0FBQ1EsUUFBUSxDQUFDUCxPQUFPLENBQUMsQ0FBQ1EsaUJBQWlCLENBQUNOLE1BQU0sRUFBRUQsTUFBTSxDQUFDO1FBQ3RGRSxHQUFHLENBQUNDLE9BQU8sR0FBRyxJQUFJO1FBQ2xCRCxHQUFHLENBQUNFLElBQUksR0FBR1UsUUFBUTtNQUNyQixDQUFDLENBQUMsT0FBT04sR0FBUSxFQUFFO1FBQ2pCQyxPQUFPLENBQUNDLEtBQUssQ0FBQyxnQ0FBZ0MsRUFBRUYsR0FBRyxDQUFDO1FBQ3BETixHQUFHLENBQUNFLElBQUksR0FBR0ksR0FBRztNQUNoQjtNQUNBLE9BQU9OLEdBQUc7SUFDWixDQUFDO0lBQUF6QixlQUFBLDBCQUVpQixPQUFPc0IsT0FBWSxFQUFFRSxNQUFjLEtBQUs7TUFDeEQsTUFBTUMsR0FBRyxHQUFHO1FBQ1ZDLE9BQU8sRUFBRSxLQUFLO1FBQ2RDLElBQUksRUFBRSxDQUFDO01BQ1QsQ0FBQztNQUNELElBQUk7UUFDRixNQUFNSixNQUFNLEdBQUc7VUFDYlksSUFBSSxFQUFFO1lBQ0pHLFFBQVEsRUFBRWhCLE9BQU8sQ0FBQ2EsSUFBSSxDQUFDSSxLQUFLO1lBQzVCQyxTQUFTLEVBQUU7Y0FDVCxHQUFHbEIsT0FBTyxDQUFDYTtZQUNiO1VBQ0Y7UUFDRixDQUFDO1FBQ0QsTUFBTUUsUUFBUSxHQUFHLE1BQU0sSUFBSSxDQUFDaEIsTUFBTSxDQUFDUSxRQUFRLENBQUNQLE9BQU8sQ0FBQyxDQUFDUSxpQkFBaUIsQ0FBQ04sTUFBTSxFQUFFRCxNQUFNLENBQUM7UUFDdEZFLEdBQUcsQ0FBQ0MsT0FBTyxHQUFHLElBQUk7UUFDbEJELEdBQUcsQ0FBQ0UsSUFBSSxHQUFHVSxRQUFRO01BQ3JCLENBQUMsQ0FBQyxPQUFPTixHQUFRLEVBQUU7UUFDakJDLE9BQU8sQ0FBQ0MsS0FBSyxDQUFDLDBDQUEwQyxFQUFFRixHQUFHLENBQUM7UUFDOUROLEdBQUcsQ0FBQ0UsSUFBSSxHQUFHSSxHQUFHO01BQ2hCO01BQ0EsT0FBT04sR0FBRztJQUNaLENBQUM7SUFBQXpCLGVBQUEsMEJBRWlCLE9BQU9zQixPQUFZLEVBQUVFLE1BQWMsS0FBSztNQUN4RCxNQUFNQyxHQUFHLEdBQUc7UUFDVkMsT0FBTyxFQUFFLEtBQUs7UUFDZEMsSUFBSSxFQUFFLENBQUM7TUFDVCxDQUFDO01BQ0QsSUFBSTtRQUNGLE1BQU1KLE1BQU0sR0FBRztVQUNiZSxRQUFRLEVBQUVoQixPQUFPLENBQUNhLElBQUksQ0FBQ0csUUFBUTtVQUMvQkgsSUFBSSxFQUFFO1lBQ0osR0FBR2IsT0FBTyxDQUFDYTtVQUNiO1FBQ0YsQ0FBQztRQUNELE1BQU1QLGFBQWEsR0FBRyxNQUFNLElBQUksQ0FBQ1AsTUFBTSxDQUFDUSxRQUFRLENBQUNQLE9BQU8sQ0FBQyxDQUFDUSxpQkFBaUIsQ0FBQ04sTUFBTSxFQUFFRCxNQUFNLENBQUM7UUFDM0ZFLEdBQUcsQ0FBQ0MsT0FBTyxHQUFHLElBQUk7UUFDbEJELEdBQUcsQ0FBQ0UsSUFBSSxHQUFHQyxhQUFhO01BQzFCLENBQUMsQ0FBQyxPQUFPRyxHQUFRLEVBQUU7UUFDakJDLE9BQU8sQ0FBQ0MsS0FBSyxDQUFDLGdDQUFnQyxFQUFFRixHQUFHLENBQUM7UUFDcEROLEdBQUcsQ0FBQ0UsSUFBSSxHQUFHSSxHQUFHLENBQUNVLE9BQU87TUFDeEI7TUFDQSxPQUFPaEIsR0FBRztJQUNaLENBQUM7SUFBQXpCLGVBQUEsaUJBRVEsT0FBT3NCLE9BQVksRUFBRUUsTUFBYyxFQUFFVSxVQUFrQixLQUFLO01BQ25FLE1BQU1ULEdBQUcsR0FBRztRQUNWQyxPQUFPLEVBQUUsS0FBSztRQUNkQyxJQUFJLEVBQUUsQ0FBQztNQUNULENBQUM7TUFDRCxJQUFJO1FBQ0YsTUFBTUosTUFBTSxHQUFHO1VBQ2JlLFFBQVEsRUFBRWhCLE9BQU8sQ0FBQ2EsSUFBSSxDQUFDTyxTQUFTO1VBQ2hDUCxJQUFJLEVBQUU7WUFDSixDQUFDRCxVQUFVLEdBQUc7Y0FDWixHQUFHWixPQUFPLENBQUNhLElBQUksQ0FBQ0M7WUFDbEI7VUFDRjtRQUNGLENBQUM7UUFDRCxNQUFNUixhQUFhLEdBQUcsTUFBTSxJQUFJLENBQUNQLE1BQU0sQ0FBQ1EsUUFBUSxDQUFDUCxPQUFPLENBQUMsQ0FBQ1EsaUJBQWlCLENBQUNOLE1BQU0sRUFBRUQsTUFBTSxDQUFDO1FBQzNGRSxHQUFHLENBQUNDLE9BQU8sR0FBRyxJQUFJO1FBQ2xCRCxHQUFHLENBQUNFLElBQUksR0FBR0MsYUFBYTtNQUMxQixDQUFDLENBQUMsT0FBT0csR0FBUSxFQUFFO1FBQ2pCQyxPQUFPLENBQUNDLEtBQUssQ0FBQyxnQ0FBZ0MsRUFBRUYsR0FBRyxDQUFDO1FBQ3BETixHQUFHLENBQUNFLElBQUksR0FBR0ksR0FBRyxDQUFDVSxPQUFPO01BQ3hCO01BQ0EsT0FBT2hCLEdBQUc7SUFDWixDQUFDO0lBQUF6QixlQUFBLGlCQUVRLE9BQU9zQixPQUFZLEVBQUVFLE1BQWMsS0FBSztNQUMvQyxNQUFNQyxHQUFHLEdBQUc7UUFDVkMsT0FBTyxFQUFFLEtBQUs7UUFDZEMsSUFBSSxFQUFFLENBQUM7TUFDVCxDQUFDO01BQ0QsSUFBSTtRQUNGLE1BQU1KLE1BQU0sR0FBRztVQUNib0IsWUFBWSxFQUFFckIsT0FBTyxDQUFDQyxNQUFNLENBQUNvQjtRQUMvQixDQUFDO1FBQ0QsTUFBTWYsYUFBYSxHQUFHLE1BQU0sSUFBSSxDQUFDUCxNQUFNLENBQUNRLFFBQVEsQ0FBQ1AsT0FBTyxDQUFDLENBQUNRLGlCQUFpQixDQUFDTixNQUFNLEVBQUVELE1BQU0sQ0FBQztRQUMzRkUsR0FBRyxDQUFDQyxPQUFPLEdBQUcsSUFBSTtRQUNsQkQsR0FBRyxDQUFDRSxJQUFJLEdBQUdDLGFBQWE7TUFDMUIsQ0FBQyxDQUFDLE9BQU9HLEdBQVEsRUFBRTtRQUNqQkMsT0FBTyxDQUFDQyxLQUFLLENBQUMsZ0NBQWdDLEVBQUVGLEdBQUcsQ0FBQztRQUNwRE4sR0FBRyxDQUFDRSxJQUFJLEdBQUdJLEdBQUcsQ0FBQ1UsT0FBTztNQUN4QjtNQUNBLE9BQU9oQixHQUFHO0lBQ1osQ0FBQztJQUFBekIsZUFBQSx3QkFFZSxPQUFPc0IsT0FBWSxFQUFFRSxNQUFjLEtBQUs7TUFDdEQsTUFBTUMsR0FBRyxHQUFHO1FBQ1ZDLE9BQU8sRUFBRSxLQUFLO1FBQ2RDLElBQUksRUFBRSxDQUFDO01BQ1QsQ0FBQztNQUNELElBQUk7UUFDRixNQUFNaUIsV0FBa0IsR0FBRyxFQUFFO1FBQzdCLE1BQU1DLGFBQW9CLEdBQUcsRUFBRTtRQUUvQixJQUFJLENBQUMsUUFBUSxFQUFFLGlCQUFpQixDQUFDLENBQUNDLFFBQVEsQ0FBQ3hCLE9BQU8sQ0FBQ0MsTUFBTSxDQUFDd0IsZUFBZSxDQUFDLEVBQUU7VUFDMUUsS0FBSyxJQUFJcEMsQ0FBQyxHQUFHLENBQUMsRUFBRUEsQ0FBQyxHQUFHcUMseUNBQW9CLENBQUNDLE1BQU0sRUFBRXRDLENBQUMsRUFBRSxFQUFFO1lBQ3BELE1BQU1ZLE1BQU0sR0FBRztjQUNiWSxJQUFJLEVBQUU7Z0JBQ0plLGtCQUFrQixFQUFFO2tCQUNsQixHQUFHRix5Q0FBb0IsQ0FBQ3JDLENBQUM7Z0JBQzNCO2NBQ0Y7WUFDRixDQUFDO1lBQ0QsTUFBTXdDLFdBQVcsR0FBRyxNQUFNLElBQUksQ0FBQzlCLE1BQU0sQ0FBQ1EsUUFBUSxDQUFDUCxPQUFPLENBQUMsQ0FBQ1EsaUJBQWlCLENBQUNOLE1BQU0sRUFBRUQsTUFBTSxDQUFDO1lBQ3pGcUIsV0FBVyxDQUFDUSxJQUFJLENBQUNELFdBQVcsQ0FBQ2IsUUFBUSxDQUFDO1VBQ3hDO1VBRUEsS0FBSyxJQUFJM0IsQ0FBQyxHQUFHLENBQUMsRUFBRUEsQ0FBQyxHQUFHMEMsa0NBQWEsQ0FBQ0osTUFBTSxFQUFFdEMsQ0FBQyxFQUFFLEVBQUU7WUFDN0MsTUFBTVksTUFBTSxHQUFHO2NBQ2JZLElBQUksRUFBRTtnQkFDSm1CLFVBQVUsRUFBRTtrQkFDVixHQUFHRCxrQ0FBYSxDQUFDMUMsQ0FBQztnQkFDcEI7Y0FDRjtZQUNGLENBQUM7WUFDRCxNQUFNaUIsYUFBYSxHQUFHLE1BQU0sSUFBSSxDQUFDUCxNQUFNLENBQ3BDUSxRQUFRLENBQUNQLE9BQU8sQ0FBQyxDQUNqQlEsaUJBQWlCLENBQUNOLE1BQU0sRUFBRUQsTUFBTSxDQUFDO1lBQ3BDc0IsYUFBYSxDQUFDTyxJQUFJLENBQUN4QixhQUFhLENBQUNVLFFBQVEsQ0FBQztVQUM1QztRQUNGO1FBRUFiLEdBQUcsQ0FBQ0MsT0FBTyxHQUFHLElBQUk7UUFDbEJELEdBQUcsQ0FBQ0UsSUFBSSxHQUFHO1VBQUVpQixXQUFXO1VBQUVDO1FBQWMsQ0FBQztNQUMzQyxDQUFDLENBQUMsT0FBT2QsR0FBUSxFQUFFO1FBQ2pCQyxPQUFPLENBQUNDLEtBQUssQ0FBQyxnQ0FBZ0MsRUFBRUYsR0FBRyxDQUFDO1FBQ3BETixHQUFHLENBQUNFLElBQUksR0FBR0ksR0FBRztNQUNoQjtNQUNBLE9BQU9OLEdBQUc7SUFDWixDQUFDO0lBQUF6QixlQUFBLHlCQUVnQixNQUFPc0IsT0FBWSxJQUFLO01BQ3ZDLE1BQU1DLE1BQU0sR0FBRyxDQUFDLENBQUM7TUFDakIsS0FBSyxNQUFNLENBQUNnQyxLQUFLLEVBQUVoRCxLQUFLLENBQUMsSUFBSWUsT0FBTyxDQUFDa0MsR0FBRyxDQUFDQyxZQUFZLENBQUNDLE9BQU8sQ0FBQyxDQUFDLEVBQUU7UUFDL0RuQyxNQUFNLENBQUNnQyxLQUFLLENBQUMsR0FBR2hELEtBQUs7TUFDdkI7TUFDQSxPQUFPLElBQUksQ0FBQ29ELEtBQUssQ0FDZnJDLE9BQU8sRUFDUDtRQUNFLEdBQUdDO01BQ0wsQ0FBQyxFQUNELHlCQUNGLENBQUM7SUFDSCxDQUFDO0lBQUF2QixlQUFBLDJCQUVrQixNQUFPc0IsT0FBWSxJQUFLO01BQ3pDLE9BQU8sSUFBSSxDQUFDc0MsTUFBTSxDQUFDdEMsT0FBTyxFQUFFLDRCQUE0QixFQUFFLFlBQVksQ0FBQztJQUN6RSxDQUFDO0lBQUF0QixlQUFBLG1DQUUyQnNCLE9BQVksSUFBSztNQUMzQyxPQUFPLElBQUksQ0FBQ3NDLE1BQU0sQ0FBQ3RDLE9BQU8sRUFBRSw0QkFBNEIsRUFBRSxvQkFBb0IsQ0FBQztJQUNqRixDQUFDO0lBQUF0QixlQUFBLCtCQUV1QnNCLE9BQVksSUFBSztNQUN2QyxPQUFPLElBQUksQ0FBQ3VDLGVBQWUsQ0FBQ3ZDLE9BQU8sRUFBRSw0QkFBNEIsQ0FBQztJQUNwRSxDQUFDO0lBQUF0QixlQUFBLCtCQUV1QnNCLE9BQVksSUFBSztNQUN2QyxPQUFPLElBQUksQ0FBQ3dDLGVBQWUsQ0FBQ3hDLE9BQU8sRUFBRSxnQ0FBZ0MsQ0FBQztJQUN4RSxDQUFDO0lBQUF0QixlQUFBLDJCQUVtQnNCLE9BQVksSUFBSztNQUNuQyxPQUFPLElBQUksQ0FBQ3lDLE1BQU0sQ0FBQ3pDLE9BQU8sRUFBRSxnQ0FBZ0MsRUFBRSxZQUFZLENBQUM7SUFDN0UsQ0FBQztJQUFBdEIsZUFBQSxtQ0FFMkJzQixPQUFZLElBQUs7TUFDM0MsT0FBTyxJQUFJLENBQUN5QyxNQUFNLENBQUN6QyxPQUFPLEVBQUUsZ0NBQWdDLEVBQUUsb0JBQW9CLENBQUM7SUFDckYsQ0FBQztJQUFBdEIsZUFBQSw0QkFFbUIsTUFBT3NCLE9BQVksSUFBSztNQUMxQyxPQUFPLElBQUksQ0FBQzBDLE1BQU0sQ0FBQzFDLE9BQU8sRUFBRSxvQ0FBb0MsQ0FBQztJQUNuRSxDQUFDO0lBQUF0QixlQUFBLG1DQUUwQixNQUFPc0IsT0FBWSxJQUFLO01BQ2pELE9BQU8sSUFBSSxDQUFDMkMsYUFBYSxDQUFDM0MsT0FBTyxFQUFFLDRCQUE0QixDQUFDO0lBQ2xFLENBQUM7SUE3TkMsSUFBSSxDQUFDRCxNQUFNLEdBQUdBLE1BQU07RUFDdEI7QUE2TkY7QUFBQzZDLE9BQUEsQ0FBQUMsT0FBQSxHQUFBaEQsZ0JBQUE7QUFBQWlELE1BQUEsQ0FBQUYsT0FBQSxHQUFBQSxPQUFBLENBQUFDLE9BQUEifQ==