/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateTrunkInterfaceRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssociateTrunkInterfaceRequest> {
    private static final SdkField<String> BRANCH_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BranchInterfaceId").getter(AssociateTrunkInterfaceRequest.getter(AssociateTrunkInterfaceRequest::branchInterfaceId)).setter(AssociateTrunkInterfaceRequest.setter(Builder::branchInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchInterfaceId").unmarshallLocationName("BranchInterfaceId").build()}).build();
    private static final SdkField<String> TRUNK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrunkInterfaceId").getter(AssociateTrunkInterfaceRequest.getter(AssociateTrunkInterfaceRequest::trunkInterfaceId)).setter(AssociateTrunkInterfaceRequest.setter(Builder::trunkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrunkInterfaceId").unmarshallLocationName("TrunkInterfaceId").build()}).build();
    private static final SdkField<Integer> VLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VlanId").getter(AssociateTrunkInterfaceRequest.getter(AssociateTrunkInterfaceRequest::vlanId)).setter(AssociateTrunkInterfaceRequest.setter(Builder::vlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VlanId").unmarshallLocationName("VlanId").build()}).build();
    private static final SdkField<Integer> GRE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GreKey").getter(AssociateTrunkInterfaceRequest.getter(AssociateTrunkInterfaceRequest::greKey)).setter(AssociateTrunkInterfaceRequest.setter(Builder::greKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GreKey").unmarshallLocationName("GreKey").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AssociateTrunkInterfaceRequest.getter(AssociateTrunkInterfaceRequest::clientToken)).setter(AssociateTrunkInterfaceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_INTERFACE_ID_FIELD, TRUNK_INTERFACE_ID_FIELD, VLAN_ID_FIELD, GRE_KEY_FIELD, CLIENT_TOKEN_FIELD));
    private final String branchInterfaceId;
    private final String trunkInterfaceId;
    private final Integer vlanId;
    private final Integer greKey;
    private final String clientToken;

    private AssociateTrunkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.branchInterfaceId = builder.branchInterfaceId;
        this.trunkInterfaceId = builder.trunkInterfaceId;
        this.vlanId = builder.vlanId;
        this.greKey = builder.greKey;
        this.clientToken = builder.clientToken;
    }

    public final String branchInterfaceId() {
        return this.branchInterfaceId;
    }

    public final String trunkInterfaceId() {
        return this.trunkInterfaceId;
    }

    public final Integer vlanId() {
        return this.vlanId;
    }

    public final Integer greKey() {
        return this.greKey;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.branchInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trunkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.greKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTrunkInterfaceRequest)) {
            return false;
        }
        AssociateTrunkInterfaceRequest other = (AssociateTrunkInterfaceRequest)((Object)obj);
        return Objects.equals(this.branchInterfaceId(), other.branchInterfaceId()) && Objects.equals(this.trunkInterfaceId(), other.trunkInterfaceId()) && Objects.equals(this.vlanId(), other.vlanId()) && Objects.equals(this.greKey(), other.greKey()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateTrunkInterfaceRequest").add("BranchInterfaceId", (Object)this.branchInterfaceId()).add("TrunkInterfaceId", (Object)this.trunkInterfaceId()).add("VlanId", (Object)this.vlanId()).add("GreKey", (Object)this.greKey()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BranchInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.branchInterfaceId()));
            }
            case "TrunkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.trunkInterfaceId()));
            }
            case "VlanId": {
                return Optional.ofNullable(clazz.cast(this.vlanId()));
            }
            case "GreKey": {
                return Optional.ofNullable(clazz.cast(this.greKey()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTrunkInterfaceRequest, T> g) {
        return obj -> g.apply((AssociateTrunkInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String branchInterfaceId;
        private String trunkInterfaceId;
        private Integer vlanId;
        private Integer greKey;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTrunkInterfaceRequest model) {
            super(model);
            this.branchInterfaceId(model.branchInterfaceId);
            this.trunkInterfaceId(model.trunkInterfaceId);
            this.vlanId(model.vlanId);
            this.greKey(model.greKey);
            this.clientToken(model.clientToken);
        }

        public final String getBranchInterfaceId() {
            return this.branchInterfaceId;
        }

        public final void setBranchInterfaceId(String branchInterfaceId) {
            this.branchInterfaceId = branchInterfaceId;
        }

        @Override
        public final Builder branchInterfaceId(String branchInterfaceId) {
            this.branchInterfaceId = branchInterfaceId;
            return this;
        }

        public final String getTrunkInterfaceId() {
            return this.trunkInterfaceId;
        }

        public final void setTrunkInterfaceId(String trunkInterfaceId) {
            this.trunkInterfaceId = trunkInterfaceId;
        }

        @Override
        public final Builder trunkInterfaceId(String trunkInterfaceId) {
            this.trunkInterfaceId = trunkInterfaceId;
            return this;
        }

        public final Integer getVlanId() {
            return this.vlanId;
        }

        public final void setVlanId(Integer vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public final Builder vlanId(Integer vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public final Integer getGreKey() {
            return this.greKey;
        }

        public final void setGreKey(Integer greKey) {
            this.greKey = greKey;
        }

        @Override
        public final Builder greKey(Integer greKey) {
            this.greKey = greKey;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateTrunkInterfaceRequest build() {
            return new AssociateTrunkInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateTrunkInterfaceRequest> {
        public Builder branchInterfaceId(String var1);

        public Builder trunkInterfaceId(String var1);

        public Builder vlanId(Integer var1);

        public Builder greKey(Integer var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

