/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConnectionNotificationState;
import software.amazon.awssdk.services.ec2.model.ConnectionNotificationType;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionNotification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionNotification> {
    private static final SdkField<String> CONNECTION_NOTIFICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionNotificationId").getter(ConnectionNotification.getter(ConnectionNotification::connectionNotificationId)).setter(ConnectionNotification.setter(Builder::connectionNotificationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationId").unmarshallLocationName("connectionNotificationId").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(ConnectionNotification.getter(ConnectionNotification::serviceId)).setter(ConnectionNotification.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("serviceId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(ConnectionNotification.getter(ConnectionNotification::vpcEndpointId)).setter(ConnectionNotification.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("vpcEndpointId").build()}).build();
    private static final SdkField<String> CONNECTION_NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionNotificationType").getter(ConnectionNotification.getter(ConnectionNotification::connectionNotificationTypeAsString)).setter(ConnectionNotification.setter(Builder::connectionNotificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationType").unmarshallLocationName("connectionNotificationType").build()}).build();
    private static final SdkField<String> CONNECTION_NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionNotificationArn").getter(ConnectionNotification.getter(ConnectionNotification::connectionNotificationArn)).setter(ConnectionNotification.setter(Builder::connectionNotificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationArn").unmarshallLocationName("connectionNotificationArn").build()}).build();
    private static final SdkField<List<String>> CONNECTION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionEvents").getter(ConnectionNotification.getter(ConnectionNotification::connectionEvents)).setter(ConnectionNotification.setter(Builder::connectionEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEvents").unmarshallLocationName("connectionEvents").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_NOTIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionNotificationState").getter(ConnectionNotification.getter(ConnectionNotification::connectionNotificationStateAsString)).setter(ConnectionNotification.setter(Builder::connectionNotificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationState").unmarshallLocationName("connectionNotificationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NOTIFICATION_ID_FIELD, SERVICE_ID_FIELD, VPC_ENDPOINT_ID_FIELD, CONNECTION_NOTIFICATION_TYPE_FIELD, CONNECTION_NOTIFICATION_ARN_FIELD, CONNECTION_EVENTS_FIELD, CONNECTION_NOTIFICATION_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectionNotificationId;
    private final String serviceId;
    private final String vpcEndpointId;
    private final String connectionNotificationType;
    private final String connectionNotificationArn;
    private final List<String> connectionEvents;
    private final String connectionNotificationState;

    private ConnectionNotification(BuilderImpl builder) {
        this.connectionNotificationId = builder.connectionNotificationId;
        this.serviceId = builder.serviceId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.connectionNotificationType = builder.connectionNotificationType;
        this.connectionNotificationArn = builder.connectionNotificationArn;
        this.connectionEvents = builder.connectionEvents;
        this.connectionNotificationState = builder.connectionNotificationState;
    }

    public final String connectionNotificationId() {
        return this.connectionNotificationId;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final ConnectionNotificationType connectionNotificationType() {
        return ConnectionNotificationType.fromValue(this.connectionNotificationType);
    }

    public final String connectionNotificationTypeAsString() {
        return this.connectionNotificationType;
    }

    public final String connectionNotificationArn() {
        return this.connectionNotificationArn;
    }

    public final boolean hasConnectionEvents() {
        return this.connectionEvents != null && !(this.connectionEvents instanceof SdkAutoConstructList);
    }

    public final List<String> connectionEvents() {
        return this.connectionEvents;
    }

    public final ConnectionNotificationState connectionNotificationState() {
        return ConnectionNotificationState.fromValue(this.connectionNotificationState);
    }

    public final String connectionNotificationStateAsString() {
        return this.connectionNotificationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionEvents() ? this.connectionEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionNotification)) {
            return false;
        }
        ConnectionNotification other = (ConnectionNotification)obj;
        return Objects.equals(this.connectionNotificationId(), other.connectionNotificationId()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.connectionNotificationTypeAsString(), other.connectionNotificationTypeAsString()) && Objects.equals(this.connectionNotificationArn(), other.connectionNotificationArn()) && this.hasConnectionEvents() == other.hasConnectionEvents() && Objects.equals(this.connectionEvents(), other.connectionEvents()) && Objects.equals(this.connectionNotificationStateAsString(), other.connectionNotificationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionNotification").add("ConnectionNotificationId", (Object)this.connectionNotificationId()).add("ServiceId", (Object)this.serviceId()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("ConnectionNotificationType", (Object)this.connectionNotificationTypeAsString()).add("ConnectionNotificationArn", (Object)this.connectionNotificationArn()).add("ConnectionEvents", this.hasConnectionEvents() ? this.connectionEvents() : null).add("ConnectionNotificationState", (Object)this.connectionNotificationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionNotificationId": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationId()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "ConnectionNotificationType": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationTypeAsString()));
            }
            case "ConnectionNotificationArn": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationArn()));
            }
            case "ConnectionEvents": {
                return Optional.ofNullable(clazz.cast(this.connectionEvents()));
            }
            case "ConnectionNotificationState": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionNotification, T> g) {
        return obj -> g.apply((ConnectionNotification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionNotificationId;
        private String serviceId;
        private String vpcEndpointId;
        private String connectionNotificationType;
        private String connectionNotificationArn;
        private List<String> connectionEvents = DefaultSdkAutoConstructList.getInstance();
        private String connectionNotificationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionNotification model) {
            this.connectionNotificationId(model.connectionNotificationId);
            this.serviceId(model.serviceId);
            this.vpcEndpointId(model.vpcEndpointId);
            this.connectionNotificationType(model.connectionNotificationType);
            this.connectionNotificationArn(model.connectionNotificationArn);
            this.connectionEvents(model.connectionEvents);
            this.connectionNotificationState(model.connectionNotificationState);
        }

        public final String getConnectionNotificationId() {
            return this.connectionNotificationId;
        }

        public final void setConnectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
        }

        @Override
        public final Builder connectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getConnectionNotificationType() {
            return this.connectionNotificationType;
        }

        public final void setConnectionNotificationType(String connectionNotificationType) {
            this.connectionNotificationType = connectionNotificationType;
        }

        @Override
        public final Builder connectionNotificationType(String connectionNotificationType) {
            this.connectionNotificationType = connectionNotificationType;
            return this;
        }

        @Override
        public final Builder connectionNotificationType(ConnectionNotificationType connectionNotificationType) {
            this.connectionNotificationType(connectionNotificationType == null ? null : connectionNotificationType.toString());
            return this;
        }

        public final String getConnectionNotificationArn() {
            return this.connectionNotificationArn;
        }

        public final void setConnectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
        }

        @Override
        public final Builder connectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
            return this;
        }

        public final Collection<String> getConnectionEvents() {
            if (this.connectionEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectionEvents;
        }

        public final void setConnectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
        }

        @Override
        public final Builder connectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionEvents(String ... connectionEvents) {
            this.connectionEvents(Arrays.asList(connectionEvents));
            return this;
        }

        public final String getConnectionNotificationState() {
            return this.connectionNotificationState;
        }

        public final void setConnectionNotificationState(String connectionNotificationState) {
            this.connectionNotificationState = connectionNotificationState;
        }

        @Override
        public final Builder connectionNotificationState(String connectionNotificationState) {
            this.connectionNotificationState = connectionNotificationState;
            return this;
        }

        @Override
        public final Builder connectionNotificationState(ConnectionNotificationState connectionNotificationState) {
            this.connectionNotificationState(connectionNotificationState == null ? null : connectionNotificationState.toString());
            return this;
        }

        public ConnectionNotification build() {
            return new ConnectionNotification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionNotification> {
        public Builder connectionNotificationId(String var1);

        public Builder serviceId(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder connectionNotificationType(String var1);

        public Builder connectionNotificationType(ConnectionNotificationType var1);

        public Builder connectionNotificationArn(String var1);

        public Builder connectionEvents(Collection<String> var1);

        public Builder connectionEvents(String ... var1);

        public Builder connectionNotificationState(String var1);

        public Builder connectionNotificationState(ConnectionNotificationState var1);
    }
}

