/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState;
import software.amazon.awssdk.services.ec2.model.FleetCapacityReservation;
import software.amazon.awssdk.services.ec2.model.FleetCapacityReservationSetCopier;
import software.amazon.awssdk.services.ec2.model.FleetCapacityReservationTenancy;
import software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservationFleet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservationFleet> {
    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationFleetId").getter(CapacityReservationFleet.getter(CapacityReservationFleet::capacityReservationFleetId)).setter(CapacityReservationFleet.setter(Builder::capacityReservationFleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetId").unmarshallLocationName("capacityReservationFleetId").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationFleetArn").getter(CapacityReservationFleet.getter(CapacityReservationFleet::capacityReservationFleetArn)).setter(CapacityReservationFleet.setter(Builder::capacityReservationFleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetArn").unmarshallLocationName("capacityReservationFleetArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CapacityReservationFleet.getter(CapacityReservationFleet::stateAsString)).setter(CapacityReservationFleet.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Integer> TOTAL_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalTargetCapacity").getter(CapacityReservationFleet.getter(CapacityReservationFleet::totalTargetCapacity)).setter(CapacityReservationFleet.setter(Builder::totalTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTargetCapacity").unmarshallLocationName("totalTargetCapacity").build()}).build();
    private static final SdkField<Double> TOTAL_FULFILLED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalFulfilledCapacity").getter(CapacityReservationFleet.getter(CapacityReservationFleet::totalFulfilledCapacity)).setter(CapacityReservationFleet.setter(Builder::totalFulfilledCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFulfilledCapacity").unmarshallLocationName("totalFulfilledCapacity").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(CapacityReservationFleet.getter(CapacityReservationFleet::tenancyAsString)).setter(CapacityReservationFleet.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(CapacityReservationFleet.getter(CapacityReservationFleet::endDate)).setter(CapacityReservationFleet.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("endDate").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CapacityReservationFleet.getter(CapacityReservationFleet::createTime)).setter(CapacityReservationFleet.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMatchCriteria").getter(CapacityReservationFleet.getter(CapacityReservationFleet::instanceMatchCriteriaAsString)).setter(CapacityReservationFleet.setter(Builder::instanceMatchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria").unmarshallLocationName("instanceMatchCriteria").build()}).build();
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(CapacityReservationFleet.getter(CapacityReservationFleet::allocationStrategy)).setter(CapacityReservationFleet.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").unmarshallLocationName("allocationStrategy").build()}).build();
    private static final SdkField<List<FleetCapacityReservation>> INSTANCE_TYPE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypeSpecifications").getter(CapacityReservationFleet.getter(CapacityReservationFleet::instanceTypeSpecifications)).setter(CapacityReservationFleet.setter(Builder::instanceTypeSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeSpecificationSet").unmarshallLocationName("instanceTypeSpecificationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetCapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CapacityReservationFleet.getter(CapacityReservationFleet::tags)).setter(CapacityReservationFleet.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_FLEET_ID_FIELD, CAPACITY_RESERVATION_FLEET_ARN_FIELD, STATE_FIELD, TOTAL_TARGET_CAPACITY_FIELD, TOTAL_FULFILLED_CAPACITY_FIELD, TENANCY_FIELD, END_DATE_FIELD, CREATE_TIME_FIELD, INSTANCE_MATCH_CRITERIA_FIELD, ALLOCATION_STRATEGY_FIELD, INSTANCE_TYPE_SPECIFICATIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityReservationFleet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityReservationFleetId;
    private final String capacityReservationFleetArn;
    private final String state;
    private final Integer totalTargetCapacity;
    private final Double totalFulfilledCapacity;
    private final String tenancy;
    private final Instant endDate;
    private final Instant createTime;
    private final String instanceMatchCriteria;
    private final String allocationStrategy;
    private final List<FleetCapacityReservation> instanceTypeSpecifications;
    private final List<Tag> tags;

    private CapacityReservationFleet(BuilderImpl builder) {
        this.capacityReservationFleetId = builder.capacityReservationFleetId;
        this.capacityReservationFleetArn = builder.capacityReservationFleetArn;
        this.state = builder.state;
        this.totalTargetCapacity = builder.totalTargetCapacity;
        this.totalFulfilledCapacity = builder.totalFulfilledCapacity;
        this.tenancy = builder.tenancy;
        this.endDate = builder.endDate;
        this.createTime = builder.createTime;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
        this.allocationStrategy = builder.allocationStrategy;
        this.instanceTypeSpecifications = builder.instanceTypeSpecifications;
        this.tags = builder.tags;
    }

    public final String capacityReservationFleetId() {
        return this.capacityReservationFleetId;
    }

    public final String capacityReservationFleetArn() {
        return this.capacityReservationFleetArn;
    }

    public final CapacityReservationFleetState state() {
        return CapacityReservationFleetState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer totalTargetCapacity() {
        return this.totalTargetCapacity;
    }

    public final Double totalFulfilledCapacity() {
        return this.totalFulfilledCapacity;
    }

    public final FleetCapacityReservationTenancy tenancy() {
        return FleetCapacityReservationTenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final FleetInstanceMatchCriteria instanceMatchCriteria() {
        return FleetInstanceMatchCriteria.fromValue(this.instanceMatchCriteria);
    }

    public final String instanceMatchCriteriaAsString() {
        return this.instanceMatchCriteria;
    }

    public final String allocationStrategy() {
        return this.allocationStrategy;
    }

    public final boolean hasInstanceTypeSpecifications() {
        return this.instanceTypeSpecifications != null && !(this.instanceTypeSpecifications instanceof SdkAutoConstructList);
    }

    public final List<FleetCapacityReservation> instanceTypeSpecifications() {
        return this.instanceTypeSpecifications;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationFleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMatchCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypeSpecifications() ? this.instanceTypeSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationFleet)) {
            return false;
        }
        CapacityReservationFleet other = (CapacityReservationFleet)obj;
        return Objects.equals(this.capacityReservationFleetId(), other.capacityReservationFleetId()) && Objects.equals(this.capacityReservationFleetArn(), other.capacityReservationFleetArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.totalTargetCapacity(), other.totalTargetCapacity()) && Objects.equals(this.totalFulfilledCapacity(), other.totalFulfilledCapacity()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString()) && Objects.equals(this.allocationStrategy(), other.allocationStrategy()) && this.hasInstanceTypeSpecifications() == other.hasInstanceTypeSpecifications() && Objects.equals(this.instanceTypeSpecifications(), other.instanceTypeSpecifications()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservationFleet").add("CapacityReservationFleetId", (Object)this.capacityReservationFleetId()).add("CapacityReservationFleetArn", (Object)this.capacityReservationFleetArn()).add("State", (Object)this.stateAsString()).add("TotalTargetCapacity", (Object)this.totalTargetCapacity()).add("TotalFulfilledCapacity", (Object)this.totalFulfilledCapacity()).add("Tenancy", (Object)this.tenancyAsString()).add("EndDate", (Object)this.endDate()).add("CreateTime", (Object)this.createTime()).add("InstanceMatchCriteria", (Object)this.instanceMatchCriteriaAsString()).add("AllocationStrategy", (Object)this.allocationStrategy()).add("InstanceTypeSpecifications", this.hasInstanceTypeSpecifications() ? this.instanceTypeSpecifications() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationFleetId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationFleetId()));
            }
            case "CapacityReservationFleetArn": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationFleetArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "TotalTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalTargetCapacity()));
            }
            case "TotalFulfilledCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalFulfilledCapacity()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "InstanceMatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.instanceMatchCriteriaAsString()));
            }
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategy()));
            }
            case "InstanceTypeSpecifications": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeSpecifications()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservationFleetId", CAPACITY_RESERVATION_FLEET_ID_FIELD);
        map.put("CapacityReservationFleetArn", CAPACITY_RESERVATION_FLEET_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("TotalTargetCapacity", TOTAL_TARGET_CAPACITY_FIELD);
        map.put("TotalFulfilledCapacity", TOTAL_FULFILLED_CAPACITY_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("InstanceMatchCriteria", INSTANCE_MATCH_CRITERIA_FIELD);
        map.put("AllocationStrategy", ALLOCATION_STRATEGY_FIELD);
        map.put("InstanceTypeSpecificationSet", INSTANCE_TYPE_SPECIFICATIONS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationFleet, T> g) {
        return obj -> g.apply((CapacityReservationFleet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationFleetId;
        private String capacityReservationFleetArn;
        private String state;
        private Integer totalTargetCapacity;
        private Double totalFulfilledCapacity;
        private String tenancy;
        private Instant endDate;
        private Instant createTime;
        private String instanceMatchCriteria;
        private String allocationStrategy;
        private List<FleetCapacityReservation> instanceTypeSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationFleet model) {
            this.capacityReservationFleetId(model.capacityReservationFleetId);
            this.capacityReservationFleetArn(model.capacityReservationFleetArn);
            this.state(model.state);
            this.totalTargetCapacity(model.totalTargetCapacity);
            this.totalFulfilledCapacity(model.totalFulfilledCapacity);
            this.tenancy(model.tenancy);
            this.endDate(model.endDate);
            this.createTime(model.createTime);
            this.instanceMatchCriteria(model.instanceMatchCriteria);
            this.allocationStrategy(model.allocationStrategy);
            this.instanceTypeSpecifications(model.instanceTypeSpecifications);
            this.tags(model.tags);
        }

        public final String getCapacityReservationFleetId() {
            return this.capacityReservationFleetId;
        }

        public final void setCapacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
        }

        @Override
        public final Builder capacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
            return this;
        }

        public final String getCapacityReservationFleetArn() {
            return this.capacityReservationFleetArn;
        }

        public final void setCapacityReservationFleetArn(String capacityReservationFleetArn) {
            this.capacityReservationFleetArn = capacityReservationFleetArn;
        }

        @Override
        public final Builder capacityReservationFleetArn(String capacityReservationFleetArn) {
            this.capacityReservationFleetArn = capacityReservationFleetArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityReservationFleetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getTotalTargetCapacity() {
            return this.totalTargetCapacity;
        }

        public final void setTotalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
        }

        @Override
        public final Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        public final Double getTotalFulfilledCapacity() {
            return this.totalFulfilledCapacity;
        }

        public final void setTotalFulfilledCapacity(Double totalFulfilledCapacity) {
            this.totalFulfilledCapacity = totalFulfilledCapacity;
        }

        @Override
        public final Builder totalFulfilledCapacity(Double totalFulfilledCapacity) {
            this.totalFulfilledCapacity = totalFulfilledCapacity;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(FleetCapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getInstanceMatchCriteria() {
            return this.instanceMatchCriteria;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(FleetInstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        public final List<FleetCapacityReservation.Builder> getInstanceTypeSpecifications() {
            List<FleetCapacityReservation.Builder> result = FleetCapacityReservationSetCopier.copyToBuilder(this.instanceTypeSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypeSpecifications(Collection<FleetCapacityReservation.BuilderImpl> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = FleetCapacityReservationSetCopier.copyFromBuilder(instanceTypeSpecifications);
        }

        @Override
        public final Builder instanceTypeSpecifications(Collection<FleetCapacityReservation> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = FleetCapacityReservationSetCopier.copy(instanceTypeSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(FleetCapacityReservation ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Arrays.asList(instanceTypeSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(Consumer<FleetCapacityReservation.Builder> ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Stream.of(instanceTypeSpecifications).map(c -> (FleetCapacityReservation)((FleetCapacityReservation.Builder)FleetCapacityReservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapacityReservationFleet build() {
            return new CapacityReservationFleet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservationFleet> {
        public Builder capacityReservationFleetId(String var1);

        public Builder capacityReservationFleetArn(String var1);

        public Builder state(String var1);

        public Builder state(CapacityReservationFleetState var1);

        public Builder totalTargetCapacity(Integer var1);

        public Builder totalFulfilledCapacity(Double var1);

        public Builder tenancy(String var1);

        public Builder tenancy(FleetCapacityReservationTenancy var1);

        public Builder endDate(Instant var1);

        public Builder createTime(Instant var1);

        public Builder instanceMatchCriteria(String var1);

        public Builder instanceMatchCriteria(FleetInstanceMatchCriteria var1);

        public Builder allocationStrategy(String var1);

        public Builder instanceTypeSpecifications(Collection<FleetCapacityReservation> var1);

        public Builder instanceTypeSpecifications(FleetCapacityReservation ... var1);

        public Builder instanceTypeSpecifications(Consumer<FleetCapacityReservation.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

