/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import java.util.Comparator;
import lombok.Generated;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;

class HybridQueryFieldDocComparator
implements Comparator<FieldDoc> {
    final SortField[] sortFields;
    final FieldComparator<?>[] comparators;
    final int[] reverseMul;
    final Comparator<ScoreDoc> tieBreaker;

    public HybridQueryFieldDocComparator(SortField[] sortFields, Comparator<ScoreDoc> tieBreaker) {
        this.sortFields = sortFields;
        this.tieBreaker = tieBreaker;
        this.comparators = new FieldComparator[sortFields.length];
        this.reverseMul = new int[sortFields.length];
        for (int compIDX = 0; compIDX < sortFields.length; ++compIDX) {
            SortField sortField = sortFields[compIDX];
            this.comparators[compIDX] = sortField.getComparator(1, Pruning.NONE);
            this.reverseMul[compIDX] = sortField.getReverse() ? -1 : 1;
        }
    }

    @Override
    public int compare(FieldDoc firstFD, FieldDoc secondFD) {
        for (int compIDX = 0; compIDX < this.comparators.length; ++compIDX) {
            FieldComparator<?> comp = this.comparators[compIDX];
            int cmp = this.reverseMul[compIDX] * comp.compareValues(firstFD.fields[compIDX], secondFD.fields[compIDX]);
            if (cmp == 0) continue;
            return cmp;
        }
        return this.tieBreakCompare((ScoreDoc)firstFD, (ScoreDoc)secondFD, this.tieBreaker);
    }

    private int tieBreakCompare(ScoreDoc firstDoc, ScoreDoc secondDoc, Comparator<ScoreDoc> tieBreaker) {
        assert (tieBreaker != null);
        int value = tieBreaker.compare(firstDoc, secondDoc);
        return value;
    }

    @Generated
    HybridQueryFieldDocComparator(SortField[] sortFields, FieldComparator<?>[] comparators, int[] reverseMul, Comparator<ScoreDoc> tieBreaker) {
        this.sortFields = sortFields;
        this.comparators = comparators;
        this.reverseMul = reverseMul;
        this.tieBreaker = tieBreaker;
    }
}

