/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.util;

import java.util.List;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.opensearch.neuralsearch.processor.CompoundTopDocs;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.sort.SortedWiderNumericSortField;

public class HybridSearchSortUtil {
    public static Sort evaluateSortCriteria(List<QuerySearchResult> querySearchResults, List<CompoundTopDocs> queryTopDocs) {
        if (!HybridSearchSortUtil.checkIfSortEnabled(querySearchResults)) {
            return null;
        }
        return HybridSearchSortUtil.createSort(HybridSearchSortUtil.getTopFieldDocs(queryTopDocs));
    }

    private static boolean checkIfSortEnabled(List<QuerySearchResult> querySearchResults) {
        if (querySearchResults == null || querySearchResults.isEmpty() || querySearchResults.get(0) == null) {
            throw new IllegalArgumentException("shard results cannot be null in the normalization process.");
        }
        return querySearchResults.get(0).sortValueFormats() != null;
    }

    private static TopFieldDocs[] getTopFieldDocs(List<CompoundTopDocs> queryTopDocs) {
        for (CompoundTopDocs compoundTopDocs : queryTopDocs) {
            if (compoundTopDocs == null) {
                throw new IllegalArgumentException("CompoundTopDocs cannot be null in the normalization process");
            }
            if (!HybridSearchSortUtil.containsTopFieldDocs(compoundTopDocs.getTopDocs())) continue;
            return compoundTopDocs.getTopDocs().toArray(new TopFieldDocs[0]);
        }
        return new TopFieldDocs[0];
    }

    private static boolean containsTopFieldDocs(List<TopDocs> topDocs) {
        if (topDocs == null || topDocs.isEmpty()) {
            return false;
        }
        for (TopDocs topDoc : topDocs) {
            if (topDoc == null || !(topDoc instanceof TopFieldDocs)) continue;
            return true;
        }
        return false;
    }

    private static Sort createSort(TopFieldDocs[] topFieldDocs) {
        SortField[] firstTopDocFields = topFieldDocs[0].fields;
        SortField[] newFields = new SortField[firstTopDocFields.length];
        for (int i = 0; i < firstTopDocFields.length; ++i) {
            SortField delegate = firstTopDocFields[i];
            SortField.Type sortFieldType = delegate instanceof SortedNumericSortField ? ((SortedNumericSortField)delegate).getNumericType() : delegate.getType();
            newFields[i] = SortedWiderNumericSortField.isTypeSupported((SortField.Type)sortFieldType) && HybridSearchSortUtil.isSortWideningRequired(topFieldDocs, i) ? new SortedWiderNumericSortField(delegate.getField(), sortFieldType, delegate.getReverse()) : firstTopDocFields[i];
        }
        return new Sort(newFields);
    }

    private static boolean isSortWideningRequired(TopFieldDocs[] topFieldDocs, int sortFieldindex) {
        for (int i = 0; i < topFieldDocs.length - 1; ++i) {
            TopFieldDocs currentTopFieldDoc = topFieldDocs[i];
            TopFieldDocs nextTopFieldDoc = topFieldDocs[i + 1];
            if (currentTopFieldDoc == null || nextTopFieldDoc == null) {
                throw new IllegalArgumentException("topFieldDocs cannot be null when sorting is applied");
            }
            if (currentTopFieldDoc.fields[sortFieldindex].equals((Object)nextTopFieldDoc.fields[sortFieldindex])) continue;
            return true;
        }
        return false;
    }
}

