/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.metric.temperature.shardIndependent.calculators;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.TemperatureMetricsBase;

public class ShardIndependentTemperatureCalculator
extends TemperatureMetricsBase {
    private static final Logger LOG = LogManager.getLogger(ShardIndependentTemperatureCalculator.class);
    private static final String[] dimensions = new String[]{AllMetrics.CommonDimension.OPERATION.toString()};

    public ShardIndependentTemperatureCalculator(TemperatureDimension metricType) {
        super(metricType, dimensions);
    }

    @Override
    protected Result<Record> createDslAndFetch(DSLContext context, String tableName, Field<?> aggDimension, List<Field<?>> groupByFieldsList, List<Field<?>> selectFieldsList) {
        Field shardIdField = DSL.field((Name)DSL.name((String)AllMetrics.CommonDimension.SHARD_ID.toString()));
        Result res = context.select(aggDimension).from(tableName).where(shardIdField.isNull()).fetch();
        LOG.info("ShardIndependentTemperatureCalculator: {}", (Object)res);
        return res;
    }

    @Override
    protected List<Field<?>> getSelectFieldsList(List<Field<?>> groupByFields, Field<?> aggrDimension) {
        return this.aggrColumnAsSelectField();
    }
}

