/*
 * Copyright © 2009 Christian Persch
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#pragma once

/**
 * SECTION:pps-version
 * @short_description: Library version checks
 *
 * These macros enable compile time checks of the library version.
 */

/**
 * PPS_MAJOR_VERSION:
 *
 * The major version number of the EV library
 * (e.g. in version 3.1.4 this is 3).
 */

#define PPS_MAJOR_VERSION (48)

/**
 * PPS_MINOR_VERSION:
 *
 * The minor version number of the EV library
 * (e.g. in version 3.1.4 this is 1).
 */
#define PPS_MINOR_VERSION (3)

/**
 * PPS_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 *
 * Macro to check the library version at compile time.
 * It returns <literal>1</literal> if the version of EV is greater or
 * equal to the required one, and <literal>0</literal> otherwise.
 */
#define PPS_CHECK_VERSION(major,minor) \
  (PPS_MAJOR_VERSION > (major) || \
   (PPS_MAJOR_VERSION == (major) && PPS_MINOR_VERSION > (minor))
