/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.style.ISkinSimple;

public class CommandCreoleOpenIcon
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<(#\\w+)?&([-\\w]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,?color[= :](?:#[0-9a-fA-F]{1,8}|\\w+))?\\}?)?\\>)");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleOpenIcon() {
    }

    public static Command create() {
        return new CommandCreoleOpenIcon();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String colorName1 = m.group(2);
        String src = m.group(3);
        double scale = Parser.getScale(m.group(4), 1.0);
        String colorName2 = Parser.getColor(m.group(4));
        String colorName = colorName1 == null ? colorName2 : colorName1;
        HColor color = null;
        if (colorName != null) {
            ISkinSimple skinParam = stripe.getSkinParam();
            color = skinParam.getIHtmlColorSet().getColorOrWhite(colorName);
        }
        stripe.addOpenIcon(src, scale, color);
        return line.substring(m.group(1).length());
    }
}

