#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-36DsjrDcmx23svmJSwwZd9
key:                  postgrest-10.0.0-36DsjrDcmx23svmJSwwZd9
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  667a5d3bbb283b8eb3604f8ce4d35d4a
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-36DsjrDcmx23svmJSwwZd9
depends:
    HTTP-4000.4.1-B8TxdUJICCrGpby19NgTiF
    Ranged-sets-0.4.0-DWpaWMxU5Gq5NCi1ROvlAj
    aeson-2.1.2.1-LDBL5bcX1HC79scYyh3opi
    auto-update-0.1.6-16jEaaV6A1kFvghEJqa7ou base-4.17.2.1
    base64-bytestring-1.2.1.0-4WGXcVCcj2fHlYYfmt97g1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-3jbMOlKTiDn4NCqaBZ47Ne
    cassava-0.5.3.2-HB0L9fb5BO3DwATcwa64JO
    configurator-pg-0.2.10-5gWC2gSi3knBvWhayay80z containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-KJSurByLz86Ck4Hkzt9tEV
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.4-BOSNnTlaTh0IbDwmmRhvAo
    hasql-dynamic-statements-0.3.1.1-8KW5Fmyge0jF3r1kvjUAiQ
    hasql-notifications-0.2.0.4-CIPcQ1xkWISOUQUMuergI
    hasql-pool-0.5.2.2-J5a7WK6zmRYHtE48QzcOOY
    hasql-transaction-1.0.1.1-HNm9bml4zRh9K5qcD1Itrj
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-3FyJu2Ux8ftJoanRheHyWI
    insert-ordered-containers-0.2.5.3-I4sGYYZDk1LHBeKLO13Aak
    interpolatedstring-perl6-1.0.2-Hv7FsjEr6LkE824TOteztL
    jose-0.10-F356p0QuAms4Y9SYXFciBo lens-5.2.3-CV81uxSR0PiAcO8XtynZEb
    lens-aeson-1.2.3-Im6LUhTupSGCj02z8tfmZp mtl-2.2.2
    network-3.1.4.0-24l6wfZeDaoIo68scGYLPE
    network-uri-2.6.4.2-EjZpKZ4F93eKYvVi9AsGV0
    optparse-applicative-0.17.1.0-4tPjpOfYmOi9nj8To0UB1j
    parsec-3.1.16.1 protolude-0.3.4-7XTZg0gwjjKIn8FBTF9Ba4
    regex-tdfa-1.3.2.4-4spaPYpacr92ooLlQb3epN
    retry-0.9.3.1-4KlaHyu6mnzF5UBo1lmEsD
    scientific-0.3.7.0-EYP4lwU6ELFEdSU4sCeddu
    swagger2-2.8.9-4urh2vVTprb8shhS3cf9m1 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-2kG5VEC3Gy42AwINT9WJ9w
    vault-0.3.1.5-7IYXvHzYZ2YB4ngUPrbbfY
    vector-0.13.1.0-Dc65CzydytHE52tdajtbOv
    wai-3.2.4-G8OpaxOEe1K2xhGxWFGAVq
    wai-cors-0.2.7-9XynAUq9voG8jkzh9TLKaU
    wai-extra-3.1.16-4fktyihdjtV14ZFcgmL8Fb
    wai-logger-2.5.0-L9PhHLKXhaJ240xPXzAkRo
    warp-3.3.30-38vnaj4wlDPIgdQnaBLjGR

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

