#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-AT9Nzc5vQI7G5i3KrWF8mF
key:                  postgrest-10.0.0-AT9Nzc5vQI7G5i3KrWF8mF
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  35dc17b0a0807e94e3481dd4cc9fa29a
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-AT9Nzc5vQI7G5i3KrWF8mF
depends:
    HTTP-4000.4.1-7Tl5Ln5XcrpBNMApzijAeT
    Ranged-sets-0.4.0-D7o8STMeAwTGGxgVsR981p
    aeson-2.1.2.1-LS8mizUYnpf1U9zpV4sjcf
    auto-update-0.1.6-LJmHXcooCIL5a84yG4HhEq base-4.17.2.1
    base64-bytestring-1.2.1.0-9p4vtkAuTQ4GHdtuHWxZHU
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-FZkso54i68UDZy9QWLkbnV
    cassava-0.5.3.2-yIM8AbTVf29Upq1My9xEE
    configurator-pg-0.2.10-HY37868ejJfCV3UuaixNkO containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-7ngaaf4aUZkDN9ScahDVo6
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-KiEJHQIMy6xGjkc4Um34zp
    hasql-dynamic-statements-0.3.1.1-ITBkUPD02lfDSNbgoSqICc
    hasql-notifications-0.2.0.4-HdIzFdvTZA4G7Hgoosv6VW
    hasql-pool-0.5.2.2-28PfoqR660oGECxqxsWBAH
    hasql-transaction-1.0.1.1-F87QQZ9m1yvGhxZ5ka9lYn
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-3waRWhsRr1C4PfAAAPJbwc
    insert-ordered-containers-0.2.5.3-1kPyqGe2Ab1zfm2beIuvs
    interpolatedstring-perl6-1.0.2-9TqVaWZTVg88SYK620K5u8
    jose-0.10-He0p4I6ytvpBckFxBWnizo lens-5.2.3-DzkbQ1V4DGJJfQUmuvkfoj
    lens-aeson-1.2.3-IenDwKMnsz1IzdUJ2N7yVt mtl-2.2.2
    network-3.1.4.0-6CSLlS2XYBeLlFfm0MgCfu
    network-uri-2.6.4.2-APaQU0Ye6OaKm6pWDY2rCG
    optparse-applicative-0.17.1.0-4tPjpOfYmOi9nj8To0UB1j
    parsec-3.1.16.1 protolude-0.3.5-4OKktG4Zhpt44WPZ0dqSeX
    regex-tdfa-1.3.2.4-AAuM6ZM4tbzHRXDs6OdINo
    retry-0.9.3.1-Iuo2BhNZ5PnJontSy1pwx2
    scientific-0.3.7.0-I6iMwi20J4G9Jw2tSdEPEK
    swagger2-2.8.10-EpiecFzXpq21RI73XGkJRG text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-vB8Yx6KwyeBrT13JKFJ0i
    vault-0.3.1.5-Cfmyqag3aBcGtkyS24rNAR
    vector-0.13.2.0-KDCTRjRQ0urK2B6TNAGAn8
    wai-3.2.4-3SqC73n3qJdLTkLMbZrVoF
    wai-cors-0.2.7-DaVMqeGSJl4AtLaRRiTNvQ
    wai-extra-3.1.17-4Eyg1IyLbgR6NaO2piiz0G
    wai-logger-2.5.0-B6AsKG7xROmCxI3ZhnFgCg
    warp-3.3.30-Gi1JAQRG27SIrwRqtuxt3h

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

