/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.tracing;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpan;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.http.HttpRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.util.tracing.SolrApacheHttpRequestCarrier;
import org.apache.solr.util.tracing.SolrJettyRequestCarrier;
import org.eclipse.jetty.client.api.Request;

public class TraceUtils {
    public static final Predicate<Span> DEFAULT_IS_RECORDING = span -> span != null && !(span instanceof NoopSpan);
    public static Predicate<Span> IS_RECORDING = DEFAULT_IS_RECORDING;

    public static void setDbInstance(SolrQueryRequest req, String coreOrColl) {
        if (req != null && coreOrColl != null) {
            TraceUtils.ifNotNoop(req.getSpan(), span -> span.setTag((Tag)Tags.DB_INSTANCE, (Object)coreOrColl));
        }
    }

    public static void ifNotNoop(Span span, Consumer<Span> consumer) {
        if (IS_RECORDING.test(span)) {
            consumer.accept(span);
        }
    }

    public static void injectTraceContext(Request req, Span span) {
        Tracer tracer = GlobalTracer.get();
        if (span != null) {
            tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new SolrJettyRequestCarrier(req));
        }
    }

    public static void injectTraceContext(HttpRequest req) {
        Tracer tracer = GlobalTracer.get();
        Span span = tracer.activeSpan();
        if (span != null) {
            tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new SolrApacheHttpRequestCarrier(req));
        }
    }

    public static void setOperations(SolrQueryRequest req, String clazz, List<String> ops) {
        if (!ops.isEmpty()) {
            req.getSpan().setTag("ops", String.join((CharSequence)",", ops));
            req.getSpan().setTag("class", clazz);
        }
    }

    public static Span startCollectionApiCommandSpan(Tracer tracer, String name, String collection, boolean isAsync) {
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(name).asChildOf(tracer.activeSpan()).withTag((Tag)Tags.SPAN_KIND, (Object)(isAsync ? "producer" : "client")).withTag((Tag)Tags.DB_INSTANCE, (Object)collection);
        return spanBuilder.start();
    }
}

