complete -c srgn -l completions -d 'Print shell completions for the given shell.' -r -f -a "{bash\t'',elvish\t'',fish\t'',powershell\t'',zsh\t''}"
complete -c srgn -s G -l glob -d 'Glob of files to work on (instead of reading stdin).' -r
complete -c srgn -l stdin-override-to -d 'Override detection heuristics for stdin readability, and force to value.' -r -f -a "{true\t'',false\t''}"
complete -c srgn -l threads -d 'Number of threads to run processing on, when working with files.' -r
complete -c srgn -l c -d 'Scope C code using a prepared query.' -r -f -a "{comments\t'Comments (single- and multi-line)',strings\t'Strings',includes\t'Includes',type-def\t'Type definitions',enum\t'`enum` definitions',struct\t'`struct` type definitions',variable\t'Variable definitions',function\t'All functions usages (declarations and calls)',function-def\t'Function definitions',function-decl\t'Function declaration',switch\t'`switch` blocks',if\t'`if` blocks',for\t'`for` blocks',while\t'`while` blocks',do\t'`do` blocks',union\t'`union` blocks',identifier\t'Identifier',declaration\t'Declaration',call-expression\t'Call expression'}"
complete -c srgn -l c-query -d 'Scope C code using a custom tree-sitter query.' -r
complete -c srgn -l c-query-file -d 'Scope C code using a custom tree-sitter query from file.' -r -F
complete -c srgn -l csharp -l cs -d 'Scope C# code using a prepared query.' -r -f -a "{comments\t'Comments (including XML, inline, doc comments)',strings\t'Strings (incl. verbatim, interpolated; incl. quotes, except for interpolated)',usings\t'`using` directives (including periods)',struct\t'`struct` definitions (in their entirety)',enum\t'`enum` definitions (in their entirety)',interface\t'`interface` definitions (in their entirety)',class\t'`class` definitions (in their entirety)',method\t'Method definitions (in their entirety)',variable-declaration\t'Variable declarations (in their entirety)',property\t'Property definitions (in their entirety)',constructor\t'Constructor definitions (in their entirety)',destructor\t'Destructor definitions (in their entirety)',field\t'Field definitions on types (in their entirety)',attribute\t'Attribute names',identifier\t'Identifier names'}"
complete -c srgn -l csharp-query -d 'Scope C# code using a custom tree-sitter query.' -r
complete -c srgn -l csharp-query-file -d 'Scope C# code using a custom tree-sitter query from file.' -r -F
complete -c srgn -l go -d 'Scope Go code using a prepared query.' -r -f -a "{comments\t'Comments (single- and multi-line)',strings\t'Strings (interpreted and raw; excluding struct tags)',imports\t'Imports',expression\t'Expressions (all of them!)',type-def\t'Type definitions',type-alias\t'Type alias assignments',struct\t'`struct` type definitions',struct~<PATTERN>\t'Like struct, but only considers items whose name matches PATTERN.',interface\t'`interface` type definitions',interface~<PATTERN>\t'Like interface, but only considers items whose name matches PATTERN.',const\t'`const` specifications',var\t'`var` specifications',func\t'`func` definitions',func~<PATTERN>\t'Like func, but only considers items whose name matches PATTERN.',method\t'Method `func` definitions (`func (recv Recv) SomeFunc()`)',free-func\t'Free `func` definitions (`func SomeFunc()`)',init-func\t'`func init()` definitions',type-params\t'Type parameters (generics)',defer\t'`defer` blocks',select\t'`select` blocks',go\t'`go` blocks',switch\t'`switch` blocks',labeled\t'Labeled statements',goto\t'`goto` statements',struct-tags\t'Struct tags'}"
complete -c srgn -l go-query -d 'Scope Go code using a custom tree-sitter query.' -r
complete -c srgn -l go-query-file -d 'Scope Go code using a custom tree-sitter query from file.' -r -F
complete -c srgn -l hcl -d 'Scope HashiCorp Configuration Language code using a prepared query.' -r -f -a "{variable\t'`variable` blocks (in their entirety)',resource\t'`resource` blocks (in their entirety)',data\t'`data` blocks (in their entirety)',output\t'`output` blocks (in their entirety)',provider\t'`provider` blocks (in their entirety)',terraform\t'`terraform` blocks (in their entirety)',locals\t'`locals` blocks (in their entirety)',module\t'`module` blocks (in their entirety)',variables\t'Variable declarations and usages',resource-names\t'`resource` name declarations and usages',resource-types\t'`resource` type declarations and usages',data-names\t'`data` name declarations and usages',data-sources\t'`data` source declarations and usages',comments\t'Comments',strings\t'Literal strings'}"
complete -c srgn -l hcl-query -d 'Scope HashiCorp Configuration Language code using a custom tree-sitter query.' -r
complete -c srgn -l hcl-query-file -d 'Scope HashiCorp Configuration Language code using a custom tree-sitter query from file.' -r -F
complete -c srgn -l python -l py -d 'Scope Python code using a prepared query.' -r -f -a "{comments\t'Comments',strings\t'Strings (raw, byte, f-strings; interpolation not included)',imports\t'Module names in imports (incl. periods; excl. `import`/`from`/`as`/`*`)',doc-strings\t'Docstrings (not including multi-line strings)',function-names\t'Function names, at the definition site',function-calls\t'Function calls',class\t'Class definitions (in their entirety)',def\t'Function definitions (*all* `def` block in their entirety)',async-def\t'Async function definitions (*all* `async def` block in their entirety)',methods\t'Function definitions inside `class` bodies',class-methods\t'Function definitions decorated as `classmethod` (excl. the decorator)',static-methods\t'Function definitions decorated as `staticmethod` (excl. the decorator)',with\t'`with` blocks (in their entirety)',try\t'`try` blocks (in their entirety)',lambda\t'`lambda` statements (in their entirety)',globals\t'Global, i.e. module-level variables',variable-identifiers\t'Identifiers for variables (left-hand side of assignments)',types\t'Types in type hints',identifiers\t'Identifiers (variable names, ...)'}"
complete -c srgn -l python-query -d 'Scope Python code using a custom tree-sitter query.' -r
complete -c srgn -l python-query-file -d 'Scope Python code using a custom tree-sitter query from file.' -r -F
complete -c srgn -l rust -l rs -d 'Scope Rust code using a prepared query.' -r -f -a "{comments\t'Comments (line and block styles; excluding doc comments; comment chars incl.)',doc-comments\t'Doc comments (comment chars included)',uses\t'Use statements (paths only; excl. `use`/`as`/`*`)',strings\t'Strings (regular, raw, byte; includes interpolation parts in format strings!)',attribute\t'Attributes like `#[attr]`',struct\t'`struct` definitions',struct~<PATTERN>\t'Like struct, but only considers items whose name matches PATTERN.',priv-struct\t'`struct` definitions not marked `pub`',pub-struct\t'`struct` definitions marked `pub`',pub-crate-struct\t'`struct` definitions marked `pub(crate)`',pub-self-struct\t'`struct` definitions marked `pub(self)`',pub-super-struct\t'`struct` definitions marked `pub(super)`',enum\t'`enum` definitions',enum~<PATTERN>\t'Like enum, but only considers items whose name matches PATTERN.',priv-enum\t'`enum` definitions not marked `pub`',pub-enum\t'`enum` definitions marked `pub`',pub-crate-enum\t'`enum` definitions marked `pub(crate)`',pub-self-enum\t'`enum` definitions marked `pub(self)`',pub-super-enum\t'`enum` definitions marked `pub(super)`',enum-variant\t'Variant members of `enum` definitions',fn\t'Function definitions',fn~<PATTERN>\t'Like fn, but only considers items whose name matches PATTERN.',impl-fn\t'Function definitions inside `impl` blocks (associated functions/methods)',priv-fn\t'Function definitions not marked `pub`',pub-fn\t'Function definitions marked `pub`',pub-crate-fn\t'Function definitions marked `pub(crate)`',pub-self-fn\t'Function definitions marked `pub(self)`',pub-super-fn\t'Function definitions marked `pub(super)`',const-fn\t'Function definitions marked `const`',async-fn\t'Function definitions marked `async`',unsafe-fn\t'Function definitions marked `unsafe`',extern-fn\t'Function definitions marked `extern`',test-fn\t'Function definitions with attributes containing `test` (`#[test]`, `#[rstest]`, ...)',trait\t'`trait` definitions',trait~<PATTERN>\t'Like trait, but only considers items whose name matches PATTERN.',impl\t'`impl` blocks',impl-type\t'`impl` blocks for types (`impl SomeType {}`)',impl-trait\t'`impl` blocks for traits on types (`impl SomeTrait for SomeType {}`)',mod\t'`mod` blocks',mod~<PATTERN>\t'Like mod, but only considers items whose name matches PATTERN.',mod-tests\t'`mod tests` blocks',type-def\t'Type definitions (`struct`, `enum`, `union`)',identifier\t'Identifiers',type-identifier\t'Identifiers for types',closure\t'Closure definitions',unsafe\t'`unsafe` keyword usages (`unsafe fn`, `unsafe` blocks, `unsafe Trait`, `unsafe impl Trait`)'}"
complete -c srgn -l rust-query -d 'Scope Rust code using a custom tree-sitter query.' -r
complete -c srgn -l rust-query-file -d 'Scope Rust code using a custom tree-sitter query from file.' -r -F
complete -c srgn -l typescript -l ts -d 'Scope TypeScript code using a prepared query.' -r -f -a "{comments\t'Comments',strings\t'Strings (literal, template)',imports\t'Imports (module specifiers)',function\t'Any `function` definitions',async-function\t'`async function` definitions',sync-function\t'Non-`async function` definitions',method\t'Method definitions',constructor\t'`constructor` method definitions',class\t'`class` definitions',enum\t'`enum` definitions',interface\t'`interface` definitions',try-catch\t'`try`/`catch`/`finally` blocks',var-decl\t'Variable declarations (`let`, `const`, `var`)',let\t'`let` variable declarations',const\t'`const` variable declarations',var\t'`var` variable declarations',type-params\t'Type (generic) parameters',type-alias\t'Type alias declarations',namespace\t'`namespace` blocks',export\t'`export` blocks'}"
complete -c srgn -l typescript-query -d 'Scope TypeScript code using a custom tree-sitter query.' -r
complete -c srgn -l typescript-query-file -d 'Scope TypeScript code using a custom tree-sitter query from file.' -r -F
complete -c srgn -s u -l upper -d 'Uppercase anything in scope.'
complete -c srgn -s l -l lower -d 'Lowercase anything in scope.'
complete -c srgn -s t -l titlecase -d 'Titlecase anything in scope.'
complete -c srgn -s n -l normalize -d 'Normalize (Normalization Form D) anything in scope, and throw away marks.'
complete -c srgn -s g -l german -d 'Perform substitutions on German words, such as \'Abenteuergruesse\' to \'Abenteuergrüße\', for anything in scope.'
complete -c srgn -s S -l symbols -d 'Perform substitutions on symbols, such as \'!=\' to \'≠\', \'->\' to \'→\', on anything in scope.'
complete -c srgn -s d -l delete -d 'Delete anything in scope.'
complete -c srgn -s s -l squeeze -l squeeze-repeats -d 'Squeeze consecutive occurrences of scope into one.'
complete -c srgn -l fail-no-files -d 'Fail if working on files (e.g. globbing is requested) but none are found.'
complete -c srgn -l dry-run -d 'Do not destructively overwrite files, instead print rich diff only.'
complete -c srgn -s i -l invert -d 'Undo the effects of passed actions, where applicable.'
complete -c srgn -s L -l literal-string -d 'Do not interpret the scope as a regex. Instead, interpret it as a literal string. Will require a scope to be passed.'
complete -c srgn -l fail-any -d 'If anything at all is found to be in scope, fail.'
complete -c srgn -l fail-none -d 'If nothing is found to be in scope, fail.'
complete -c srgn -s j -l join-language-scopes -d 'Join (logical \'OR\') multiple language scopes, instead of intersecting them.'
complete -c srgn -l line-numbers -d 'Prepend line numbers to output.'
complete -c srgn -l only-matching -d 'Print only matching lines.'
complete -c srgn -s H -l hidden -d 'Do not ignore hidden files and directories.'
complete -c srgn -l gitignored -d 'Do not ignore `.gitignore`d files and directories.'
complete -c srgn -l sorted -d 'Process files in lexicographically sorted order, by file path.'
complete -c srgn -s v -l verbose -d 'Increase log verbosity level.'
complete -c srgn -l german-prefer-original -d 'When some original version and its replacement are equally legal, prefer the original and do not modify.'
complete -c srgn -l german-naive -d 'Always perform any possible replacement (\'ae\' -> \'ä\', \'ss\' -> \'ß\', etc.), regardless of legality of the resulting word'
complete -c srgn -s h -l help -d 'Print help (see more with \'--help\')'
complete -c srgn -s V -l version -d 'Print version'
