/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.graph.geom.plane.Winding;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.math.Vert2fImmutable;
import java.util.ArrayList;

public final class VectorUtil {
    public static boolean isVec2Zero(Vec3f vec3f) {
        return 0.0f == vec3f.x() && 0.0f == vec3f.y();
    }

    public static boolean isZero(float f, float f2, float f3, float f4) {
        return FloatUtil.isZero(f, f4) && FloatUtil.isZero(f2, f4) && FloatUtil.isZero(f3, f4);
    }

    public static float distSquareVec3(float[] fArray, float[] fArray2) {
        float f = fArray[0] - fArray2[0];
        float f2 = fArray[1] - fArray2[1];
        float f3 = fArray[2] - fArray2[2];
        return f * f + f2 * f2 + f3 * f3;
    }

    public static float distVec3(float[] fArray, float[] fArray2) {
        return FloatUtil.sqrt(VectorUtil.distSquareVec3(fArray, fArray2));
    }

    public static float normSquareVec2(float[] fArray) {
        return fArray[0] * fArray[0] + fArray[1] * fArray[1];
    }

    public static float normSquareVec3(float[] fArray) {
        return fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2];
    }

    public static float normSquareVec3(float[] fArray, int n) {
        float f = fArray[0 + n];
        float f2 = f * f;
        f = fArray[1 + n];
        f2 += f * f;
        f = fArray[2 + n];
        return f2 + f * f;
    }

    public static float normVec2(float[] fArray) {
        return FloatUtil.sqrt(VectorUtil.normSquareVec2(fArray));
    }

    public static float[] normalizeVec3(float[] fArray) {
        float f = VectorUtil.normSquareVec3(fArray);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            fArray[0] = fArray[0] * f2;
            fArray[1] = fArray[1] * f2;
            fArray[2] = fArray[2] * f2;
        }
        return fArray;
    }

    public static float[] normalizeVec3(float[] fArray, int n) {
        float f = VectorUtil.normSquareVec3(fArray, n);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            fArray[0 + n] = 0.0f;
            fArray[1 + n] = 0.0f;
            fArray[2 + n] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            int n2 = 0 + n;
            fArray[n2] = fArray[n2] * f2;
            int n3 = 1 + n;
            fArray[n3] = fArray[n3] * f2;
            int n4 = 2 + n;
            fArray[n4] = fArray[n4] * f2;
        }
        return fArray;
    }

    public static float[] scaleVec2(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray2[0] * f;
        fArray[1] = fArray2[1] * f;
        return fArray;
    }

    public static float[] scaleVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0];
        fArray[1] = fArray2[1] * fArray3[1];
        return fArray;
    }

    public static float[] divVec2(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray2[0] / f;
        fArray[1] = fArray2[1] / f;
        return fArray;
    }

    public static float[] divVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] / fArray3[0];
        fArray[1] = fArray2[1] / fArray3[1];
        return fArray;
    }

    public static float[] addVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] + fArray3[0];
        fArray[1] = fArray2[1] + fArray3[1];
        return fArray;
    }

    public static float[] subVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] - fArray3[0];
        fArray[1] = fArray2[1] - fArray3[1];
        return fArray;
    }

    public static float[] crossVec3(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        fArray[0 + n] = fArray2[1 + n2] * fArray3[2 + n3] - fArray2[2 + n2] * fArray3[1 + n3];
        fArray[1 + n] = fArray2[2 + n2] * fArray3[0 + n3] - fArray2[0 + n2] * fArray3[2 + n3];
        fArray[2 + n] = fArray2[0 + n2] * fArray3[1 + n3] - fArray2[1 + n2] * fArray3[0 + n3];
        return fArray;
    }

    public static Vec3f midVec3(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        vec3f.set((vec3f2.x() + vec3f3.x()) * 0.5f, (vec3f2.y() + vec3f3.y()) * 0.5f, (vec3f2.z() + vec3f3.z()) * 0.5f);
        return vec3f;
    }

    public static float determinantVec3(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        return vec3f.x() * vec3f2.y() * vec3f3.z() + vec3f.y() * vec3f2.z() * vec3f3.x() + vec3f.z() * vec3f2.x() * vec3f3.y() - vec3f.x() * vec3f2.z() * vec3f3.y() - vec3f.y() * vec3f2.x() * vec3f3.z() - vec3f.z() * vec3f2.y() * vec3f3.x();
    }

    public static boolean isCollinearVec3(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        return FloatUtil.isZero(VectorUtil.determinantVec3(vec3f, vec3f2, vec3f3), 1.1920929E-7f);
    }

    public static boolean isInCircleVec2(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        return (vert2fImmutable.x() * vert2fImmutable.x() + vert2fImmutable.y() * vert2fImmutable.y()) * VectorUtil.triAreaVec2(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4) - (vert2fImmutable2.x() * vert2fImmutable2.x() + vert2fImmutable2.y() * vert2fImmutable2.y()) * VectorUtil.triAreaVec2(vert2fImmutable, vert2fImmutable3, vert2fImmutable4) + (vert2fImmutable3.x() * vert2fImmutable3.x() + vert2fImmutable3.y() * vert2fImmutable3.y()) * VectorUtil.triAreaVec2(vert2fImmutable, vert2fImmutable2, vert2fImmutable4) - (vert2fImmutable4.x() * vert2fImmutable4.x() + vert2fImmutable4.y() * vert2fImmutable4.y()) * VectorUtil.triAreaVec2(vert2fImmutable, vert2fImmutable2, vert2fImmutable3) > 0.0f;
    }

    public static float triAreaVec2(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        return (vert2fImmutable2.x() - vert2fImmutable.x()) * (vert2fImmutable3.y() - vert2fImmutable.y()) - (vert2fImmutable2.y() - vert2fImmutable.y()) * (vert2fImmutable3.x() - vert2fImmutable.x());
    }

    public static boolean isInTriangleVec3(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6, Vec3f vec3f7) {
        vec3f5.minus(vec3f3, vec3f);
        vec3f6.minus(vec3f2, vec3f);
        vec3f7.minus(vec3f4, vec3f);
        float f = vec3f5.dot(vec3f5);
        float f2 = vec3f5.dot(vec3f6);
        float f3 = vec3f6.dot(vec3f6);
        float f4 = vec3f5.dot(vec3f7);
        float f5 = vec3f6.dot(vec3f7);
        float f6 = 1.0f / (f * f3 - f2 * f2);
        float f7 = (f3 * f4 - f2 * f5) * f6;
        float f8 = (f * f5 - f2 * f4) * f6;
        return f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f;
    }

    public static boolean isVec3InTriangle3(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6, Vec3f vec3f7, Vec3f vec3f8, Vec3f vec3f9) {
        vec3f7.minus(vec3f3, vec3f);
        vec3f8.minus(vec3f2, vec3f);
        float f = vec3f7.dot(vec3f7);
        float f2 = vec3f7.dot(vec3f8);
        float f3 = vec3f8.dot(vec3f8);
        float f4 = 1.0f / (f * f3 - f2 * f2);
        vec3f9.minus(vec3f4, vec3f);
        float f5 = vec3f7.dot(vec3f9);
        float f6 = vec3f8.dot(vec3f9);
        float f7 = (f3 * f5 - f2 * f6) * f4;
        float f8 = (f * f6 - f2 * f5) * f4;
        if (f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f) {
            return true;
        }
        vec3f9.minus(vec3f5, vec3f);
        f5 = vec3f7.dot(vec3f9);
        f6 = vec3f8.dot(vec3f9);
        f7 = (f3 * f5 - f2 * f6) * f4;
        f8 = (f * f6 - f2 * f5) * f4;
        if (f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f) {
            return true;
        }
        vec3f9.minus(vec3f6, vec3f);
        f5 = vec3f7.dot(vec3f9);
        f6 = vec3f8.dot(vec3f9);
        f7 = (f3 * f5 - f2 * f6) * f4;
        f8 = (f * f6 - f2 * f5) * f4;
        return f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f;
    }

    public static boolean isVec3InTriangle3(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6, Vec3f vec3f7, Vec3f vec3f8, Vec3f vec3f9, float f) {
        vec3f7.minus(vec3f3, vec3f);
        vec3f8.minus(vec3f2, vec3f);
        float f2 = vec3f7.dot(vec3f7);
        float f3 = vec3f7.dot(vec3f8);
        float f4 = vec3f8.dot(vec3f8);
        float f5 = 1.0f / (f2 * f4 - f3 * f3);
        vec3f9.minus(vec3f4, vec3f);
        float f6 = vec3f7.dot(vec3f9);
        float f7 = vec3f8.dot(vec3f9);
        float f8 = (f4 * f6 - f3 * f7) * f5;
        float f9 = (f2 * f7 - f3 * f6) * f5;
        if (FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0) {
            return true;
        }
        vec3f9.minus(vec3f5, vec3f);
        f6 = vec3f7.dot(vec3f9);
        f7 = vec3f8.dot(vec3f9);
        f8 = (f4 * f6 - f3 * f7) * f5;
        f9 = (f2 * f7 - f3 * f6) * f5;
        if (FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0) {
            return true;
        }
        vec3f9.minus(vec3f6, vec3f);
        f6 = vec3f7.dot(vec3f9);
        f7 = vec3f8.dot(vec3f9);
        f8 = (f4 * f6 - f3 * f7) * f5;
        f9 = (f2 * f7 - f3 * f6) * f5;
        return FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0;
    }

    public static boolean isCCW(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        return VectorUtil.triAreaVec2(vert2fImmutable, vert2fImmutable2, vert2fImmutable3) > 0.0f;
    }

    public static Winding getWinding(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        return VectorUtil.triAreaVec2(vert2fImmutable, vert2fImmutable2, vert2fImmutable3) > 0.0f ? Winding.CCW : Winding.CW;
    }

    public static float area(ArrayList<? extends Vert2fImmutable> arrayList) {
        int n = arrayList.size();
        float f = 0.0f;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            Vert2fImmutable vert2fImmutable = arrayList.get(n2);
            Vert2fImmutable vert2fImmutable2 = arrayList.get(n3);
            f += vert2fImmutable.x() * vert2fImmutable2.y() - vert2fImmutable2.x() * vert2fImmutable.y();
            n2 = n3++;
        }
        return f;
    }

    public static Winding getWinding(ArrayList<? extends Vert2fImmutable> arrayList) {
        return VectorUtil.area(arrayList) >= 0.0f ? Winding.CCW : Winding.CW;
    }

    public static Vec4f getPlaneVec3(Vec4f vec4f, Vec3f vec3f, Vec3f vec3f2) {
        vec4f.set(vec3f, -vec3f.dot(vec3f2));
        return vec4f;
    }

    public static Vec4f getPlaneVec3(Vec4f vec4f, Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6) {
        vec3f6.cross(vec3f4.minus(vec3f2, vec3f), vec3f5.minus(vec3f3, vec3f)).normalize();
        vec4f.set(vec3f6, -vec3f6.dot(vec3f));
        return vec4f;
    }

    public static Vec3f line2PlaneIntersection(Vec3f vec3f, Ray ray, Vec4f vec4f, float f) {
        Vec3f vec3f2 = new Vec3f(vec4f);
        float f2 = ray.dir.dot(vec3f2);
        if (Math.abs(f2) < f) {
            return null;
        }
        vec3f.set(ray.dir);
        return vec3f.scale(-(ray.orig.dot(vec3f2) + vec4f.w()) / f2).add(ray.orig);
    }

    public static Vec3f seg2SegIntersection(Vec3f vec3f, Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = (vert2fImmutable.x() - vert2fImmutable2.x()) * (vert2fImmutable3.y() - vert2fImmutable4.y()) - (vert2fImmutable.y() - vert2fImmutable2.y()) * (vert2fImmutable3.x() - vert2fImmutable4.x());
        if (f == 0.0f) {
            return null;
        }
        float f2 = vert2fImmutable.x() * vert2fImmutable2.y() - vert2fImmutable.y() * vert2fImmutable2.x();
        float f3 = vert2fImmutable3.x() * vert2fImmutable4.y() - vert2fImmutable3.y() * vert2fImmutable4.y();
        float f4 = ((vert2fImmutable3.x() - vert2fImmutable4.x()) * f2 - (vert2fImmutable.x() - vert2fImmutable2.x()) * f3) / f;
        float f5 = ((vert2fImmutable3.y() - vert2fImmutable4.y()) * f2 - (vert2fImmutable.y() - vert2fImmutable2.y()) * f3) / f;
        float f6 = (f4 - vert2fImmutable.x()) / (vert2fImmutable2.x() - vert2fImmutable.x());
        float f7 = (f4 - vert2fImmutable3.x()) / (vert2fImmutable4.x() - vert2fImmutable3.x());
        if (f6 <= 0.0f || f6 >= 1.0f) {
            return null;
        }
        if (f7 <= 0.0f || f7 >= 1.0f) {
            return null;
        }
        return vec3f.set(f4, f5, 0.0f);
    }

    public static boolean testSeg2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = (vert2fImmutable.x() - vert2fImmutable2.x()) * (vert2fImmutable3.y() - vert2fImmutable4.y()) - (vert2fImmutable.y() - vert2fImmutable2.y()) * (vert2fImmutable3.x() - vert2fImmutable4.x());
        if (f == 0.0f) {
            return false;
        }
        float f2 = vert2fImmutable.x() * vert2fImmutable2.y() - vert2fImmutable.y() * vert2fImmutable2.x();
        float f3 = vert2fImmutable3.x() * vert2fImmutable4.y() - vert2fImmutable3.y() * vert2fImmutable4.y();
        float f4 = ((vert2fImmutable3.x() - vert2fImmutable4.x()) * f2 - (vert2fImmutable.x() - vert2fImmutable2.x()) * f3) / f;
        float f5 = (f4 - vert2fImmutable.x()) / (vert2fImmutable2.x() - vert2fImmutable.x());
        float f6 = (f4 - vert2fImmutable3.x()) / (vert2fImmutable4.x() - vert2fImmutable3.x());
        return !(f5 <= 0.0f || f5 >= 1.0f || f6 <= 0.0f) && !(f6 >= 1.0f);
    }

    public static boolean testSeg2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, float f) {
        float f2 = (vert2fImmutable.x() - vert2fImmutable2.x()) * (vert2fImmutable3.y() - vert2fImmutable4.y()) - (vert2fImmutable.y() - vert2fImmutable2.y()) * (vert2fImmutable3.x() - vert2fImmutable4.x());
        if (FloatUtil.isZero(f2, f)) {
            return false;
        }
        float f3 = vert2fImmutable.x() * vert2fImmutable2.y() - vert2fImmutable.y() * vert2fImmutable2.x();
        float f4 = vert2fImmutable3.x() * vert2fImmutable4.y() - vert2fImmutable3.y() * vert2fImmutable4.y();
        float f5 = ((vert2fImmutable3.x() - vert2fImmutable4.x()) * f3 - (vert2fImmutable.x() - vert2fImmutable2.x()) * f4) / f2;
        float f6 = (f5 - vert2fImmutable.x()) / (vert2fImmutable2.x() - vert2fImmutable.x());
        float f7 = (f5 - vert2fImmutable3.x()) / (vert2fImmutable4.x() - vert2fImmutable3.x());
        if (FloatUtil.compare(f6, 0.0f, f) <= 0 || FloatUtil.compare(f6, 1.0f, f) >= 0 || FloatUtil.compare(f7, 0.0f, f) <= 0 || FloatUtil.compare(f7, 1.0f, f) >= 0) {
            return false;
        }
        return !(f6 <= 0.0f || f6 >= 1.0f || f7 <= 0.0f) && !(f7 >= 1.0f);
    }

    public static Vec3f line2lineIntersection(Vec3f vec3f, Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = (vert2fImmutable.x() - vert2fImmutable2.x()) * (vert2fImmutable3.y() - vert2fImmutable4.y()) - (vert2fImmutable.y() - vert2fImmutable2.y()) * (vert2fImmutable3.x() - vert2fImmutable4.x());
        if (f == 0.0f) {
            return null;
        }
        float f2 = vert2fImmutable.x() * vert2fImmutable2.y() - vert2fImmutable.y() * vert2fImmutable2.x();
        float f3 = vert2fImmutable3.x() * vert2fImmutable4.y() - vert2fImmutable3.y() * vert2fImmutable4.y();
        float f4 = ((vert2fImmutable3.x() - vert2fImmutable4.x()) * f2 - (vert2fImmutable.x() - vert2fImmutable2.x()) * f3) / f;
        float f5 = ((vert2fImmutable3.y() - vert2fImmutable4.y()) * f2 - (vert2fImmutable.y() - vert2fImmutable2.y()) * f3) / f;
        return vec3f.set(f4, f5, 0.0f);
    }

    public static boolean testTri2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, Vert2fImmutable vert2fImmutable5) {
        return VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable2, vert2fImmutable4, vert2fImmutable5) || VectorUtil.testSeg2SegIntersection(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5) || VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5);
    }

    public static boolean testTri2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, Vert2fImmutable vert2fImmutable5, float f) {
        return VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable2, vert2fImmutable4, vert2fImmutable5, f) || VectorUtil.testSeg2SegIntersection(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5, f) || VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5, f);
    }
}

