/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class AuthConfigFactoryImpl
extends AuthConfigFactory {
    private final Log log = LogFactory.getLog(AuthConfigFactoryImpl.class);
    private static final StringManager sm = StringManager.getManager(AuthConfigFactoryImpl.class);
    private static final String CONFIG_PATH = "conf/jaspic-providers.xml";
    private static final File CONFIG_FILE = new File(System.getProperty("catalina.base"), "conf/jaspic-providers.xml");
    private static final Object CONFIG_FILE_LOCK = new Object();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static String DEFAULT_REGISTRATION_ID = AuthConfigFactoryImpl.getRegistrationID(null, null);
    private final Map<String, RegistrationContextImpl> layerAppContextRegistrations = new ConcurrentHashMap<String, RegistrationContextImpl>();
    private final Map<String, RegistrationContextImpl> appContextRegistrations = new ConcurrentHashMap<String, RegistrationContextImpl>();
    private final Map<String, RegistrationContextImpl> layerRegistrations = new ConcurrentHashMap<String, RegistrationContextImpl>();
    private final Map<String, RegistrationContextImpl> defaultRegistration = new ConcurrentHashMap<String, RegistrationContextImpl>(1);

    public AuthConfigFactoryImpl() {
        this.loadPersistentRegistrations();
    }

    public AuthConfigProvider getConfigProvider(String string, String string2, RegistrationListener registrationListener) {
        RegistrationContextImpl registrationContextImpl = this.findRegistrationContextImpl(string, string2);
        if (registrationContextImpl != null) {
            if (registrationListener != null) {
                RegistrationListenerWrapper registrationListenerWrapper = new RegistrationListenerWrapper(string, string2, registrationListener);
                registrationContextImpl.addListener(registrationListenerWrapper);
            }
            return registrationContextImpl.getProvider();
        }
        return null;
    }

    public String registerConfigProvider(String string, Map map, String string2, String string3, String string4) {
        String string5 = this.doRegisterConfigProvider(string, map, string2, string3, string4);
        this.savePersistentRegistrations();
        return string5;
    }

    private String doRegisterConfigProvider(String string, Map map, String string2, String string3, String string4) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("authConfigFactoryImpl.registerClass", new Object[]{string, string2, string3}));
        }
        AuthConfigProvider authConfigProvider = null;
        if (string != null) {
            authConfigProvider = this.createAuthConfigProvider(string, map);
        }
        String string5 = AuthConfigFactoryImpl.getRegistrationID(string2, string3);
        RegistrationContextImpl registrationContextImpl = new RegistrationContextImpl(string2, string3, string4, true, authConfigProvider, map);
        this.addRegistrationContextImpl(string2, string3, string5, registrationContextImpl);
        return string5;
    }

    private AuthConfigProvider createAuthConfigProvider(String string, Map map) throws SecurityException {
        Class<?> clazz = null;
        AuthConfigProvider authConfigProvider = null;
        try {
            clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (clazz == null) {
                clazz = Class.forName(string);
            }
            Constructor<?> constructor = clazz.getConstructor(Map.class, AuthConfigFactory.class);
            authConfigProvider = (AuthConfigProvider)constructor.newInstance(map, null);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new SecurityException(exception);
        }
        return authConfigProvider;
    }

    public String registerConfigProvider(AuthConfigProvider authConfigProvider, String string, String string2, String string3) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("authConfigFactoryImpl.registerInstance", new Object[]{authConfigProvider.getClass().getName(), string, string2}));
        }
        String string4 = AuthConfigFactoryImpl.getRegistrationID(string, string2);
        RegistrationContextImpl registrationContextImpl = new RegistrationContextImpl(string, string2, string3, false, authConfigProvider, null);
        this.addRegistrationContextImpl(string, string2, string4, registrationContextImpl);
        return string4;
    }

    private void addRegistrationContextImpl(String string, String string2, String string3, RegistrationContextImpl registrationContextImpl) {
        block9: {
            RegistrationContextImpl registrationContextImpl2;
            block8: {
                Object object;
                registrationContextImpl2 = null;
                registrationContextImpl2 = string != null && string2 != null ? this.layerAppContextRegistrations.put(string3, registrationContextImpl) : (string == null && string2 != null ? this.appContextRegistrations.put(string3, registrationContextImpl) : (string != null && string2 == null ? this.layerRegistrations.put(string3, registrationContextImpl) : this.defaultRegistration.put(string3, registrationContextImpl)));
                if (registrationContextImpl2 != null) break block8;
                if (string != null && string2 != null && (object = this.appContextRegistrations.get(AuthConfigFactoryImpl.getRegistrationID(null, string2))) != null) {
                    for (Object object2 : ((RegistrationContextImpl)object).listeners) {
                        if (!string.equals(((RegistrationListenerWrapper)object2).getMessageLayer()) || !string2.equals(((RegistrationListenerWrapper)object2).getAppContext())) continue;
                        ((RegistrationContextImpl)object).listeners.remove(object2);
                        ((RegistrationListenerWrapper)object2).listener.notify(((RegistrationListenerWrapper)object2).messageLayer, ((RegistrationListenerWrapper)object2).appContext);
                    }
                }
                if (string2 != null) {
                    for (RegistrationContextImpl registrationContextImpl3 : this.layerRegistrations.values()) {
                        for (RegistrationListenerWrapper registrationListenerWrapper : registrationContextImpl3.listeners) {
                            if (!string2.equals(registrationListenerWrapper.getAppContext())) continue;
                            registrationContextImpl3.listeners.remove(registrationListenerWrapper);
                            registrationListenerWrapper.listener.notify(registrationListenerWrapper.messageLayer, registrationListenerWrapper.appContext);
                        }
                    }
                }
                if (string == null && string2 == null) break block9;
                for (RegistrationContextImpl registrationContextImpl4 : this.defaultRegistration.values()) {
                    for (RegistrationListenerWrapper registrationListenerWrapper : registrationContextImpl4.listeners) {
                        if ((string2 == null || !string2.equals(registrationListenerWrapper.getAppContext())) && (string == null || !string.equals(registrationListenerWrapper.getMessageLayer()))) continue;
                        registrationContextImpl4.listeners.remove(registrationListenerWrapper);
                        registrationListenerWrapper.listener.notify(registrationListenerWrapper.messageLayer, registrationListenerWrapper.appContext);
                    }
                }
                break block9;
            }
            for (RegistrationListenerWrapper registrationListenerWrapper : registrationContextImpl2.listeners) {
                registrationContextImpl2.listeners.remove(registrationListenerWrapper);
                registrationListenerWrapper.listener.notify(registrationListenerWrapper.messageLayer, registrationListenerWrapper.appContext);
            }
        }
    }

    public boolean removeRegistration(String string) {
        RegistrationContextImpl registrationContextImpl = null;
        if (DEFAULT_REGISTRATION_ID.equals(string)) {
            registrationContextImpl = this.defaultRegistration.remove(string);
        }
        if (registrationContextImpl == null) {
            registrationContextImpl = this.layerAppContextRegistrations.remove(string);
        }
        if (registrationContextImpl == null) {
            registrationContextImpl = this.appContextRegistrations.remove(string);
        }
        if (registrationContextImpl == null) {
            registrationContextImpl = this.layerRegistrations.remove(string);
        }
        if (registrationContextImpl == null) {
            return false;
        }
        for (RegistrationListenerWrapper registrationListenerWrapper : registrationContextImpl.listeners) {
            registrationListenerWrapper.getListener().notify(registrationListenerWrapper.getMessageLayer(), registrationListenerWrapper.getAppContext());
        }
        if (registrationContextImpl.isPersistent()) {
            this.savePersistentRegistrations();
        }
        return true;
    }

    public String[] detachListener(RegistrationListener registrationListener, String string, String string2) {
        String string3 = AuthConfigFactoryImpl.getRegistrationID(string, string2);
        RegistrationContextImpl registrationContextImpl = this.findRegistrationContextImpl(string, string2);
        if (registrationContextImpl != null && registrationContextImpl.removeListener(registrationListener)) {
            return new String[]{string3};
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getRegistrationIDs(AuthConfigProvider authConfigProvider) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (authConfigProvider == null) {
            arrayList.addAll(this.layerAppContextRegistrations.keySet());
            arrayList.addAll(this.appContextRegistrations.keySet());
            arrayList.addAll(this.layerRegistrations.keySet());
            if (!this.defaultRegistration.isEmpty()) {
                arrayList.add(DEFAULT_REGISTRATION_ID);
            }
        } else {
            this.findProvider(authConfigProvider, this.layerAppContextRegistrations, arrayList);
            this.findProvider(authConfigProvider, this.appContextRegistrations, arrayList);
            this.findProvider(authConfigProvider, this.layerRegistrations, arrayList);
            this.findProvider(authConfigProvider, this.defaultRegistration, arrayList);
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    private void findProvider(AuthConfigProvider authConfigProvider, Map<String, RegistrationContextImpl> map, List<String> list) {
        for (Map.Entry<String, RegistrationContextImpl> entry : map.entrySet()) {
            if (!authConfigProvider.equals(entry.getValue().getProvider())) continue;
            list.add(entry.getKey());
        }
    }

    public AuthConfigFactory.RegistrationContext getRegistrationContext(String string) {
        AuthConfigFactory.RegistrationContext registrationContext = this.defaultRegistration.get(string);
        if (registrationContext == null) {
            registrationContext = this.layerAppContextRegistrations.get(string);
        }
        if (registrationContext == null) {
            registrationContext = this.appContextRegistrations.get(string);
        }
        if (registrationContext == null) {
            registrationContext = this.layerRegistrations.get(string);
        }
        return registrationContext;
    }

    public void refresh() {
        this.loadPersistentRegistrations();
    }

    private static String getRegistrationID(String string, String string2) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException(sm.getString("authConfigFactoryImpl.zeroLengthMessageLayer"));
        }
        if (string2 != null && string2.length() == 0) {
            throw new IllegalArgumentException(sm.getString("authConfigFactoryImpl.zeroLengthAppContext"));
        }
        return (string == null ? "" : string) + ":" + (string2 == null ? "" : string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPersistentRegistrations() {
        Object object = CONFIG_FILE_LOCK;
        synchronized (object) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authConfigFactoryImpl.load", new Object[]{CONFIG_FILE.getAbsolutePath()}));
            }
            if (!CONFIG_FILE.isFile()) {
                return;
            }
            PersistentProviderRegistrations.Providers providers = PersistentProviderRegistrations.loadProviders(CONFIG_FILE);
            for (PersistentProviderRegistrations.Provider provider : providers.getProviders()) {
                this.doRegisterConfigProvider(provider.getClassName(), provider.getProperties(), provider.getLayer(), provider.getAppContext(), provider.getDescription());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePersistentRegistrations() {
        Object object = CONFIG_FILE_LOCK;
        synchronized (object) {
            PersistentProviderRegistrations.Providers providers = new PersistentProviderRegistrations.Providers();
            this.savePersistentProviders(providers, this.layerAppContextRegistrations);
            this.savePersistentProviders(providers, this.appContextRegistrations);
            this.savePersistentProviders(providers, this.layerRegistrations);
            this.savePersistentProviders(providers, this.defaultRegistration);
            PersistentProviderRegistrations.writeProviders(providers, CONFIG_FILE);
        }
    }

    private void savePersistentProviders(PersistentProviderRegistrations.Providers providers, Map<String, RegistrationContextImpl> map) {
        for (Map.Entry<String, RegistrationContextImpl> entry : map.entrySet()) {
            this.savePersistentProvider(providers, entry.getValue());
        }
    }

    private void savePersistentProvider(PersistentProviderRegistrations.Providers providers, RegistrationContextImpl registrationContextImpl) {
        if (registrationContextImpl != null && registrationContextImpl.isPersistent()) {
            PersistentProviderRegistrations.Provider provider = new PersistentProviderRegistrations.Provider();
            provider.setAppContext(registrationContextImpl.getAppContext());
            if (registrationContextImpl.getProvider() != null) {
                provider.setClassName(registrationContextImpl.getProvider().getClass().getName());
            }
            provider.setDescription(registrationContextImpl.getDescription());
            provider.setLayer(registrationContextImpl.getMessageLayer());
            for (Map.Entry entry : registrationContextImpl.getProperties().entrySet()) {
                provider.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            providers.addProvider(provider);
        }
    }

    private RegistrationContextImpl findRegistrationContextImpl(String string, String string2) {
        RegistrationContextImpl registrationContextImpl = this.layerAppContextRegistrations.get(AuthConfigFactoryImpl.getRegistrationID(string, string2));
        if (registrationContextImpl == null) {
            registrationContextImpl = this.appContextRegistrations.get(AuthConfigFactoryImpl.getRegistrationID(null, string2));
        }
        if (registrationContextImpl == null) {
            registrationContextImpl = this.layerRegistrations.get(AuthConfigFactoryImpl.getRegistrationID(string, null));
        }
        if (registrationContextImpl == null) {
            registrationContextImpl = this.defaultRegistration.get(DEFAULT_REGISTRATION_ID);
        }
        return registrationContextImpl;
    }

    private static class RegistrationContextImpl
    implements AuthConfigFactory.RegistrationContext {
        private final String messageLayer;
        private final String appContext;
        private final String description;
        private final boolean persistent;
        private final AuthConfigProvider provider;
        private final Map<String, String> properties;
        private final List<RegistrationListenerWrapper> listeners = new CopyOnWriteArrayList<RegistrationListenerWrapper>();

        private RegistrationContextImpl(String string, String string2, String string3, boolean bl, AuthConfigProvider authConfigProvider, Map<String, String> map) {
            this.messageLayer = string;
            this.appContext = string2;
            this.description = string3;
            this.persistent = bl;
            this.provider = authConfigProvider;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (map != null) {
                hashMap.putAll(map);
            }
            this.properties = Collections.unmodifiableMap(hashMap);
        }

        public String getMessageLayer() {
            return this.messageLayer;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        private AuthConfigProvider getProvider() {
            return this.provider;
        }

        private void addListener(RegistrationListenerWrapper registrationListenerWrapper) {
            if (registrationListenerWrapper != null) {
                this.listeners.add(registrationListenerWrapper);
            }
        }

        private Map<String, String> getProperties() {
            return this.properties;
        }

        private boolean removeListener(RegistrationListener registrationListener) {
            boolean bl = false;
            for (RegistrationListenerWrapper registrationListenerWrapper : this.listeners) {
                if (!registrationListenerWrapper.getListener().equals(registrationListener)) continue;
                this.listeners.remove(registrationListenerWrapper);
                bl = true;
            }
            return bl;
        }
    }

    private static class RegistrationListenerWrapper {
        private final String messageLayer;
        private final String appContext;
        private final RegistrationListener listener;

        RegistrationListenerWrapper(String string, String string2, RegistrationListener registrationListener) {
            this.messageLayer = string;
            this.appContext = string2;
            this.listener = registrationListener;
        }

        public String getMessageLayer() {
            return this.messageLayer;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public RegistrationListener getListener() {
            return this.listener;
        }
    }
}

