import { ASTNode, Color, ColorInformation, ColorPresentation, LanguageServiceParams, LanguageSettings, DocumentLanguageSettings, FoldingRange, JSONSchema, SelectionRange, FoldingRangesContext, DocumentSymbolsContext, ColorInformationContext as DocumentColorsContext, TextDocument, Position, CompletionItem, CompletionList, Hover, Range, SymbolInformation, Diagnostic, TextEdit, FormattingOptions, DocumentSymbol, DefinitionLink, MatchingSchema, JSONLanguageStatus, SortOptions } from './jsonLanguageTypes';
import { DocumentLink } from 'vscode-languageserver-types';
export type JSONDocument = {
    root: ASTNode | undefined;
    getNodeFromOffset(offset: number, includeRightBound?: boolean): ASTNode | undefined;
};
export * from './jsonLanguageTypes';
export interface LanguageService {
    configure(settings: LanguageSettings): void;
    doValidation(document: TextDocument, jsonDocument: JSONDocument, documentSettings?: DocumentLanguageSettings, schema?: JSONSchema): PromiseLike<Diagnostic[]>;
    parseJSONDocument(document: TextDocument): JSONDocument;
    newJSONDocument(rootNode: ASTNode | undefined, syntaxDiagnostics?: Diagnostic[], comments?: Range[]): JSONDocument;
    resetSchema(uri: string): boolean;
    getMatchingSchemas(document: TextDocument, jsonDocument: JSONDocument, schema?: JSONSchema): PromiseLike<MatchingSchema[]>;
    getLanguageStatus(document: TextDocument, jsonDocument: JSONDocument): JSONLanguageStatus;
    doResolve(item: CompletionItem): PromiseLike<CompletionItem>;
    doComplete(document: TextDocument, position: Position, doc: JSONDocument): PromiseLike<CompletionList | null>;
    findDocumentSymbols(document: TextDocument, doc: JSONDocument, context?: DocumentSymbolsContext): SymbolInformation[];
    findDocumentSymbols2(document: TextDocument, doc: JSONDocument, context?: DocumentSymbolsContext): DocumentSymbol[];
    findDocumentColors(document: TextDocument, doc: JSONDocument, context?: DocumentColorsContext): PromiseLike<ColorInformation[]>;
    getColorPresentations(document: TextDocument, doc: JSONDocument, color: Color, range: Range): ColorPresentation[];
    doHover(document: TextDocument, position: Position, doc: JSONDocument): PromiseLike<Hover | null>;
    getFoldingRanges(document: TextDocument, context?: FoldingRangesContext): FoldingRange[];
    getSelectionRanges(document: TextDocument, positions: Position[], doc: JSONDocument): SelectionRange[];
    findDefinition(document: TextDocument, position: Position, doc: JSONDocument): PromiseLike<DefinitionLink[]>;
    findLinks(document: TextDocument, doc: JSONDocument): PromiseLike<DocumentLink[]>;
    format(document: TextDocument, range: Range, options: FormattingOptions): TextEdit[];
    sort(document: TextDocument, options: SortOptions): TextEdit[];
}
export declare function getLanguageService(params: LanguageServiceParams): LanguageService;
