import type { LanguageServiceContext } from '@volar/language-service';
import type * as vscode from 'vscode-languageserver-protocol';
import type { URI } from 'vscode-uri';
import { AttrNameCasing, TagNameCasing } from './types';
export declare function convertTagName(context: LanguageServiceContext, uri: URI, casing: TagNameCasing, tsPluginClient: import('@vue/typescript-plugin/lib/requests').Requests | undefined): Promise<vscode.TextEdit[] | undefined>;
export declare function convertAttrName(context: LanguageServiceContext, uri: URI, casing: AttrNameCasing, tsPluginClient?: import('@vue/typescript-plugin/lib/requests').Requests): Promise<vscode.TextEdit[] | undefined>;
export declare function getNameCasing(context: LanguageServiceContext, uri: URI): Promise<{
    tag: TagNameCasing;
    attr: AttrNameCasing;
}>;
export declare function detect(context: LanguageServiceContext, uri: URI): Promise<{
    tag: TagNameCasing[];
    attr: AttrNameCasing[];
}>;
