"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementAttrs = exports.getComponentDirectives = exports.getComponentEvents = exports.getQuickInfoAtPosition = exports.getPropertiesAtLocation = exports.getImportPathForFile = exports.collectExtractProps = void 0;
exports.getComponentProps = getComponentProps;
exports.getComponentNames = getComponentNames;
const utils_1 = require("./utils");
exports.collectExtractProps = createRequest('collectExtractProps');
exports.getImportPathForFile = createRequest('getImportPathForFile');
exports.getPropertiesAtLocation = createRequest('getPropertiesAtLocation');
exports.getQuickInfoAtPosition = createRequest('getQuickInfoAtPosition');
// Component Infos
async function getComponentProps(fileName, componentName) {
    const server = await (0, utils_1.getBestServer)(fileName);
    if (!server) {
        return;
    }
    return await server.getComponentProps(fileName, componentName);
}
exports.getComponentEvents = createRequest('getComponentEvents');
exports.getComponentDirectives = createRequest('getComponentDirectives');
async function getComponentNames(fileName) {
    const server = await (0, utils_1.getBestServer)(fileName);
    if (!server) {
        return;
    }
    const componentAndProps = server.componentNamesAndProps.get(fileName);
    if (!componentAndProps) {
        return;
    }
    return Object.keys(componentAndProps);
}
exports.getElementAttrs = createRequest('getElementAttrs');
function createRequest(requestType) {
    return async function (...[fileName, ...rest]) {
        const server = await (0, utils_1.getBestServer)(fileName);
        if (!server) {
            return;
        }
        return server.sendRequest(requestType, fileName, ...rest);
    };
}
//# sourceMappingURL=client.js.map