/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ExtensionPopupMenu;
import org.zaproxy.zap.extension.history.PopupMenuPurgeSites;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;
import org.zaproxy.zap.view.popup.PopupMenuUtils;

public class MainPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -3021348328961418293L;
    private List<JMenuItem> itemList = null;
    private PopupMenuPurgeSites popupMenuPurgeSites = null;
    Map<String, ExtensionPopupMenu> superMenus = new HashMap<String, ExtensionPopupMenu>();
    View view = null;
    private static final Logger LOGGER = LogManager.getLogger(MainPopupMenu.class);
    private MenuSelectionChangeListener menuSelectionChangeListener;
    private MenuElement[] pathSelectedMenu;

    public MainPopupMenu(View view) {
        this.initialize();
        this.view = view;
    }

    public MainPopupMenu(String arg0, View view) {
        super(arg0);
        this.view = view;
    }

    public MainPopupMenu(List<JMenuItem> itemList, View view) {
        this(view);
        this.itemList = itemList;
        Collections.sort(this.itemList, (o1, o2) -> Integer.compare(MainPopupMenu.getWeight(o2), MainPopupMenu.getWeight(o1)));
    }

    private static int getWeight(Component component) {
        if (component instanceof ExtensionPopupMenuComponent) {
            return ((ExtensionPopupMenuComponent)((Object)component)).getWeight();
        }
        return 1000;
    }

    private void initialize() {
        this.add(this.getPopupMenuPurgeSites(29070));
        this.menuSelectionChangeListener = new MenuSelectionChangeListener();
        this.addPopupMenuListener(new MenuSelectionListenerInstaller());
    }

    public void show(MessageContainer<?> invoker, int x, int y) {
        this.showImpl(PopupMenuUtils.getPopupMenuInvokerWrapper(invoker), x, y);
    }

    @Override
    public synchronized void show(Component invoker, int x, int y) {
        this.showImpl(PopupMenuUtils.getPopupMenuInvokerWrapper(invoker), x, y);
    }

    private synchronized void showImpl(PopupMenuUtils.PopupMenuInvokerWrapper invoker, int x, int y) {
        int i;
        for (i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            try {
                if (component == null || !(component instanceof ExtensionPopupMenuItem)) continue;
                ExtensionPopupMenuItem menuItem = (ExtensionPopupMenuItem)component;
                menuItem.setVisible(invoker.isEnable(menuItem));
                if (!Control.getSingleton().getMode().equals((Object)Control.Mode.safe) || menuItem.isSafe()) continue;
                menuItem.setEnabled(false);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        for (i = 0; i < this.itemList.size(); ++i) {
            JMenuItem menuItem = this.itemList.get(i);
            if (menuItem instanceof ExtensionPopupMenuItem) {
                this.handleMenuItem(invoker, (ExtensionPopupMenuItem)menuItem);
                continue;
            }
            if (!(menuItem instanceof ExtensionPopupMenu)) continue;
            ExtensionPopupMenu item = (ExtensionPopupMenu)menuItem;
            this.handleMenu(invoker, item);
        }
        int lastWeight = 0;
        for (int i2 = this.getComponentCount() - 1; i2 >= 1; --i2) {
            Component c = this.getComponent(i2);
            int thisWeight = MainPopupMenu.getWeight(c) / 100;
            if (lastWeight == thisWeight) continue;
            this.add((Component)new JPopupMenu.Separator(), i2 + 1);
            lastWeight = thisWeight;
        }
        PopupMenuUtils.removeTopAndBottomSeparators(this);
        if (PopupMenuUtils.isAtLeastOneChildComponentVisible(this)) {
            super.show(invoker.getComponent(), x, y);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            ExtensionPopupMenuComponent selectedMenuComponent = null;
            if (this.pathSelectedMenu != null) {
                MenuElement selectedMenuElement = this.pathSelectedMenu[this.pathSelectedMenu.length - 1];
                if (PopupMenuUtils.isExtensionPopupMenuComponent(selectedMenuElement)) {
                    selectedMenuComponent = (ExtensionPopupMenuComponent)((Object)selectedMenuElement);
                }
                this.pathSelectedMenu = null;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!PopupMenuUtils.isExtensionPopupMenuComponent(component)) continue;
                ((ExtensionPopupMenuComponent)((Object)component)).dismissed(selectedMenuComponent);
            }
        }
    }

    private void handleMenuItem(PopupMenuUtils.PopupMenuInvokerWrapper popupMenuInvoker, ExtensionPopupMenuItem menuItem) {
        try {
            if (menuItem != ExtensionHookMenu.POPUP_MENU_SEPARATOR && popupMenuInvoker.isEnable(menuItem)) {
                if (menuItem.isSubMenu()) {
                    ExtensionPopupMenu superMenu = this.getSuperMenu(menuItem.getParentMenuName(), menuItem.getParentWeight());
                    if (menuItem.isDummyItem()) {
                        superMenu.setEnabled(false);
                    } else {
                        superMenu.add(menuItem);
                        superMenu.setEnabled(true);
                    }
                } else {
                    this.addMenuItem(menuItem, menuItem.getWeight());
                }
            }
            if (Control.getSingleton().getMode().equals((Object)Control.Mode.safe) && !menuItem.isSafe()) {
                menuItem.setEnabled(false);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleMenu(PopupMenuUtils.PopupMenuInvokerWrapper popupMenuInvoker, ExtensionPopupMenu menu) {
        try {
            if (popupMenuInvoker.isEnable(menu)) {
                if (menu.isSubMenu()) {
                    ExtensionPopupMenu superMenu = this.getSuperMenu(menu.getParentMenuName(), menu.getParentWeight());
                    superMenu.add(menu);
                } else {
                    this.addMenuItem(menu, menu.getWeight());
                }
                if (Control.getSingleton().getMode().equals((Object)Control.Mode.safe) && !menu.isSafe()) {
                    menu.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private ExtensionPopupMenu getSuperMenu(String name, int weight) {
        ExtensionPopupMenu superMenu = this.superMenus.get(name);
        if (superMenu == null) {
            superMenu = new ExtensionPopupMenu(name){
                private static final long serialVersionUID = 6825880451078204378L;

                @Override
                public boolean isEnableForComponent(Component invoker) {
                    return true;
                }
            };
            this.superMenus.put(name, superMenu);
            superMenu.setWeight(weight);
            this.addMenuItem(superMenu, weight);
        }
        return superMenu;
    }

    private void addMenuItem(JMenuItem menuItem, int weight) {
        int newIndex = -1;
        if (weight > 0) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component c = this.getComponent(i);
                if (weight <= MainPopupMenu.getWeight(c)) continue;
                newIndex = i;
                break;
            }
        }
        this.add((Component)menuItem, newIndex);
    }

    private PopupMenuPurgeSites getPopupMenuPurgeSites(int weight) {
        if (this.popupMenuPurgeSites == null) {
            this.popupMenuPurgeSites = new PopupMenuPurgeSites();
            this.popupMenuPurgeSites.setWeight(weight);
        }
        return this.popupMenuPurgeSites;
    }

    public void addMenu(ExtensionPopupMenuItem menu) {
        this.itemList.add(menu);
    }

    public void removeMenu(ExtensionPopupMenuItem menu) {
        this.itemList.remove(menu);
    }

    public void addMenu(ExtensionPopupMenu menu) {
        this.itemList.add(menu);
    }

    public void removeMenu(ExtensionPopupMenu menu) {
        this.itemList.remove(menu);
    }

    private class MenuSelectionChangeListener
    implements ChangeListener {
        private MenuSelectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MainPopupMenu.this.pathSelectedMenu = MenuSelectionManager.defaultManager().getSelectedPath();
        }
    }

    private class MenuSelectionListenerInstaller
    implements PopupMenuListener {
        private MenuSelectionListenerInstaller() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            MenuSelectionManager.defaultManager().addChangeListener(MainPopupMenu.this.menuSelectionChangeListener);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            MenuSelectionManager.defaultManager().removeChangeListener(MainPopupMenu.this.menuSelectionChangeListener);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            MainPopupMenu.this.pathSelectedMenu = null;
        }
    }
}

