"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.extend = void 0;
const exposes = __importStar(require("./exposes"));
const utils = __importStar(require("./utils"));
const e = exposes.presets;
const ea = exposes.access;
const extend = {
    dimmerLoadControlMode: () => {
        const attribute = 0x7600;
        const data_type = 0x20;
        const value_map = {
            0: "leading_edge_control",
            1: "trailing_edge_control",
        };
        const value_lookup = {
            leading_edge_control: 0,
            trailing_edge_control: 1,
        };
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_load_control_mode: value_map[value] || "unknown",
                            dimmer_load_control_mode_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_load_control_mode"],
                convertSet: async (entity, key, value, meta) => {
                    utils.assertString(value);
                    const numericValue = value_lookup[value] ?? Number.parseInt(value, 10);
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_load_control_mode: value } };
                },
                convertGet: async (entity, key, meta) => {
                    await entity.read("genBasic", [attribute]);
                },
            },
        ];
        const exposes = [
            e.enum("dimmer_load_control_mode", ea.ALL, ["leading_edge_control", "trailing_edge_control"]).withLabel("Load Control Mode"),
        ];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer load control mode attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerSwitchMode: () => {
        const attribute = 0x7700;
        const data_type = 0x20;
        const value_map = {
            0: "momentary_switch",
            1: "toggle_switch",
            2: "roller_blind_switch",
        };
        const value_lookup = {
            momentary_switch: 0,
            toggle_switch: 1,
            roller_blind_switch: 2,
        };
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_switch_mode: value_map[value] || "unknown",
                            dimmer_switch_mode_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_switch_mode"],
                convertSet: async (entity, key, value, meta) => {
                    utils.assertString(value);
                    const numericValue = value_lookup[value] ?? Number.parseInt(value, 10);
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_switch_mode: value } };
                },
                convertGet: async (entity, key, meta) => {
                    await entity.read("genBasic", [attribute]);
                },
            },
        ];
        const exposes = [
            e.enum("dimmer_switch_mode", ea.ALL, ["momentary_switch", "toggle_switch", "roller_blind_switch"]).withLabel("Switch Mode"),
        ];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer switch mode attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerInvertSwitch: () => {
        const attribute = 0x7701;
        const data_type = 0x10;
        const value_map = {
            0: "disabled",
            1: "enabled",
        };
        const value_lookup = {
            disabled: 0,
            enabled: 1,
        };
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_invert_switch: value_map[value] || "unknown",
                            dimmer_invert_switch_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_invert_switch"],
                convertSet: async (entity, key, value, meta) => {
                    utils.assertString(value);
                    const numericValue = value_lookup[value] ?? Number.parseInt(value, 10);
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_invert_switch: value } };
                },
            },
        ];
        const exposes = [e.enum("dimmer_invert_switch", ea.STATE_SET, ["disabled", "enabled"]).withLabel("Invert Switch")];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer invert switch attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerSceneActivation: () => {
        const attribute = 0x7702;
        const data_type = 0x10;
        const value_map = {
            0: "disabled",
            1: "enabled",
        };
        const value_lookup = {
            disabled: 0,
            enabled: 1,
        };
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_scene_activation: value_map[value] || "unknown",
                            dimmer_scene_activation_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_scene_activation"],
                convertSet: async (entity, key, value, meta) => {
                    utils.assertString(value);
                    const numericValue = value_lookup[value] ?? Number.parseInt(value, 10);
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_scene_activation: value } };
                },
            },
        ];
        const exposes = [e.enum("dimmer_scene_activation", ea.STATE_SET, ["disabled", "enabled"]).withLabel("Scene Activation")];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer scene activation attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerS1DoubleClickScene: () => {
        const attribute = 0x7703;
        const data_type = 0x20;
        const value_map = {
            0: "null",
            1: "on",
            2: "off",
            3: "dimming_up",
            4: "dimming_down",
            5: "dimming_to_brightest",
            6: "dimming_to_darkest",
        };
        const value_lookup = {
            null: 0,
            on: 1,
            off: 2,
            dimming_up: 3,
            dimming_down: 4,
            dimming_to_brightest: 5,
            dimming_to_darkest: 6,
        };
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_s1_double_click_scene: value_map[value] || "unknown",
                            dimmer_s1_double_click_scene_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_s1_double_click_scene"],
                convertSet: async (entity, key, value, meta) => {
                    utils.assertString(value);
                    const numericValue = value_lookup[value] ?? Number.parseInt(value, 10);
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_s1_double_click_scene: value } };
                },
            },
        ];
        const exposes = [
            e
                .enum("dimmer_s1_double_click_scene", ea.STATE_SET, [
                "null",
                "on",
                "off",
                "dimming_up",
                "dimming_down",
                "dimming_to_brightest",
                "dimming_to_darkest",
            ])
                .withLabel("S1 Double Click Scene"),
        ];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer s1 double click scene attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerS2DoubleClickScene: () => {
        const attribute = 0x7704;
        const data_type = 0x20;
        const value_map = {
            0: "null",
            1: "on",
            2: "off",
            3: "dimming_up",
            4: "dimming_down",
            5: "dimming_to_brightest",
            6: "dimming_to_darkest",
        };
        const value_lookup = {
            null: 0,
            on: 1,
            off: 2,
            dimming_up: 3,
            dimming_down: 4,
            dimming_to_brightest: 5,
            dimming_to_darkest: 6,
        };
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_s2_double_click_scene: value_map[value] || "unknown",
                            dimmer_s2_double_click_scene_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_s2_double_click_scene"],
                convertSet: async (entity, key, value, meta) => {
                    utils.assertString(value);
                    const numericValue = value_lookup[value] ?? Number.parseInt(value, 10);
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_s2_double_click_scene: value } };
                },
            },
        ];
        const exposes = [
            e
                .enum("dimmer_s2_double_click_scene", ea.STATE_SET, [
                "null",
                "on",
                "off",
                "dimming_up",
                "dimming_down",
                "dimming_to_brightest",
                "dimming_to_darkest",
            ])
                .withLabel("S2 Double Click Scene"),
        ];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer s2 double click scene attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerMinBrightnessLevel: () => {
        const attribute = 0x7800;
        const data_type = 0x20;
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_min_brightness_level_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_min_brightness_level"],
                convertSet: async (entity, key, value, meta) => {
                    const numericValue = value;
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_min_brightness_level: value } };
                },
            },
        ];
        const exposes = [
            e
                .numeric("dimmer_min_brightness_level", ea.STATE_SET)
                .withValueMin(1)
                .withValueMax(100)
                .withValueStep(1)
                .withLabel("Min Brightness Level"),
        ];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer min brightness level attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerMaxBrightnessLevel: () => {
        const attribute = 0x7801;
        const data_type = 0x20;
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_max_brightness_level_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_max_brightness_level"],
                convertSet: async (entity, key, value, meta) => {
                    const numericValue = value;
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_max_brightness_level: value } };
                },
            },
        ];
        const exposes = [
            e
                .numeric("dimmer_max_brightness_level", ea.STATE_SET)
                .withValueMin(1)
                .withValueMax(100)
                .withValueStep(1)
                .withLabel("Max Brightness Level"),
        ];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer max brightness level attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerManualDimmingStepSize: () => {
        const attribute = 0x7802;
        const data_type = 0x20;
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_manual_dimming_step_size_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_manual_dimming_step_size"],
                convertSet: async (entity, key, value, meta) => {
                    const numericValue = value;
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_manual_dimming_step_size: value } };
                },
            },
        ];
        const exposes = [
            e
                .numeric("dimmer_manual_dimming_step_size", ea.STATE_SET)
                .withValueMin(1)
                .withValueMax(25)
                .withValueStep(1)
                .withLabel("Manual Dimming Step Size"),
        ];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer manual dimming step size attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
    dimmerManualDimmingTime: () => {
        const attribute = 0x7803;
        const data_type = 0x21;
        const fromZigbee = [
            {
                cluster: "genBasic",
                type: ["attributeReport", "readResponse"],
                convert: (model, msg, publish, options, meta) => {
                    if (Object.prototype.hasOwnProperty.call(msg.data, attribute)) {
                        const value = msg.data[attribute];
                        return {
                            dimmer_manual_dimming_time_numeric: value,
                        };
                    }
                    return undefined;
                },
            },
        ];
        const toZigbee = [
            {
                key: ["dimmer_manual_dimming_time"],
                convertSet: async (entity, key, value, meta) => {
                    const numericValue = value;
                    await entity.write("genBasic", { [attribute]: { value: numericValue, type: data_type } });
                    return { state: { dimmer_manual_dimming_time: value } };
                },
            },
        ];
        const exposes = [
            e
                .numeric("dimmer_manual_dimming_time", ea.STATE_SET)
                .withUnit("ms")
                .withValueMin(100)
                .withValueMax(10000)
                .withValueStep(100)
                .withLabel("Manual Dimming Time"),
        ];
        const configure = [
            async (device, coordinatorEndpoint, definition) => {
                const endpoint = device.getEndpoint(1);
                try {
                    await endpoint.read("genBasic", [attribute]);
                }
                catch (error) {
                    console.warn(`Failed to read dimmer manual dimming time attribute: ${error}`);
                }
            },
        ];
        return {
            fromZigbee,
            toZigbee,
            exposes,
            configure,
            isModernExtend: true,
        };
    },
};
exports.extend = extend;
//# sourceMappingURL=adurosmart.js.map