# (c) Copyright 2009-2022. CodeWeavers, Inc.

from gi.repository import Gtk

import cxaiemedia
import cxguitools
import distversion

from cxutils import _


class PreferencesDialogController:

    def __init__(self, transient_for):
        # ----------------------------------------------------------------------
        #  Setup the GUI
        # ----------------------------------------------------------------------
        self.xml = Gtk.Builder()
        self.xml.set_translation_domain("crossover")
        self.xml.add_from_file(cxguitools.get_ui_path("cxprefs"))
        self.xml.connect_signals(self)

        self.xml.get_object("applyCxfixesLabel").set_label(_("Install recommended %(platform)s packages") % {
            'platform': distversion.PLATFORM})

        self.update_cache_label()

        dialog = self.xml.get_object("PrefsDialog")
        dialog.props.transient_for = transient_for
        dialog.show()

    def get_window(self):
        return self.xml.get_object("PrefsDialog")

    def update_cache_label(self):
        size = cxaiemedia.size_cached_installers()

        self.xml.get_object('ClearCacheButton').set_sensitive(size != 0)

        if size == 0:
            message = _("There are currently no downloaded installers saved locally.")
        elif size < 1024 * 1024:
            message = _("Downloaded installers are currently using %0.1f KB of disk space.") % (size / 1024)
        elif size < 1024 * 1024 * 1024:
            message = _("Downloaded installers are currently using %0.1f MB of disk space.") % (size / (1024 * 1024))
        else:
            message = _("Downloaded installers are currently using %0.1f GB of disk space.") % (size / (1024 * 1024 * 1024))

        self.xml.get_object('InstallerCacheLabel').set_text(message)

    def on_ClearCacheButton_clicked(self, _widget):
        cxaiemedia.delete_cached_installers()

        self.update_cache_label()

    def quit_requested(self, *_args):
        self.xml.get_object("PrefsDialog").destroy()
